/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fl.formplugin.feeshare;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;
import kd.tmc.fl.common.bean.LeaseShareInfo;
import kd.tmc.fl.common.helper.LeaseFeeHelper;
import kd.tmc.fl.common.helper.LeaseFeeShareHelper;
import kd.tmc.fl.formplugin.resource.FlFormResourceEnum;

public class LeaseFeeShareEdit
extends AbstractTmcBillEdit {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"clearlab"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String billStatus = (String)this.getModel().getValue("billstatus");
        if (BillStatusEnum.AUDIT.getValue().equals(billStatus)) {
            this.setDefaultVal();
        }
        if (OperationStatus.ADDNEW == this.getView().getFormShowParameter().getStatus()) {
            this.createEntryDatas();
        }
        boolean isInit = this.controlEnableByInit();
        this.setDetailEnable(isInit);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult operationResult = args.getOperationResult();
        if (operationResult == null || !operationResult.isSuccess()) {
            return;
        }
        switch (args.getOperateKey()) {
            case "formcalculation": {
                this.createEntryDatas();
                break;
            }
            case "unaudit": {
                this.getView().invokeOperation("refresh");
                break;
            }
            case "audit": {
                this.getView().updateView();
                this.setDefaultVal();
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        if ("clearlab".equals(((Control)evt.getSource()).getKey())) {
            int entryRowCount = this.getModel().getEntryRowCount("entryentity");
            boolean isAdjust = false;
            for (int i = 0; i < entryRowCount; ++i) {
                BigDecimal adjustAmt = (BigDecimal)this.getModel().getValue("e_adjustmentamount", i);
                if (!EmptyUtil.isNoEmpty((BigDecimal)adjustAmt)) continue;
                isAdjust = true;
                break;
            }
            if (isAdjust) {
                this.getView().showConfirm(FlFormResourceEnum.LeaseFeeShareEdit_0.loadKDString(), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("clearlab", (IFormPlugin)this));
            } else {
                this.getView().showTipNotification(FlFormResourceEnum.LeaseFeeShareEdit_1.loadKDString());
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("clearlab".equals(callBackId) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            int entryRowCount = this.getModel().getEntryRowCount("entryentity");
            this.getModel().beginInit();
            for (int i = 0; i < entryRowCount; ++i) {
                BigDecimal adjustAmt = (BigDecimal)this.getModel().getValue("e_adjustmentamount", i);
                boolean isVoucher = (Boolean)this.getModel().getValue("e_isvoucher", i);
                if (isVoucher || !EmptyUtil.isNoEmpty((BigDecimal)adjustAmt)) continue;
                this.getModel().setValue("e_adjustmentamount", (Object)0, i);
                this.getModel().setValue("e_actualamount", this.getModel().getValue("e_accrualinterest", i), i);
            }
            this.getModel().endInit();
            this.getView().updateView("entryentity");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String prop;
        switch (prop = e.getProperty().getName()) {
            case "e_adjustmentamount": {
                ChangeData[] changeData = e.getChangeSet();
                this.adjustAmount((BigDecimal)changeData[0].getOldValue());
                break;
            }
            case "sharefrequency": {
                this.createEntryDatas();
            }
        }
    }

    private boolean controlEnableByInit() {
        Set billIds;
        Set voucherBills;
        DynamicObjectCollection shareBills;
        String billStatus = (String)this.getModel().getValue("billstatus");
        if (!BillStatusEnum.SAVE.getValue().equals(billStatus)) {
            return false;
        }
        boolean isInit = (Boolean)this.getModel().getValue("isinit");
        DynamicObject conbill = (DynamicObject)this.getModel().getValue("conbillno");
        if (isInit && EmptyUtil.isNoEmpty((DynamicObject)conbill) && EmptyUtil.isNoEmpty((DynamicObjectCollection)(shareBills = QueryServiceHelper.query((String)"fl_leasefeeshare", (String)"id", (QFilter[])new QFilter[]{new QFilter("conbillno", "=", conbill.getPkValue()).and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("isvoucher", "=", (Object)"1")}))) && EmptyUtil.isNoEmpty((Object)(voucherBills = LeaseFeeShareHelper.getVoucherBills(billIds = shareBills.stream().map(o -> o.getLong("id")).collect(Collectors.toSet()), (String)"fl_leasefeeshare")))) {
            isInit = false;
        }
        int entryRowCount = this.getModel().getEntryRowCount("entryentity");
        for (int i = 0; i < entryRowCount; ++i) {
            this.getView().setEnable(Boolean.valueOf(isInit), i, new String[]{"e_endcostamt", "e_isvoucher"});
        }
        return isInit;
    }

    private void setDetailEnable(boolean isInit) {
        String billStatus = (String)this.getModel().getValue("billstatus");
        if (!BillStatusEnum.SAVE.getValue().equals(billStatus) || isInit) {
            return;
        }
        boolean hasVoucher = false;
        int entryRowCount = this.getModel().getEntryRowCount("entryentity");
        for (int i = 0; i < entryRowCount; ++i) {
            boolean isVoucher = (Boolean)this.getModel().getValue("e_isvoucher", i);
            this.getView().setEnable(Boolean.valueOf(!isVoucher), i, new String[]{"e_adjustmentamount"});
            hasVoucher = hasVoucher || isVoucher;
        }
        this.getView().setEnable(Boolean.valueOf(!hasVoucher), new String[]{"sharefrequency"});
    }

    private void adjustAmount(BigDecimal oldAmount) {
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        BigDecimal actualAmount = (BigDecimal)this.getModel().getValue("e_actualamount", entryCurrentRowIndex);
        BigDecimal adjustAmt = (BigDecimal)this.getModel().getValue("e_adjustmentamount", entryCurrentRowIndex);
        if (EmptyUtil.isNoEmpty((BigDecimal)oldAmount)) {
            adjustAmt = adjustAmt.subtract(oldAmount);
        }
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"e_actualamount", (Object)actualAmount.add(adjustAmt), (int)entryCurrentRowIndex);
    }

    private void setDefaultVal() {
        this.getModel().setValue("hsharefrequency", this.getModel().getValue("sharefrequency"));
        this.getModel().setValue("hirr", this.getModel().getValue("irr"));
        this.getModel().setValue("hfeeamount", this.getModel().getValue("feeamount"));
    }

    private void createEntryDatas() {
        long contractId = ((DynamicObject)this.getModel().getValue("conbillno")).getLong("id");
        long currencyId = ((DynamicObject)this.getModel().getValue("currency")).getLong("id");
        long orgId = ((DynamicObject)this.getModel().getValue("org")).getLong("id");
        Map feeAmountMap = LeaseFeeHelper.getFeeAmountMap((long)contractId, (Date)((Date)this.getModel().getValue("expiredate")), (long)currencyId, (long)orgId);
        BigDecimal feeAmount = feeAmountMap.values().stream().reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        BigDecimal payPlanAmount = LeaseFeeHelper.getPayPlanAmount((long)contractId);
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"feeamount", (Object)feeAmount.add(payPlanAmount));
        try {
            List leaseShareDetails = LeaseFeeShareHelper.getLeaseShareDetails((DynamicObject)this.getModel().getDataEntity(), (Map)feeAmountMap);
            this.batchCreateEntrys(leaseShareDetails);
            this.getModel().setDataChanged(false);
        }
        catch (KDBizException kde) {
            this.getView().showTipNotification(kde.getMessage(), Integer.valueOf(6000));
            return;
        }
        catch (Exception e) {
            this.getView().showTipNotification(FlFormResourceEnum.LeaseFeeShareEdit_2.loadKDString(ExceptionUtils.getExceptionStackTraceMessage((Exception)e)), Integer.valueOf(6000));
            return;
        }
        this.getView().showSuccessNotification(FlFormResourceEnum.LeaseFeeShareEdit_3.loadKDString());
    }

    private void batchCreateEntrys(List<LeaseShareInfo> costShareInfoList) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        model.deleteEntryData("entryentity");
        if (EmptyUtil.isEmpty(costShareInfoList)) {
            model.endInit();
            return;
        }
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("e_period", new Object[0]);
        vs.addField("e_startdate", new Object[0]);
        vs.addField("e_enddate", new Object[0]);
        vs.addField("e_day", new Object[0]);
        vs.addField("e_begincostamt", new Object[0]);
        vs.addField("e_curfeeamt", new Object[0]);
        vs.addField("e_curguaamt", new Object[0]);
        vs.addField("e_currepurchaseamt", new Object[0]);
        vs.addField("e_rentamt", new Object[0]);
        vs.addField("e_principal", new Object[0]);
        vs.addField("e_intamt", new Object[0]);
        vs.addField("e_accrualinterest", new Object[0]);
        vs.addField("e_repayamt", new Object[0]);
        vs.addField("e_adjustmentamount", new Object[0]);
        vs.addField("e_actualamount", new Object[0]);
        vs.addField("e_endcostamt", new Object[0]);
        vs.addField("e_guaincomeamt", new Object[0]);
        vs.addField("e_guabalanceamt", new Object[0]);
        vs.addField("e_isvoucher", new Object[0]);
        vs.addField("e_islock", new Object[0]);
        BigDecimal ytm = BigDecimal.ZERO;
        for (LeaseShareInfo info : costShareInfoList) {
            ytm = info.getYtm();
            String startDateStr = DateUtils.formatString((Date)info.getStartDate(), (String)"yyyy-MM-dd");
            String endDateStr = DateUtils.formatString((Date)info.getEndDate(), (String)"yyyy-MM-dd");
            Object[] rowData = new Object[]{startDateStr + "-" + endDateStr, info.getStartDate(), info.getEndDate(), info.getDays(), info.getBegincostamt(), info.getCurfeeamt(), info.getCurguaamt(), info.getCurrepurchaseamt(), info.getRentamt(), info.getPrincipal(), info.getIntamt(), info.getAccrualinterest(), info.getRepayamt(), BigDecimal.ZERO, info.getAccrualinterest(), info.getEndcostamt(), info.getGuaincomeamt(), info.getGuabalanceamt(), info.isVoucher(), info.isLock()};
            vs.addRow(rowData);
        }
        model.batchCreateNewEntryRow("entryentity", vs);
        model.endInit();
        this.getView().updateView("entryentity");
        model.setValue("irr", (Object)(EmptyUtil.isEmpty((BigDecimal)ytm) ? BigDecimal.ZERO : ytm.multiply(Constants.ONE_HUNDRED)));
        boolean isInit = this.controlEnableByInit();
        this.setDetailEnable(isInit);
    }
}

