/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fl.formplugin.rentplan;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fl.common.enums.ExecuteStatusEnum;
import kd.tmc.fl.formplugin.resource.FlFormResourceEnum;

public class RentPlanBillImportPlugin
extends AbstractBasePlugIn {
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getOperateKey().equals("entryimport")) {
            this.getView().showConfirm(FlFormResourceEnum.RentPlanBillImportPlugin_0.loadKDString(), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("importConfirm", (IFormPlugin)this));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("importConfirm".equals(callBackId) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            this.showImportForm();
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        if (StringUtils.equals((CharSequence)"fl_entryimport", (CharSequence)event.getActionId()) && EmptyUtil.isNoEmpty((Object)event.getReturnData())) {
            this.handleImportData(event.getReturnData().toString());
        }
    }

    private void showImportForm() {
        FormShowParameter showForm = new FormShowParameter();
        showForm.setFormId("fl_entryimport");
        showForm.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, String> params = new HashMap<String, String>(16);
        params.put("BillFormId", "fl_leasecontractbill");
        params.put("BillEntryId", "entry_rentplan");
        showForm.setCustomParams(params);
        showForm.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "fl_entryimport"));
        this.getView().showForm(showForm);
    }

    private void handleImportData(String dataStr) {
        Map returnData = (Map)SerializationUtils.fromJsonString((String)dataStr, Map.class);
        this.deleteEntry();
        List importData = (List)returnData.get("rowDatas");
        if (null != importData && importData.size() > 0) {
            this.fillImportData(importData);
        }
    }

    private void deleteEntry() {
        int entryRowCount = this.getModel().getEntryRowCount("entry_rentplan");
        ArrayList<Integer> removeIndexes = new ArrayList<Integer>();
        for (int rowIndex = 0; rowIndex < entryRowCount; ++rowIndex) {
            String executeStatus = (String)this.getModel().getValue("executestatus", rowIndex);
            if (!ExecuteStatusEnum.isUnExecuted((String)executeStatus)) continue;
            removeIndexes.add(rowIndex);
        }
        if (EmptyUtil.isNoEmpty(removeIndexes)) {
            this.getModel().deleteEntryRows("entry_rentplan", removeIndexes.stream().mapToInt(Integer::intValue).toArray());
        }
    }

    private void fillImportData(List<Map<String, String>> importData) {
        TableValueSetter vs = new TableValueSetter(new String[0]);
        Map<String, Object> bankAcctMap = this.loadBankAcct(importData);
        String entityName = this.getModel().getDataEntityType().getName();
        for (Map<String, String> dataMap : importData) {
            vs.addField("paydate", new Object[]{this.parseDate(dataMap.get("paydate"))});
            vs.addField("startrevdate", new Object[]{this.parseDate(dataMap.get("startrevdate"))});
            vs.addField("endrevdate", new Object[]{this.parseDate(dataMap.get("endrevdate"))});
            vs.addField("rentamt", new Object[]{dataMap.get("rentamt")});
            vs.addField("principal", new Object[]{dataMap.get("principal")});
            vs.addField("intamt", new Object[]{dataMap.get("intamt")});
            vs.addField("taxrate", new Object[]{dataMap.get("taxrate")});
            vs.addField("taxamt", new Object[]{dataMap.get("taxamt")});
            vs.addField("excludetaxamt", new Object[]{dataMap.get("excludetaxamt")});
            vs.addField("residueamt", new Object[]{dataMap.get("residueamt")});
            vs.addField("payacct", new Object[]{bankAcctMap.get(dataMap.get("payacct.bankaccountnumber"))});
            vs.addField("notes", new Object[]{dataMap.get("notes")});
            String exeStatus = dataMap.get("executestatus");
            if (StringUtils.equals((CharSequence)entityName, (CharSequence)"fl_leasecontractbill") || StringUtils.equals((CharSequence)entityName, (CharSequence)"fl_payplanbill") || EmptyUtil.isEmpty((String)exeStatus)) {
                exeStatus = ExecuteStatusEnum.UNEXECUTE.getValue();
            }
            vs.addField("executestatus", new Object[]{exeStatus});
        }
        this.getPageCache().put("importflag", "true");
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.batchCreateNewEntryRow("entry_rentplan", vs);
    }

    private Map<String, Object> loadBankAcct(List<Map<String, String>> importData) {
        List bankNumbers = importData.stream().map(v -> (String)v.get("payacct.bankaccountnumber")).collect(Collectors.toList());
        DynamicObjectCollection banks = QueryServiceHelper.query((String)"bd_accountbanks", (String)"id,bankaccountnumber", (QFilter[])new QFilter[]{new QFilter("number", "in", bankNumbers)});
        return banks.stream().collect(Collectors.toMap(v -> v.getString("bankaccountnumber"), r -> r.get("id")));
    }

    private Date parseDate(String DateStr) {
        if (EmptyUtil.isNoEmpty((String)DateStr)) {
            return DateUtils.stringToDate((String)DateStr, (String)"yyyy-MM-dd");
        }
        return null;
    }
}

