/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fl.business.helper;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.tmc.fbp.common.helper.DynamicObjectCompareHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fl.common.enums.ExecuteStatusEnum;

public class ContractTransformHelper {
    public static List<String> RENTPLAN_FIELDS = new ArrayList<String>();
    public static List<String> LEASEHOLD_FIELDS = new ArrayList<String>();
    public static List<String> HEAD_FIELDS = new ArrayList<String>();

    public static boolean checkPayPlanChange(DynamicObject contractTransform, DynamicObject contractBill) {
        DynamicObjectCollection planEntry = contractBill.getDynamicObjectCollection("entry_rentplan");
        List executedPlans = planEntry.stream().filter(v -> ExecuteStatusEnum.isExecuted((String)v.getString("executestatus"))).collect(Collectors.toList());
        DynamicObjectCollection newPlanEntry = contractTransform.getDynamicObjectCollection("entry_rentplan");
        Map newPlanMap = newPlanEntry.stream().collect(Collectors.toMap(v -> v.getDate("paydate"), Function.identity()));
        for (DynamicObject executedPlan : executedPlans) {
            DynamicObject newPlan;
            Date payDate = executedPlan.getDate("paydate");
            if (payDate instanceof Timestamp) {
                payDate = new Date(payDate.getTime());
            }
            if (ContractTransformHelper.compareTransForm(executedPlan, newPlan = (DynamicObject)newPlanMap.get(payDate), RENTPLAN_FIELDS)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkLeashHoldChange(DynamicObject contractTransform, DynamicObject contractBill) {
        return contractBill.getBoolean("haspushcard") && !ContractTransformHelper.compareTransForm(contractTransform, contractBill, LEASEHOLD_FIELDS);
    }

    public static Map<Object, DynamicObject> loadContractDataMap(List<DynamicObject> contractTransforms) {
        MainEntityType type;
        Object[] ids = contractTransforms.stream().map(v -> v.getDynamicObject("loancontractbill")).filter(EmptyUtil::isNoEmpty).map(DataEntityBase::getPkValue).toArray();
        Object[] contractBills = TmcDataServiceHelper.load((Object[])ids, (DynamicObjectType)(type = EntityMetadataCache.getDataEntityType((String)"fl_leasecontractbill")));
        if (EmptyUtil.isNoEmpty((Object[])contractBills)) {
            return Arrays.stream(contractBills).collect(Collectors.toMap(DataEntityBase::getPkValue, Function.identity()));
        }
        return Collections.emptyMap();
    }

    private static boolean compareTransForm(DynamicObject oldObj, DynamicObject newObj, List<String> fields) {
        Map differMap = DynamicObjectCompareHelper.entriesDiffering((DynamicObject)oldObj, (DynamicObject)newObj);
        for (String field : fields) {
            if (!differMap.containsKey(field)) continue;
            return false;
        }
        return true;
    }

    static {
        RENTPLAN_FIELDS.add("paydate");
        RENTPLAN_FIELDS.add("startrevdate");
        RENTPLAN_FIELDS.add("endrevdate");
        RENTPLAN_FIELDS.add("rentamt");
        RENTPLAN_FIELDS.add("principal");
        RENTPLAN_FIELDS.add("intamt");
        RENTPLAN_FIELDS.add("taxrate");
        RENTPLAN_FIELDS.add("taxamt");
        RENTPLAN_FIELDS.add("excludetaxamt");
        RENTPLAN_FIELDS.add("residueamt");
        RENTPLAN_FIELDS.add("payacct");
        RENTPLAN_FIELDS.add("notes");
        RENTPLAN_FIELDS.add("executestatus");
        LEASEHOLD_FIELDS.add("leaseholdtype");
        LEASEHOLD_FIELDS.add("leaseholdtypeid");
        LEASEHOLD_FIELDS.add("leasehold");
        LEASEHOLD_FIELDS.add("leaseholdid");
        LEASEHOLD_FIELDS.add("repurchaseamt");
        LEASEHOLD_FIELDS.add("assetcount");
        LEASEHOLD_FIELDS.add("unit");
        LEASEHOLD_FIELDS.add("repurchase");
        LEASEHOLD_FIELDS.add("address");
        HEAD_FIELDS.add("term");
        HEAD_FIELDS.add("enddate");
        HEAD_FIELDS.add("startinterestrate");
        HEAD_FIELDS.add("referencerate");
        HEAD_FIELDS.add("ratesign");
        HEAD_FIELDS.add("ratefloatpoint");
    }
}

