/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fl.business.opservice.contract.init;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.CreditLimitServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fl.common.enums.ExecuteStatusEnum;
import kd.tmc.fl.common.helper.RepaymentbillHelper;

public class LeaseContractInitUnAuditService
extends AbstractTmcBizOppService {
    private static Log logger = LogFactory.getLog(LeaseContractInitUnAuditService.class);
    private static final String[] PAY_INIT_PROPS = new String[]{"id", "billno", "entrys.id"};
    private static final String[] REPAY_PROPS = new String[]{"loans", "loans.e_loanbill", "billno"};

    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("billstatus");
        sic.add("entry_rentplan");
        sic.add("paydate");
        sic.add("startrevdate");
        sic.add("endrevdate");
        sic.add("rentamt");
        sic.add("principal");
        sic.add("intamt");
        sic.add("executestatus");
        sic.add("payedrent");
        sic.add("unpayedrent");
        sic.add("amount");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        List contractPkList = Arrays.stream(dataEntities).map(dyn -> (Long)dyn.getPkValue()).collect(Collectors.toList());
        DynamicObjectCollection receiptBills = QueryServiceHelper.query((String)"fl_receiptbill", (String)"id", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", contractPkList)});
        DynamicObject[] rentPayBills = null;
        DynamicObjectCollection interestBills = null;
        if (!EmptyUtil.isEmpty((DynamicObjectCollection)receiptBills)) {
            Set loanPkList = receiptBills.stream().map(dyn -> dyn.getLong("id")).collect(Collectors.toSet());
            rentPayBills = TmcDataServiceHelper.load((String)"fl_rentpaybill", (String)String.join((CharSequence)",", REPAY_PROPS), (QFilter[])new QFilter[]{new QFilter("loans.e_loanbill", "in", loanPkList)});
            interestBills = QueryServiceHelper.query((String)"cfm_interestbill", (String)String.join((CharSequence)",", PAY_INIT_PROPS), (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", loanPkList)});
        }
        OperateOption create = OperateOption.create();
        create.setVariableValue("byInit", "true");
        if (null != interestBills && !interestBills.isEmpty()) {
            DynamicObject[] interestPks = new HashSet(interestBills.size());
            for (DynamicObject interestBill : interestBills) {
                interestPks.add(interestBill.getLong("id"));
            }
            TmcOperateServiceHelper.execOperate((String)"deleteinit", (String)"cfm_interestbill", (Object[])interestPks.toArray(), (OperateOption)create);
        }
        if (null != rentPayBills && rentPayBills.length > 0) {
            for (DynamicObject repaymentBill : rentPayBills) {
                RepaymentbillHelper.batchCancelReturnCreditLimit((DynamicObject)repaymentBill);
            }
            HashSet<Long> repaymentPks = new HashSet<Long>(rentPayBills.length);
            for (DynamicObject repaymentBill : rentPayBills) {
                repaymentPks.add((Long)repaymentBill.getPkValue());
            }
            RepaymentbillHelper.cancelReturnGuaranteeUse((DynamicObject[])rentPayBills);
            logger.info("---delete repaymentDelBills--------------" + repaymentPks.size());
            TmcOperateServiceHelper.execOperate((String)"deleteinit", (String)"fl_rentpaybill", (Object[])repaymentPks.toArray(), (OperateOption)create);
        }
        if (!EmptyUtil.isEmpty((DynamicObjectCollection)receiptBills)) {
            Set loanPkList = receiptBills.stream().map(dyn -> dyn.getLong("id")).collect(Collectors.toSet());
            logger.info("---delete loanDelBills--------------" + loanPkList.size());
            TmcOperateServiceHelper.execOperate((String)"deleteinit", (String)"fl_receiptbill", (Object[])loanPkList.toArray(), (OperateOption)create);
        }
        for (DynamicObject contract : dataEntities) {
            this.cancelCreditLimit(contract);
            DynamicObjectCollection rentPlan = contract.getDynamicObjectCollection("entry_rentplan");
            List filterrentPlan = rentPlan.stream().filter(f -> ExecuteStatusEnum.isExecuted((String)f.getString("executestatus"))).collect(Collectors.toList());
            if (EmptyUtil.isNoEmpty(filterrentPlan)) {
                BigDecimal payedrent = filterrentPlan.stream().map(o -> o.getBigDecimal("principal")).reduce(BigDecimal::add).get();
                contract.set("payedrent", (Object)payedrent);
                contract.set("unpayedrent", (Object)contract.getBigDecimal("amount").subtract(payedrent));
            } else {
                contract.set("payedrent", (Object)0);
                contract.set("unpayedrent", (Object)0);
            }
            AttachmentServiceHelper.remove((String)"fl_leasecontractbill", (Object)contract.getLong("ID"));
        }
    }

    private void cancelCreditLimit(DynamicObject contract) {
        if (EmptyUtil.isNoEmpty((DynamicObject)contract.getDynamicObject("creditlimit"))) {
            CreditLimitServiceHelper.cancelCreditLimit((DynamicObject)contract, null, (boolean)false);
        }
    }
}

