/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fl.business.opservice.feeshare;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class LeaseFeeShareAuditService
extends AbstractTmcBizOppService {
    public void process(DynamicObject[] dataEntities) throws KDException {
        Set sbillID = Arrays.stream(dataEntities).map(o -> o.getDynamicObject("conbillno").getLong("ID")).collect(Collectors.toSet());
        DynamicObject[] contractBills = TmcDataServiceHelper.load((String)"fl_leasecontractbill", (String)"id,irr", (QFilter[])new QFilter[]{new QFilter("id", "in", sbillID)});
        Map<Object, DynamicObject> bondMap = Arrays.stream(contractBills).collect(Collectors.toMap(DataEntityBase::getPkValue, DynamicObject2 -> DynamicObject2));
        for (DynamicObject bill : dataEntities) {
            long contractId = bill.getDynamicObject("conbillno").getLong("ID");
            DynamicObject contractBill = bondMap.get(contractId);
            contractBill.set("irr", bill.get("irr"));
        }
        this.setEntryToBill(dataEntities);
        SaveServiceHelper.save((DynamicObject[])contractBills);
    }

    private void setEntryToBill(DynamicObject[] datas) {
        ArrayList<DynamicObject> dataList = new ArrayList<DynamicObject>();
        ArrayList<Pair> srcTarIds = new ArrayList<Pair>(datas.length);
        for (DynamicObject data : datas) {
            DynamicObject contractBill = data.getDynamicObject("conbillno");
            DynamicObjectCollection entryColls = data.getDynamicObjectCollection("entryentity");
            List entrys = entryColls.parallelStream().filter(o -> !o.getBoolean("e_islock")).collect(Collectors.toList());
            if (EmptyUtil.isNoEmpty(entrys)) {
                DynamicObject entry = (DynamicObject)entrys.get(0);
                dataList.add(this.createBillFromEntry(entry, data));
                entrys.remove(entry);
            }
            long[] idsArr = DB.genLongIds((String)data.getDynamicObjectType().getAlias(), (int)entrys.size());
            for (int i = 0; i < entrys.size(); ++i) {
                DynamicObject entry = (DynamicObject)entrys.get(i);
                DynamicObject newBill = TmcDataServiceHelper.clone((DynamicObject)data);
                newBill.set("id", (Object)idsArr[i]);
                newBill.getDynamicObjectCollection("entryentity").clear();
                dataList.add(this.createBillFromEntry(entry, newBill));
                srcTarIds.add(Pair.of((Object)contractBill.getLong("id"), (Object)newBill.getLong("id")));
            }
            entryColls.clear();
        }
        if (srcTarIds.size() > 0) {
            TmcBotpHelper.batchSaveRelation((String)"fl_leasecontractbill", (String)"fl_leasefeeshare", srcTarIds);
        }
        SaveServiceHelper.save((DynamicObject[])dataList.toArray(new DynamicObject[0]));
    }

    private DynamicObject createBillFromEntry(DynamicObject entry, DynamicObject data) {
        data.set("periodstartdate", (Object)entry.getDate("e_startdate"));
        data.set("periodenddate", (Object)entry.getDate("e_enddate"));
        data.set("day", (Object)entry.getInt("e_day"));
        data.set("begincostamt", (Object)entry.getBigDecimal("e_begincostamt"));
        data.set("curfeeamt", (Object)entry.getBigDecimal("e_curfeeamt"));
        data.set("curguaamt", (Object)entry.getBigDecimal("e_curguaamt"));
        data.set("currepurchaseamt", (Object)entry.getBigDecimal("e_currepurchaseamt"));
        data.set("rentamt", (Object)entry.getBigDecimal("e_rentamt"));
        data.set("principal", (Object)entry.getBigDecimal("e_principal"));
        data.set("intamt", (Object)entry.getBigDecimal("e_intamt"));
        data.set("accrualinterest", (Object)entry.getBigDecimal("e_accrualinterest"));
        data.set("repayamt", (Object)entry.getBigDecimal("e_repayamt"));
        data.set("adjustmentamount", (Object)entry.getBigDecimal("e_adjustmentamount"));
        data.set("actualamount", (Object)entry.getBigDecimal("e_actualamount"));
        data.set("endcostamt", (Object)entry.getBigDecimal("e_endcostamt"));
        data.set("guaincomeamt", (Object)entry.getBigDecimal("e_guaincomeamt"));
        data.set("guabalanceamt", (Object)entry.getBigDecimal("e_guabalanceamt"));
        data.set("isvoucher", (Object)entry.getBoolean("e_isvoucher"));
        return data;
    }
}

