/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fl.business.opservice.feeshare;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BaseEnableEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fl.common.helper.LeaseFeeShareHelper;

public class LeaseFeeShareUnAuditService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("conbillno");
        selector.add("entryentity");
        selector.add("periodstartdate");
        selector.add("periodenddate");
        selector.add("day");
        selector.add("begincostamt");
        selector.add("curfeeamt");
        selector.add("curguaamt");
        selector.add("currepurchaseamt");
        selector.add("rentamt");
        selector.add("principal");
        selector.add("intamt");
        selector.add("accrualinterest");
        selector.add("repayamt");
        selector.add("adjustmentamount");
        selector.add("actualamount");
        selector.add("endcostamt");
        selector.add("guabalanceamt");
        selector.add("guaincomeamt");
        selector.add("isvoucher");
        selector.add("conirr");
        selector.add("e_period");
        selector.add("e_startdate");
        selector.add("e_enddate");
        selector.add("e_day");
        selector.add("e_begincostamt");
        selector.add("e_curfeeamt");
        selector.add("e_curguaamt");
        selector.add("e_currepurchaseamt");
        selector.add("e_rentamt");
        selector.add("e_principal");
        selector.add("e_intamt");
        selector.add("e_accrualinterest");
        selector.add("e_repayamt");
        selector.add("e_adjustmentamount");
        selector.add("e_actualamount");
        selector.add("e_endcostamt");
        selector.add("e_guabalanceamt");
        selector.add("e_guaincomeamt");
        selector.add("e_isvoucher");
        selector.add("e_islock");
        selector.add("isinit");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        HashMap<Long, BigDecimal> billIdMaps = new HashMap<Long, BigDecimal>(dataEntities.length);
        HashSet<Long> conTractIds = new HashSet<Long>();
        for (DynamicObject bill : dataEntities) {
            Long sourceBillId = bill.getDynamicObject("conbillno").getLong("id");
            if (billIdMaps.containsKey(sourceBillId)) continue;
            conTractIds.add(sourceBillId);
            billIdMaps.put(sourceBillId, bill.getBigDecimal("conirr"));
            DynamicObject[] costBills = TmcDataServiceHelper.load((String)"fl_leasefeeshare", (String)"id,periodstartdate,periodenddate,day,begincostamt,curfeeamt,curguaamt,currepurchaseamt,rentamt,principal,intamt,accrualinterest,repayamt,adjustmentamount,actualamount,endcostamt,guaincomeamt,guabalanceamt,isvoucher", (QFilter[])new QFilter[]{new QFilter("conbillno", "=", (Object)sourceBillId).and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue())});
            List<DynamicObject> costList = Arrays.stream(costBills).sorted(Comparator.comparing(o -> o.getDate("periodstartdate"))).collect(Collectors.toList());
            this.setEntryToBill(costList, bill);
        }
        if (conTractIds.size() > 0) {
            DynamicObject[] contractBills;
            for (DynamicObject contractBill : contractBills = TmcDataServiceHelper.load((String)"fl_leasecontractbill", (String)"id,irr", (QFilter[])new QFilter[]{new QFilter("id", "in", billIdMaps.keySet())})) {
                contractBill.set("irr", billIdMaps.get(contractBill.getLong("id")));
            }
            SaveServiceHelper.save((DynamicObject[])contractBills);
        }
    }

    private void setEntryToBill(List<DynamicObject> costList, DynamicObject bill) {
        DynamicObject lastVoucherEntry = null;
        if (bill.getBoolean("isinit")) {
            Set voucherBills = LeaseFeeShareHelper.getVoucherBills(costList.parallelStream().map(o -> o.getLong("id")).collect(Collectors.toSet()), (String)"fl_leasefeeshare");
            lastVoucherEntry = costList.stream().filter(o -> voucherBills.contains(o.getLong("id"))).max(Comparator.comparing(o -> o.getDate("periodstartdate"))).orElse(null);
        } else {
            lastVoucherEntry = costList.stream().filter(o -> o.getBoolean("isvoucher")).max(Comparator.comparing(o -> o.getDate("periodstartdate"))).orElse(null);
        }
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entryentity");
        bill.set("periodstartdate", null);
        bill.set("periodenddate", null);
        bill.set("day", (Object)0);
        bill.set("begincostamt", (Object)BigDecimal.ZERO);
        bill.set("curfeeamt", (Object)BigDecimal.ZERO);
        bill.set("curguaamt", (Object)BigDecimal.ZERO);
        bill.set("currepurchaseamt", (Object)BigDecimal.ZERO);
        bill.set("rentamt", (Object)BigDecimal.ZERO);
        bill.set("principal", (Object)BigDecimal.ZERO);
        bill.set("intamt", (Object)BigDecimal.ZERO);
        bill.set("accrualinterest", (Object)BigDecimal.ZERO);
        bill.set("repayamt", (Object)BigDecimal.ZERO);
        bill.set("adjustmentamount", (Object)BigDecimal.ZERO);
        bill.set("actualamount", (Object)BigDecimal.ZERO);
        bill.set("endcostamt", (Object)BigDecimal.ZERO);
        bill.set("guaincomeamt", (Object)BigDecimal.ZERO);
        bill.set("guabalanceamt", (Object)BigDecimal.ZERO);
        bill.set("isvoucher", (Object)false);
        entrys.clear();
        HashSet<Long> deletIds = new HashSet<Long>(costList.size());
        for (DynamicObject cost : costList) {
            DynamicObject entry = entrys.addNew();
            Date startDate = cost.getDate("periodstartdate");
            Date endDate = cost.getDate("periodenddate");
            entry.set("e_period", (Object)(DateUtils.formatString((Date)startDate, (String)"yyyy-MM-dd") + "-" + DateUtils.formatString((Date)endDate, (String)"yyyy-MM-dd")));
            entry.set("e_startdate", (Object)startDate);
            entry.set("e_enddate", (Object)endDate);
            entry.set("e_day", (Object)cost.getInt("day"));
            entry.set("e_begincostamt", (Object)cost.getBigDecimal("begincostamt"));
            entry.set("e_curfeeamt", (Object)cost.getBigDecimal("curfeeamt"));
            entry.set("e_curguaamt", (Object)cost.getBigDecimal("curguaamt"));
            entry.set("e_currepurchaseamt", (Object)cost.getBigDecimal("currepurchaseamt"));
            entry.set("e_rentamt", (Object)cost.getBigDecimal("rentamt"));
            entry.set("e_principal", (Object)cost.getBigDecimal("principal"));
            entry.set("e_intamt", (Object)cost.getBigDecimal("intamt"));
            entry.set("e_accrualinterest", (Object)cost.getBigDecimal("accrualinterest"));
            entry.set("e_repayamt", (Object)cost.getBigDecimal("repayamt"));
            entry.set("e_adjustmentamount", (Object)cost.getBigDecimal("adjustmentamount"));
            entry.set("e_actualamount", (Object)cost.getBigDecimal("actualamount"));
            entry.set("e_endcostamt", (Object)cost.getBigDecimal("endcostamt"));
            entry.set("e_guaincomeamt", (Object)cost.getBigDecimal("guaincomeamt"));
            entry.set("e_guabalanceamt", (Object)cost.getBigDecimal("guabalanceamt"));
            entry.set("e_isvoucher", (Object)cost.getBoolean("isvoucher"));
            if (lastVoucherEntry != null && lastVoucherEntry.getDate("periodstartdate").compareTo(startDate) >= 0) {
                entry.set("e_islock", (Object)BaseEnableEnum.ENABLE.getValue());
            }
            if (entry.getBoolean("e_islock") || cost.getLong("id") == bill.getLong("id")) continue;
            deletIds.add(cost.getLong("id"));
        }
        if (EmptyUtil.isNoEmpty(deletIds)) {
            TmcOperateServiceHelper.execOperate((String)"deletedetail", (String)"fl_leasefeeshare", (Object[])deletIds.toArray(), (OperateOption)OperateOption.create());
        }
    }
}

