/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fl.business.opservice.transform;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fl.business.helper.ContractTransformHelper;
import kd.tmc.fl.business.helper.PayPlanUpdateHelper;

public class ContractTransformAuditService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("entry_rentplan");
        selector.add("paydate");
        selector.add("startrevdate");
        selector.add("endrevdate");
        selector.add("rentamt");
        selector.add("principal");
        selector.add("loancontractbill");
        selector.add("intamt");
        selector.add("taxrate");
        selector.add("taxamt");
        selector.add("excludetaxamt");
        selector.add("residueamt");
        selector.add("payacct");
        selector.add("leaseholdid");
        selector.add("notes");
        selector.add("leaseholdtype");
        selector.add("leaseholdtypeid");
        selector.add("leasehold");
        selector.add("repurchaseamt");
        selector.add("assetcount");
        selector.add("unit");
        selector.add("repurchase");
        selector.add("address");
        selector.add("term");
        selector.add("enddate");
        selector.add("startinterestrate");
        selector.add("ratesign");
        selector.add("ratefloatpoint");
        selector.add("interestrate");
        selector.add("referencerate");
        selector.add("entry_rentplan");
        selector.add("entry_rentplan.executestatus");
        selector.add("entry_rentplan.paydate");
        selector.add("entry_rentplan.startrevdate");
        selector.add("entry_rentplan.endrevdate");
        selector.add("entry_rentplan.rentamt");
        selector.add("entry_rentplan.principal");
        selector.add("entry_rentplan.intamt");
        selector.add("entry_rentplan.taxrate");
        selector.add("entry_rentplan.taxamt");
        selector.add("entry_rentplan.excludetaxamt");
        selector.add("entry_rentplan.residueamt");
        selector.add("entry_rentplan.payacct");
        selector.add("entry_rentplan.notes");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        this.updateTransformContract(dataEntities);
        this.updateReceiptBills(dataEntities);
    }

    private void updateTransformContract(DynamicObject[] dataEntities) {
        Map<Object, DynamicObject> contractDataMap = ContractTransformHelper.loadContractDataMap(Arrays.asList(dataEntities));
        ArrayList<DynamicObject> waiteUpdateContracts = new ArrayList<DynamicObject>();
        for (DynamicObject contractTransform : dataEntities) {
            Object contractBillId = contractTransform.getDynamicObject("loancontractbill").getPkValue();
            DynamicObject contractBill = contractDataMap.get(contractBillId);
            if (null == contractBill) continue;
            this.copyValue(contractTransform, contractBill, ContractTransformHelper.LEASEHOLD_FIELDS);
            this.copyValue(contractTransform, contractBill, ContractTransformHelper.HEAD_FIELDS);
            this.copyPlanEntry(contractTransform, contractBill);
            waiteUpdateContracts.add(contractBill);
        }
        if (EmptyUtil.isNoEmpty(waiteUpdateContracts)) {
            SaveServiceHelper.save((DynamicObject[])waiteUpdateContracts.toArray(new DynamicObject[0]));
        }
    }

    private void updateReceiptBills(DynamicObject[] dataEntities) {
        Object[] ids = Arrays.stream(dataEntities).map(v -> v.getDynamicObject("loancontractbill").getPkValue()).toArray();
        String queryFields = "entry_rentplan,executestatus,intamt,startrevdate,endrevdate,amount,payacct,notes,startinterestrate,contractstatus,principal,paydate";
        DynamicObject[] contractBills = TmcDataServiceHelper.load((String)"fl_leasecontractbill", (String)queryFields, (QFilter[])new QFilter("id", "in", (Object)ids).toArray());
        ArrayList<DynamicObject> waiteUpdateReceipt = new ArrayList<DynamicObject>();
        for (DynamicObject contractBill : contractBills) {
            waiteUpdateReceipt.addAll(PayPlanUpdateHelper.updateReceiptPlan(contractBill, null));
        }
        if (EmptyUtil.isNoEmpty(waiteUpdateReceipt)) {
            SaveServiceHelper.save((DynamicObject[])waiteUpdateReceipt.toArray(new DynamicObject[0]));
        }
    }

    private void copyPlanEntry(DynamicObject contractTransform, DynamicObject contractBill) {
        DynamicObjectCollection oldPlan = contractBill.getDynamicObjectCollection("entry_rentplan");
        DynamicObjectCollection newPlan = contractTransform.getDynamicObjectCollection("entry_rentplan");
        oldPlan.clear();
        int index = 0;
        for (DynamicObject plan : newPlan) {
            DynamicObject newRow = oldPlan.addNew();
            newRow.set("seq", (Object)index++);
            this.copyValue(plan, newRow, ContractTransformHelper.RENTPLAN_FIELDS);
        }
    }

    private void copyValue(DynamicObject fromObj, DynamicObject toObj, List<String> fields) {
        for (String field : fields) {
            if (StringUtils.equals((CharSequence)field, (CharSequence)"startinterestrate")) {
                toObj.set(field, fromObj.get("interestrate"));
                continue;
            }
            toObj.set(field, fromObj.get(field));
        }
    }
}

