/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fl.business.validate.contractbill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fl.business.resource.FlBusinessResourceEnum;

public class LeaseContractPushRealCardValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("billstatus");
        selector.add("haspushcard");
        selector.add("leaseholdid");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        List<Object> selectCards = this.getSelectCards(dataEntity);
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            Long leaseholdId;
            boolean hasPushCard;
            DynamicObject contractBill = extendedDataEntity.getDataEntity();
            String billStatus = contractBill.getString("billstatus");
            if (!BillStatusEnum.isAudit((String)billStatus)) {
                this.addErrorMessage(extendedDataEntity, FlBusinessResourceEnum.LeaseContractPushRealCardValidator_0.loadKDString());
            }
            if (hasPushCard = contractBill.getBoolean("haspushcard")) {
                this.addErrorMessage(extendedDataEntity, FlBusinessResourceEnum.LeaseContractPushRealCardValidator_1.loadKDString());
            }
            if (!EmptyUtil.isNoEmpty((Long)(leaseholdId = Long.valueOf(contractBill.getLong("leaseholdid")))) || !selectCards.contains(leaseholdId)) continue;
            this.addErrorMessage(extendedDataEntity, FlBusinessResourceEnum.LeaseContractPushRealCardValidator_2.loadKDString());
        }
    }

    private List<Object> getSelectCards(ExtendedDataEntity[] dataEntity) {
        Object[] cardIds = Arrays.stream(dataEntity).map(ExtendedDataEntity::getDataEntity).map(v -> v.getLong("leaseholdid")).filter(EmptyUtil::isNoEmpty).toArray();
        if (EmptyUtil.isEmpty((Object[])cardIds)) {
            return new ArrayList<Object>();
        }
        DynamicObjectCollection existCard = QueryServiceHelper.query((String)"fa_card_real", (String)"id", (QFilter[])new QFilter("id", "in", (Object)cardIds).toArray());
        return existCard.stream().map(v -> v.getLong("id")).collect(Collectors.toList());
    }
}

