/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fl.business.validate.contractbill.init;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fl.business.resource.FlBusinessResourceEnum;

public class LeaseContractInitUnAuditValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("datasource");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        Set initIds = Arrays.stream(dataEntities).map(dyn -> (Long)dyn.getDataEntity().getPkValue()).collect(Collectors.toSet());
        DynamicObjectCollection loanBills = QueryServiceHelper.query((String)"fl_receiptbill", (String)"id,isinit", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", initIds)});
        block0: for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject initBill = dataEntity.getDataEntity();
            Long initId = (Long)initBill.getPkValue();
            boolean isExistShareBill = QueryServiceHelper.exists((String)"fl_leasefeeshare", (QFilter[])new QFilter[]{new QFilter("conbillno", "=", (Object)initId)});
            if (isExistShareBill) {
                this.addErrorMessage(dataEntity, FlBusinessResourceEnum.LeaseContractInitUnAuditValidator_3.loadKDString());
            }
            for (DynamicObject loanBill : loanBills) {
                if (loanBill.getBoolean("isinit")) continue;
                this.addErrorMessage(dataEntity, FlBusinessResourceEnum.LeaseContractInitUnAuditValidator_0.loadKDString());
                continue block0;
            }
            for (DynamicObject loanBill : loanBills) {
                Boolean repaymentBills = TmcDataServiceHelper.exists((String)"fl_rentpaybill", (QFilter[])new QFilter("loans.e_loanbill", "=", loanBill.get("id")).and("isinit", "=", (Object)"0").toArray());
                if (!Boolean.TRUE.equals(repaymentBills)) continue;
                this.addErrorMessage(dataEntity, FlBusinessResourceEnum.LeaseContractInitUnAuditValidator_1.loadKDString());
                continue block0;
            }
            for (DynamicObject loanBill : loanBills) {
                Boolean interestBills = TmcDataServiceHelper.exists((String)"cfm_interestbill", (QFilter[])new QFilter("sourcebillid", "=", loanBill.get("id")).and("isinit", "=", (Object)"0").toArray());
                if (!Boolean.TRUE.equals(interestBills)) continue;
                this.addErrorMessage(dataEntity, FlBusinessResourceEnum.LeaseContractInitUnAuditValidator_2.loadKDString());
                continue block0;
            }
        }
    }
}

