/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fl.business.validate.feeshare;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.CostShareServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fl.business.resource.FlBusinessResourceEnum;
import kd.tmc.fl.common.helper.LeaseFeeHelper;

public class LeaseFeeShareSubmitValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("bizdate");
        selector.add("expiredate");
        selector.add("feeamount");
        selector.add("amount");
        selector.add("conbillno");
        selector.add("billno");
        selector.add("org");
        selector.add("currency");
        selector.add("entryentity");
        selector.add("sharefrequency");
        selector.add("e_startdate");
        selector.add("e_islock");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntitys) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntitys) {
            BigDecimal payPlanAmount;
            DynamicObject currency;
            boolean isHasCost;
            DynamicObject data = dataEntity.getDataEntity();
            BigDecimal feeAmount = data.getBigDecimal("feeamount");
            DynamicObject conTractBill = data.getDynamicObject("conbillno");
            DynamicObjectCollection entrys = data.getDynamicObjectCollection("entryentity");
            if (EmptyUtil.isEmpty((DynamicObjectCollection)entrys)) {
                this.addErrorMessage(dataEntity, FlBusinessResourceEnum.LeaseFeeShareSubmitValidator_0.loadKDString());
                continue;
            }
            DynamicObject lastVoucherEntry = entrys.parallelStream().filter(e -> e.getBoolean("e_islock")).max(Comparator.comparing(o -> o.getDate("e_startdate"))).orElse(null);
            DynamicObjectCollection conArr = QueryServiceHelper.query((String)"fl_leasecontractbill", (String)"billstatus", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)conTractBill.getLong("ID"))});
            if (EmptyUtil.isEmpty((DynamicObjectCollection)conArr)) {
                this.addErrorMessage(dataEntity, FlBusinessResourceEnum.LeaseFeeShareSubmitValidator_1.loadKDString(data.getString("billno")));
                continue;
            }
            if (!BillStatusEnum.AUDIT.getValue().equals(((DynamicObject)conArr.get(0)).get("billstatus"))) {
                this.addErrorMessage(dataEntity, FlBusinessResourceEnum.LeaseFeeShareSubmitValidator_2.loadKDString(data.getString("billno")));
                continue;
            }
            QFilter filter = new QFilter("conbillno", "=", (Object)conTractBill.getLong("id"));
            filter.and("id", "!=", data.getPkValue());
            if (lastVoucherEntry != null && lastVoucherEntry.getDate("e_startdate") != null) {
                filter.and("periodstartdate", ">", (Object)lastVoucherEntry.getDate("e_startdate"));
            }
            if (isHasCost = TmcDataServiceHelper.exists((String)"fl_leasefeeshare", (QFilter[])new QFilter[]{filter})) {
                this.addErrorMessage(dataEntity, FlBusinessResourceEnum.LeaseFeeShareSubmitValidator_3.loadKDString());
            }
            if ((currency = data.getDynamicObject("currency")) == null) {
                this.addErrorMessage(dataEntity, FlBusinessResourceEnum.LeaseFeeShareSubmitValidator_4.loadKDString());
                continue;
            }
            BigDecimal feeTotalAmt = LeaseFeeHelper.getFeeAmount((long)conTractBill.getLong("ID"), (Date)data.getDate("expiredate"), (long)currency.getLong("id"), (long)data.getDynamicObject("org").getLong("id"));
            if (feeAmount.compareTo(feeTotalAmt.add(payPlanAmount = LeaseFeeHelper.getPayPlanAmount((long)conTractBill.getLong("ID")))) != 0) {
                this.addErrorMessage(dataEntity, FlBusinessResourceEnum.LeaseFeeShareSubmitValidator_6.loadKDString(feeTotalAmt.add(payPlanAmount).setScale(currency.getInt("amtprecision"), RoundingMode.HALF_UP)));
            }
            List dataLists = CostShareServiceHelper.getDateList((String)"", (Date)data.getDate("bizdate"), (Date)data.getDate("expiredate"), (String)data.getString("sharefrequency"));
            if (entrys.size() == dataLists.size()) continue;
            this.addErrorMessage(dataEntity, FlBusinessResourceEnum.LeaseFeeShareSubmitValidator_7.loadKDString());
        }
    }
}

