/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fl.business.validate.feeshare;

import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fl.business.resource.FlBusinessResourceEnum;
import kd.tmc.fl.common.helper.LeaseFeeShareHelper;

public class LeaseFeeShareUnAuditValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("billstatus");
        selector.add("isvoucher");
        selector.add("isinit");
        selector.add("conbillno");
        selector.add("periodstartdate");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntitys) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntitys) {
            DynamicObject bill = dataEntity.getDataEntity();
            if (!BillStatusEnum.isAudit((String)bill.getString("billstatus"))) {
                this.addErrorMessage(dataEntity, FlBusinessResourceEnum.LeaseFeeShareUnAuditValidator_3.loadKDString(BillStatusEnum.getName((String)bill.getString("billstatus"))));
                continue;
            }
            DynamicObject conBill = bill.getDynamicObject("conbillno");
            Date periodDate = bill.getDate("periodstartdate");
            QFilter filter = new QFilter("conbillno", "=", conBill.getPkValue());
            if (bill.getBoolean("isinit")) {
                Set voucherBills;
                DynamicObjectCollection shareBills = QueryServiceHelper.query((String)"fl_leasefeeshare", (String)"id", (QFilter[])new QFilter[]{filter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("isvoucher", "=", (Object)"1").and("periodstartdate", ">", (Object)DateUtils.getDataFormat((Date)periodDate, (boolean)false))});
                if (EmptyUtil.isNoEmpty((DynamicObjectCollection)shareBills) && EmptyUtil.isNoEmpty((Object)(voucherBills = LeaseFeeShareHelper.getVoucherBills(shareBills.parallelStream().map(o -> o.getLong("id")).collect(Collectors.toSet()), (String)"fl_leasefeeshare")))) {
                    this.addErrorMessage(dataEntity, FlBusinessResourceEnum.LeaseFeeShareUnAuditValidator_1.loadKDString());
                }
            } else {
                boolean isVoucher = QueryServiceHelper.exists((String)"fl_leasefeeshare", (QFilter[])new QFilter[]{filter.and("periodstartdate", ">", (Object)DateUtils.getDataFormat((Date)periodDate, (boolean)false)).and("isvoucher", "=", (Object)"1")});
                if (isVoucher) {
                    this.addErrorMessage(dataEntity, FlBusinessResourceEnum.LeaseFeeShareUnAuditValidator_1.loadKDString());
                }
            }
            boolean isExist = QueryServiceHelper.exists((String)"fl_leasefeeshare", (QFilter[])new QFilter[]{filter.and("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue())});
            if (!isExist) continue;
            this.addErrorMessage(dataEntity, FlBusinessResourceEnum.LeaseFeeShareUnAuditValidator_2.loadKDString());
        }
    }
}

