/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fl.business.validate.feeshare;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fl.business.resource.FlBusinessResourceEnum;
import kd.tmc.fl.common.helper.LeaseFeeHelper;

public class LeaseFeeShareValidator
extends AbstractTmcBizOppValidator {
    public Set<String> preparePropertys() {
        Set sel = super.preparePropertys();
        sel.add("enddate");
        sel.add("billstatus");
        return sel;
    }

    public void validate(ExtendedDataEntity[] dataEntitys) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntitys) {
            boolean isHasCost;
            BigDecimal payPlanAmount;
            DynamicObject bill = dataEntity.getDataEntity();
            if (!BillStatusEnum.AUDIT.getValue().equals(bill.getString("billstatus"))) continue;
            BigDecimal feeTotalAmt = LeaseFeeHelper.getFeeAmount((long)bill.getLong("id"), (Date)bill.getDate("enddate"), (long)0L, (long)0L);
            if (EmptyUtil.isEmpty((BigDecimal)feeTotalAmt.add(payPlanAmount = LeaseFeeHelper.getPayPlanAmount((long)bill.getLong("id"))))) {
                this.addErrorMessage(dataEntity, FlBusinessResourceEnum.LeaseFeeShareValidator_0.loadKDString());
            }
            if (!(isHasCost = TmcDataServiceHelper.exists((String)"fl_leasefeeshare", (QFilter[])new QFilter[]{new QFilter("conbillno", "=", bill.getPkValue())}))) continue;
            this.addErrorMessage(dataEntity, FlBusinessResourceEnum.LeaseFeeShareValidator_1.loadKDString());
        }
    }
}

