/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fl.business.validate.rentplan;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcAccountHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fl.business.helper.PayPlanUpdateHelper;
import kd.tmc.fl.business.resource.FlBusinessResourceEnum;
import kd.tmc.fl.common.enums.ExecuteStatusEnum;

public class RentPlanBillSaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("amount");
        selector.add("contract");
        selector.add("org");
        selector.add("contractstatus");
        selector.add("startinterestrate");
        selector.add("entry_rentplan");
        selector.add("principal");
        selector.add("intamt");
        selector.add("startrevdate");
        selector.add("endrevdate");
        selector.add("rentamt");
        selector.add("taxamt");
        selector.add("excludetaxamt");
        selector.add("paydate");
        selector.add("currency");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            if (!this.validateContractStatus(extendedDataEntity)) continue;
            this.validateMustInput(extendedDataEntity);
            this.validatePrincipal(extendedDataEntity);
        }
    }

    private void validateMustInput(ExtendedDataEntity data) {
        DynamicObject rentPlan = data.getDataEntity();
        String contract = rentPlan.getString("contract");
        if (EmptyUtil.isEmpty((String)contract) && this.getOperateKey().equals("saveplan")) {
            this.addErrorMessage(data, FlBusinessResourceEnum.RentPlanBillSaveValidator_0.loadKDString());
            return;
        }
        DynamicObjectCollection entry = rentPlan.getDynamicObjectCollection("entry_rentplan");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)entry)) {
            this.addErrorMessage(data, FlBusinessResourceEnum.RentPlanBillSaveValidator_1.loadKDString());
            return;
        }
        List<Object> authAccts = this.loadAuthAcct(rentPlan);
        int len = entry.size();
        for (int rowIndex = 0; rowIndex < len; ++rowIndex) {
            StringJoiner errorMsg = new StringJoiner("");
            this.validateDateInfo(rentPlan, entry, errorMsg, rowIndex);
            this.validatePayAmt((DynamicObject)entry.get(rowIndex), errorMsg);
            this.validateInst(data, (DynamicObject)entry.get(rowIndex), errorMsg);
            this.validatePayAcct(authAccts, rentPlan, (DynamicObject)entry.get(rowIndex), errorMsg);
            this.validateOrder(entry, errorMsg, rowIndex);
            if (errorMsg.length() <= 0) continue;
            this.addErrorMessage(data, FlBusinessResourceEnum.RentPlanBillSaveValidator_12.loadKDString(rowIndex + 1, errorMsg.toString()));
        }
    }

    private void validateDateInfo(DynamicObject rentPlan, DynamicObjectCollection entry, StringJoiner errorMsg, int rowIndex) {
        Date startRevDate;
        DynamicObject plan = (DynamicObject)entry.get(rowIndex);
        Date payDate = plan.getDate("paydate");
        if (null == payDate) {
            errorMsg.add(FlBusinessResourceEnum.RentPlanBillSaveValidator_19.loadKDString());
        }
        if (null == (startRevDate = plan.getDate("startrevdate"))) {
            errorMsg.add(FlBusinessResourceEnum.RentPlanBillSaveValidator_20.loadKDString());
        } else if (PayPlanUpdateHelper.isNotBetweenDate(rentPlan, startRevDate)) {
            errorMsg.add(FlBusinessResourceEnum.RentPlanBillSaveValidator_4.loadKDString());
        }
        Date endRevDate = plan.getDate("endrevdate");
        if (null == endRevDate) {
            errorMsg.add(FlBusinessResourceEnum.RentPlanBillSaveValidator_21.loadKDString());
        } else if (PayPlanUpdateHelper.isNotBetweenDate(rentPlan, endRevDate)) {
            errorMsg.add(FlBusinessResourceEnum.RentPlanBillSaveValidator_5.loadKDString());
        }
        if (null != startRevDate && null != endRevDate && endRevDate.compareTo(startRevDate) <= 0) {
            errorMsg.add(FlBusinessResourceEnum.RentPlanBillSaveValidator_8.loadKDString());
        }
        if (rowIndex > 0) {
            Date lastEndRevDate = ((DynamicObject)entry.get(rowIndex - 1)).getDate("endrevdate");
            if (null != startRevDate && null != lastEndRevDate && startRevDate.compareTo(lastEndRevDate) <= 0) {
                errorMsg.add(FlBusinessResourceEnum.RentPlanBillSaveValidator_9.loadKDString());
            }
            Date lastPayDate = ((DynamicObject)entry.get(rowIndex - 1)).getDate("paydate");
            if (null != payDate && null != lastEndRevDate && payDate.compareTo(lastPayDate) <= 0) {
                errorMsg.add(FlBusinessResourceEnum.RentPlanBillSaveValidator_17.loadKDString());
            }
        }
    }

    private void validatePayAmt(DynamicObject plan, StringJoiner errorMsg) {
        BigDecimal excludeTaxAmt;
        BigDecimal taxAmt;
        BigDecimal intAmt;
        BigDecimal principal;
        BigDecimal rentAmt = plan.getBigDecimal("rentamt");
        if (rentAmt.compareTo((principal = plan.getBigDecimal("principal")).add(intAmt = plan.getBigDecimal("intamt"))) != 0) {
            errorMsg.add(FlBusinessResourceEnum.RentPlanBillSaveValidator_10.loadKDString());
        }
        if (intAmt.compareTo((taxAmt = plan.getBigDecimal("taxamt")).add(excludeTaxAmt = plan.getBigDecimal("excludetaxamt"))) != 0) {
            errorMsg.add(FlBusinessResourceEnum.RentPlanBillSaveValidator_11.loadKDString());
        }
    }

    private void validatePayAcct(List<Object> authAccts, DynamicObject rentPlan, DynamicObject plan, StringJoiner errorMsg) {
        DynamicObject payAcct = plan.getDynamicObject("payacct");
        DynamicObject currency = rentPlan.getDynamicObject("currency");
        if (null == plan.getDynamicObject("payacct")) {
            errorMsg.add(FlBusinessResourceEnum.RentPlanBillSaveValidator_22.loadKDString());
        } else {
            String acctClassify;
            String acctStatus;
            boolean noneMatch;
            if (null != currency && (noneMatch = payAcct.getDynamicObjectCollection("currency").stream().map(v -> v.getDynamicObject("fbasedataid").getPkValue()).noneMatch(v -> v.equals(currency.getPkValue())))) {
                errorMsg.add(FlBusinessResourceEnum.RentPlanBillSaveValidator_23.loadKDString());
            }
            if (!authAccts.contains(payAcct.getPkValue())) {
                errorMsg.add(FlBusinessResourceEnum.RentPlanBillSaveValidator_13.loadKDString());
            }
            if (StringUtils.equals((CharSequence)(acctStatus = payAcct.getString("acctstatus")), (CharSequence)"closed")) {
                errorMsg.add(FlBusinessResourceEnum.RentPlanBillSaveValidator_14.loadKDString());
            }
            if (!StringUtils.equals((CharSequence)"B", (CharSequence)(acctClassify = payAcct.getString("acctclassify")))) {
                errorMsg.add(FlBusinessResourceEnum.RentPlanBillSaveValidator_15.loadKDString());
            }
        }
    }

    private void validateOrder(DynamicObjectCollection entry, StringJoiner errorMsg, int rowIndex) {
        DynamicObject nextPlan;
        DynamicObject currPlan = (DynamicObject)entry.get(rowIndex);
        String currPlanStatus = currPlan.getString("executestatus");
        if (ExecuteStatusEnum.isUnExecuted((String)currPlanStatus) && entry.size() - 1 > rowIndex && ExecuteStatusEnum.isExecuted((String)(nextPlan = (DynamicObject)entry.get(rowIndex + 1)).getString("executestatus"))) {
            errorMsg.add(FlBusinessResourceEnum.RentPlanBillSaveValidator_16.loadKDString());
        }
    }

    private void validateInst(ExtendedDataEntity data, DynamicObject plan, StringJoiner errorMsg) {
        DynamicObject rentPlan = data.getDataEntity();
        BigDecimal rate = rentPlan.getBigDecimal("startinterestrate");
        BigDecimal instAmt = plan.getBigDecimal("intamt");
        if (EmptyUtil.isNoEmpty((BigDecimal)rate) && EmptyUtil.isEmpty((BigDecimal)instAmt)) {
            errorMsg.add(FlBusinessResourceEnum.RentPlanBillSaveValidator_6.loadKDString());
        } else if (EmptyUtil.isEmpty((BigDecimal)rate) && EmptyUtil.isNoEmpty((BigDecimal)instAmt)) {
            errorMsg.add(FlBusinessResourceEnum.RentPlanBillSaveValidator_7.loadKDString());
        }
    }

    private void validatePrincipal(ExtendedDataEntity data) {
        BigDecimal principle;
        DynamicObjectCollection rentPlans = data.getDataEntity().getDynamicObjectCollection("entry_rentplan");
        if (null != rentPlans && (principle = rentPlans.stream().map(v -> v.getBigDecimal("principal")).filter(EmptyUtil::isNoEmpty).reduce(BigDecimal.ZERO, BigDecimal::add)).compareTo(data.getDataEntity().getBigDecimal("amount")) != 0) {
            this.addErrorMessage(data, FlBusinessResourceEnum.RentPlanBillSaveValidator_2.loadKDString());
        }
    }

    private boolean validateContractStatus(ExtendedDataEntity data) {
        String contractStatus = data.getDataEntity().getString("contractstatus");
        if (StringUtils.equals((CharSequence)contractStatus, (CharSequence)"D")) {
            this.addErrorMessage(data, FlBusinessResourceEnum.RentPlanBillSaveValidator_18.loadKDString());
            return false;
        }
        return true;
    }

    private List<Object> loadAuthAcct(DynamicObject rentPlan) {
        DynamicObjectCollection plans = rentPlan.getDynamicObjectCollection("entry_rentplan");
        Object[] acctIds = plans.stream().map(v -> v.getDynamicObject("payacct")).filter(EmptyUtil::isNoEmpty).map(DataEntityBase::getPkValue).toArray();
        if (EmptyUtil.isEmpty((Object[])acctIds)) {
            return new ArrayList<Object>();
        }
        DynamicObject org = rentPlan.getDynamicObject("org");
        QFilter filter = TmcAccountHelper.getAccountBankFilterByOrg((Long)org.getLong("id"));
        filter.and("id", "in", (Object)acctIds);
        DynamicObjectCollection bankAccts = QueryServiceHelper.query((String)"bd_accountbanks", (String)"id", (QFilter[])filter.toArray());
        if (EmptyUtil.isEmpty((DynamicObjectCollection)bankAccts)) {
            return new ArrayList<Object>();
        }
        return bankAccts.stream().map(v -> v.get("id")).collect(Collectors.toList());
    }
}

