/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.opplugin.basesetting;

import java.util.List;
import java.util.Objects;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.plugin.args.ReturnOperationArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.business.opservice.ITmcBizOppService;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.opplugin.TmcOperationServicePlugIn;
import kd.tmc.fpm.business.mvc.repository.IControlRepository;
import kd.tmc.fpm.business.mvc.repository.impl.ControlRepository;
import kd.tmc.fpm.business.mvc.service.control.executetime.IExecuteTimeAutoReverseWriteOpRuleService;
import kd.tmc.fpm.business.mvc.service.control.executetime.impl.ExecuteTimeAutoReverseWriteOpRuleServiceImpl;
import kd.tmc.fpm.business.mvc.service.lock.DLockService;
import kd.tmc.fpm.business.validate.basesetting.BodySysMangeDisableValidator;

public class BodySysMangeDisableOp
extends TmcOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(BodySysMangeDisableOp.class);
    private DLockService dLockService;
    private final IControlRepository dimRepo = new ControlRepository();
    private final IExecuteTimeAutoReverseWriteOpRuleService executeTimeAutoReverseWriteOpRuleService = new ExecuteTimeAutoReverseWriteOpRuleServiceImpl();

    public ITmcBizOppService getBizOppService() {
        return null;
    }

    public AbstractTmcBizOppValidator getBizOppValidator() {
        return new BodySysMangeDisableValidator();
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs beforeOperationArgs) {
        super.beforeExecuteOperationTransaction(beforeOperationArgs);
        String dLockName = String.format("%s.%s", CacheKeyUtil.getAcctId(), "executeTime");
        this.dLockService = new DLockService(dLockName);
        try {
            this.dLockService.tryLock(30000L);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        List controlExecTimeRules = this.dimRepo.queryControlExecTimeRule();
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                this.executeTimeAutoReverseWriteOpRuleService.reverseWrite(controlExecTimeRules);
            }
            catch (Exception ex) {
                txHandle.markRollback();
                logger.error(ex.getMessage(), (Throwable)ex);
                throw ex;
            }
        }
    }

    public void onReturnOperation(ReturnOperationArgs e) {
        super.onReturnOperation(e);
        if (Objects.nonNull(this.dLockService)) {
            this.dLockService.unLock();
        }
    }
}

