/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.opplugin.basesetting;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.tmc.fbp.business.opservice.ITmcBizOppService;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.opplugin.TmcOperationServicePlugIn;
import kd.tmc.fpm.business.validate.basesetting.BodySysMangeSaveValidator;
import kd.tmc.fpm.common.enums.DimMemberFromEnum;
import kd.tmc.fpm.common.enums.DimsionEnums;
import kd.tmc.fpm.common.enums.MemberSumEnum;
import kd.tmc.fpm.common.helper.AuxiliaryFieldsHelper;
import kd.tmc.fpm.common.helper.DetailPlanFieldsHelper;
import kd.tmc.fpm.common.helper.FpmGlobalConfigHelper;
import kd.tmc.fpm.common.helper.InspectionConfigHelper;
import kd.tmc.fpm.opplugin.helper.MetricFieldHelper;

public class BodySysMangeSaveOp
extends TmcOperationServicePlugIn {
    private static final String UPDATE_REPORT_PREPARATION_CONVEX_RATE_TABLE_SQL = "update t_fpm_reportpreparation set fconvexratetableid = ? where fbodysysmanage = ? and fconvexratetableid = ?";

    public ITmcBizOppService getBizOppService() {
        return null;
    }

    public AbstractTmcBizOppValidator getBizOppValidator() {
        return new BodySysMangeSaveValidator();
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] models = e.getDataEntities();
        List modelIdList = Arrays.stream(models).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        DynamicObject[] modelsFromDB = TmcDataServiceHelper.load((Object[])modelIdList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fpm_bodysysmanage"));
        List modelFromDBIds = Arrays.stream(modelsFromDB).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        ArrayList<DynamicObject> demensions = new ArrayList<DynamicObject>();
        for (DynamicObject model : models) {
            if (modelFromDBIds.contains(model.getPkValue())) continue;
            demensions.addAll(this.createDefaultDem(model));
        }
        if (!CollectionUtils.isEmpty(demensions)) {
            TmcDataServiceHelper.save((DynamicObject[])demensions.toArray(new DynamicObject[0]));
        }
        Map<String, DynamicObject> dimensionMap = demensions.stream().collect(Collectors.toMap(v -> v.getString("basedata"), v -> v));
        for (DynamicObject model : models) {
            if (modelFromDBIds.contains(model.getPkValue())) continue;
            this.addDefaultMember(DimsionEnums.ORG, model, dimensionMap.get(DimsionEnums.ORG.getNumber()));
            this.addDefaultMember(DimsionEnums.CURRENCY, model, dimensionMap.get(DimsionEnums.CURRENCY.getNumber()));
            List detailInitData = DetailPlanFieldsHelper.initData((DynamicObject)model);
            TmcOperateServiceHelper.execOperate((String)"save", (String)"fpm_detailplanfields", (DynamicObject[])detailInitData.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
            List auxDOList = AuxiliaryFieldsHelper.initData((DynamicObject)model);
            TmcOperateServiceHelper.execOperate((String)"save", (String)"fpm_auxiliaryfields", (DynamicObject[])auxDOList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
            List<DynamicObject> metricModels = MetricFieldHelper.initMetricModels(model, dimensionMap.get(DimsionEnums.METRIC.getNumber()));
            TmcDataServiceHelper.save((DynamicObject[])metricModels.toArray(new DynamicObject[0]));
            List inspectionConfigList = InspectionConfigHelper.initData((DynamicObject)model);
            TmcOperateServiceHelper.execOperate((String)"save", (String)"fpm_inspection_config", (DynamicObject[])inspectionConfigList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        }
        Map<Object, DynamicObject> modelMap = Stream.of(models).collect(Collectors.toMap(DataEntityBase::getPkValue, Function.identity()));
        for (DynamicObject dbModelData : modelsFromDB) {
            DynamicObjectCollection dbReportColl = dbModelData.getDynamicObjectCollection("applyrereportentry");
            DynamicObject model = modelMap.get(dbModelData.getPkValue());
            DynamicObjectCollection currReportColl = model.getDynamicObjectCollection("applyrereportentry");
            List idList = currReportColl.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
            List deleteData = dbReportColl.stream().filter(i -> !idList.contains(i.getPkValue())).collect(Collectors.toList());
            if (deleteData.size() <= 0) continue;
            List deleteReportIdList = deleteData.stream().map(i -> i.getLong("rerporttype.id")).collect(Collectors.toList());
            DynamicObjectCollection periodMemIdColl = QueryServiceHelper.query((String)"fpm_member", (String)"id", (QFilter[])new QFilter[]{new QFilter("reporttype.id", "in", deleteReportIdList), new QFilter("bodysystem", "=", (Object)Optional.ofNullable(dbModelData.getPkValue()).map(o -> Long.valueOf(o.toString())).orElseGet(() -> 0L))});
            DynamicObject[] members = BusinessDataServiceHelper.load((Object[])periodMemIdColl.stream().map(i -> i.get("id")).toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fpm_member"));
            TmcOperateServiceHelper.execOperate((String)"delete", (String)"fpm_member", (DynamicObject[])members, (OperateOption)OperateOption.create());
        }
        this.syncReportPreparationConvExRateTableIfNeed(modelMap, modelsFromDB);
    }

    private List<DynamicObject> createDefaultDem(DynamicObject model) {
        ArrayList<DynamicObject> demensions = new ArrayList<DynamicObject>(2);
        Object[] tDemIds = new Long[]{DBServiceHelper.genGlobalLongId(), DBServiceHelper.genGlobalLongId(), DBServiceHelper.genGlobalLongId(), DBServiceHelper.genGlobalLongId()};
        Arrays.sort(tDemIds);
        int i = 0;
        demensions.add(this.createDem(DimsionEnums.ORG, model, (Long)tDemIds[i++]));
        demensions.add(this.createDem(DimsionEnums.CURRENCY, model, (Long)tDemIds[i++]));
        demensions.add(this.createDem(DimsionEnums.PERIOD, model, (Long)tDemIds[i++]));
        demensions.add(this.createDem(DimsionEnums.SUBJECT, model, (Long)tDemIds[i++]));
        demensions.add(this.createDem(DimsionEnums.METRIC, model, DBServiceHelper.genGlobalLongId()));
        return demensions;
    }

    private DynamicObject createDem(DimsionEnums dimEnums, DynamicObject model, Long id) {
        DynamicObject dimAdd = BusinessDataServiceHelper.newDynamicObject((String)"fpm_dimension");
        dimAdd.set("basedata", (Object)dimEnums.getNumber());
        dimAdd.set("number", (Object)dimEnums.getNumber());
        dimAdd.set("name", (Object)dimEnums.getName());
        dimAdd.set("bodysystem", (Object)model);
        dimAdd.set("status", (Object)BillStatusEnum.AUDIT.getValue());
        dimAdd.set("enable", (Object)1);
        dimAdd.set("id", (Object)id);
        if (dimEnums == DimsionEnums.ORG) {
            dimAdd.set("basedatabiz", (Object)"08");
            dimAdd.set("memberfrom", (Object)DimMemberFromEnum.BASE_INFO.getCode());
            dimAdd.set("relbasedata", (Object)"bos_org");
        }
        if (dimEnums == DimsionEnums.PERIOD) {
            dimAdd.set("memberfrom", (Object)DimMemberFromEnum.CUSTOM.getCode());
        }
        if (dimEnums == DimsionEnums.CURRENCY) {
            dimAdd.set("memberfrom", (Object)DimMemberFromEnum.BASE_INFO.getCode());
            dimAdd.set("relbasedata", (Object)"bd_currency");
        }
        if (dimEnums == DimsionEnums.SUBJECT || dimEnums == DimsionEnums.METRIC) {
            dimAdd.set("memberfrom", (Object)DimMemberFromEnum.BASE_INFO.getCode());
        }
        return dimAdd;
    }

    private void addDefaultMember(DimsionEnums dimEnums, DynamicObject model, DynamicObject dimension) {
        DynamicObject defaultOrg = BusinessDataServiceHelper.newDynamicObject((String)"fpm_member");
        Object number = dimEnums == DimsionEnums.CURRENCY ? model.get("currency.number") : model.get("org.number");
        Object name = dimEnums == DimsionEnums.CURRENCY ? model.get("currency.name") : model.get("org.name");
        Object sourceId = dimEnums == DimsionEnums.CURRENCY ? model.get("currency.id") : model.get("org.id");
        ArrayList<DynamicObject> dataList = new ArrayList<DynamicObject>(2);
        dataList.add(defaultOrg);
        defaultOrg.set("dimension", (Object)dimension);
        defaultOrg.set("number", number);
        defaultOrg.set("name", name);
        defaultOrg.set("sortcode", (Object)"0001");
        defaultOrg.set("fullname", name);
        defaultOrg.set("status", (Object)"C");
        defaultOrg.set("creator", (Object)RequestContext.get().getCurrUserId());
        defaultOrg.set("enable", (Object)"1");
        defaultOrg.set("level", (Object)1);
        defaultOrg.set("isleaf", (Object)1);
        defaultOrg.set("sourceid", sourceId);
        defaultOrg.set("masterid", sourceId);
        defaultOrg.set("parent", (Object)0L);
        defaultOrg.set("modifier", (Object)RequestContext.get().getCurrUserId());
        defaultOrg.set("createtime", (Object)new Date());
        defaultOrg.set("modifytime", (Object)new Date());
        defaultOrg.set("bodysystem", model.get("id"));
        defaultOrg.set("dimtype", (Object)dimEnums.getNumber());
        defaultOrg.set("longnumber", number);
        defaultOrg.set("id", (Object)DBServiceHelper.genGlobalLongId());
        defaultOrg.set("serial", (Object)System.nanoTime());
        defaultOrg.set("sumtype", (Object)MemberSumEnum.PLUS.getCode());
        if (dimEnums == DimsionEnums.ORG) {
            defaultOrg.set("issum", (Object)Boolean.FALSE);
            defaultOrg.set("caporg", (Object)BusinessDataServiceHelper.loadSingle((Object)sourceId, (String)"bos_org"));
            Calendar calendar1 = Calendar.getInstance();
            calendar1.set(1900, 0, 1);
            Date enableDate = calendar1.getTime();
            defaultOrg.set("enabledate", (Object)enableDate);
            Calendar calendar2 = Calendar.getInstance();
            calendar2.set(2099, 11, 31);
            Date disableDate = calendar2.getTime();
            defaultOrg.set("disabledate", (Object)disableDate);
        }
        TmcDataServiceHelper.save((DynamicObject[])dataList.toArray(new DynamicObject[0]));
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        if (FpmGlobalConfigHelper.getBooleanConfigByKey((String)"startmutilsync")) {
            OperationServiceHelper.executeOperate((String)"syncsys_mdd", (String)"fpm_bodysysmanage", (DynamicObject[])e.getDataEntities(), (OperateOption)OperateOption.create());
        }
    }

    private void syncReportPreparationConvExRateTableIfNeed(Map<Object, DynamicObject> modelMap, DynamicObject[] modelsFromDB) {
        List updateConvexRateTableParamList = Arrays.stream(modelsFromDB).filter(modelDyFromDB -> {
            DynamicObject updateModelDy = (DynamicObject)modelMap.get(modelDyFromDB.getPkValue());
            Long updateExRateTableId = updateModelDy.getLong("ratetype.id");
            Long dbExRateTableId = modelDyFromDB.getLong("ratetype.id");
            return Objects.nonNull(updateExRateTableId) && Objects.nonNull(dbExRateTableId) && !Objects.equals(updateExRateTableId, dbExRateTableId);
        }).map(modelDyFromDB -> {
            DynamicObject updateModelDy = (DynamicObject)modelMap.get(modelDyFromDB.getPkValue());
            Long updateExRateTableId = updateModelDy.getLong("ratetype.id");
            Long dbExRateTableId = modelDyFromDB.getLong("ratetype.id");
            return new Object[]{updateExRateTableId, modelDyFromDB.getPkValue(), dbExRateTableId};
        }).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(updateConvexRateTableParamList)) {
            DB.executeBatch((DBRoute)DBRouteConst.TMC, (String)UPDATE_REPORT_PREPARATION_CONVEX_RATE_TABLE_SQL, updateConvexRateTableParamList);
        }
    }
}

