/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.opplugin.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.DBServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fpm.business.domain.enums.ReportValueFormulaTypeEnum;
import kd.tmc.fpm.business.domain.enums.TemplateMetricType;
import kd.tmc.fpm.common.enums.DimsionEnums;
import kd.tmc.fpm.common.enums.MemberSumEnum;
import kd.tmc.fpm.common.enums.MetricMemberDataTypeEnum;
import kd.tmc.fpm.common.enums.MetricMemberTypeEnum;
import kd.tmc.fpm.common.enums.MetricMemberUseTypeEnum;
import org.apache.commons.lang3.tuple.Pair;

public class MetricFieldHelper {
    private static final Map<TemplateMetricType, Pair<String, String>> FORMULA_MAP = new HashMap<TemplateMetricType, Pair<String, String>>(8);
    private static final Map<TemplateMetricType, String> DESC_MAP = new HashMap<TemplateMetricType, String>(16);

    public static List<DynamicObject> initMetricModels(DynamicObject model, DynamicObject dimension) {
        ArrayList<DynamicObject> metricList = new ArrayList<DynamicObject>(8);
        List allPreSetMetric = Arrays.stream(TemplateMetricType.values()).filter(item -> TemplateMetricType.CUSTOM != item).collect(Collectors.toList());
        int index = 1;
        for (TemplateMetricType metricType : allPreSetMetric) {
            DynamicObject metric = MetricFieldHelper.createMetricObject(model, dimension, index);
            MetricFieldHelper.setDefaultMetricType(metricType, metric);
            metricList.add(metric);
            ++index;
        }
        return metricList;
    }

    private static void setDefaultMetricType(TemplateMetricType metricType, DynamicObject metric) {
        if (TemplateMetricType.ADJUSTAMT == metricType || TemplateMetricType.AVAILABLEAMT == metricType || TemplateMetricType.EXECUTEAMT == metricType || TemplateMetricType.EXECUTEPERCENT == metricType || TemplateMetricType.DEVIATIONPERCENT == metricType) {
            metric.set("metrictype", (Object)MetricMemberTypeEnum.ANALYSE.getValue());
        } else {
            metric.set("metrictype", (Object)MetricMemberTypeEnum.BASE.getValue());
        }
        if (TemplateMetricType.PLANREFERENCEAMT == metricType || TemplateMetricType.PLANAMT == metricType || TemplateMetricType.REPORTPLANAMT == metricType || TemplateMetricType.ORIGINALPLANAMT == metricType) {
            metric.set("metricuse", (Object)MetricMemberUseTypeEnum.AUTH.getValue());
        } else if (TemplateMetricType.LOCKAMT == metricType || TemplateMetricType.ACTMAT == metricType) {
            metric.set("metricuse", (Object)MetricMemberUseTypeEnum.EXECUTE.getValue());
        } else {
            metric.set("metricuse", (Object)MetricMemberUseTypeEnum.SELECT.getValue());
        }
        if (TemplateMetricType.EXECUTEPERCENT == metricType || TemplateMetricType.DEVIATIONPERCENT == metricType) {
            metric.set("metricdatatype", (Object)MetricMemberDataTypeEnum.PERCENT.getValue());
        } else {
            metric.set("metricdatatype", (Object)MetricMemberDataTypeEnum.MONEY.getValue());
        }
        metric.set("name", (Object)metricType.getName());
        metric.set("fullname", (Object)metricType.getName());
        Pair<String, String> formulaPair = FORMULA_MAP.get(metricType);
        metric.set("computeformula", (Object)Optional.ofNullable(formulaPair).map(Pair::getRight).orElse(""));
        metric.set("computeformulavalue_tag", (Object)Optional.ofNullable(formulaPair).map(Pair::getLeft).orElse(""));
        metric.set("description", (Object)DESC_MAP.get(metricType));
        metric.set("metricpresettype", (Object)metricType.getCode());
    }

    private static DynamicObject createMetricObject(DynamicObject model, DynamicObject dimension, int index) {
        String indexStr = String.valueOf(index);
        StringBuilder number = new StringBuilder("M0");
        if (indexStr.length() >= 2) {
            number.append(indexStr);
        } else {
            number.append("0").append(indexStr);
        }
        DynamicObject dynamicObject = TmcDataServiceHelper.newDynamicObject((String)"fpm_member");
        dynamicObject.set("bodysystem", model.getPkValue());
        dynamicObject.set("number", (Object)number.toString());
        dynamicObject.set("preset", (Object)Boolean.TRUE);
        dynamicObject.set("enable", (Object)"1");
        dynamicObject.set("creator", (Object)RequestContext.get().getCurrUserId());
        dynamicObject.set("createtime", (Object)new Date());
        dynamicObject.set("modifier", (Object)RequestContext.get().getCurrUserId());
        dynamicObject.set("modifytime", (Object)new Date());
        dynamicObject.set("sumtype", (Object)MemberSumEnum.PLUS.getCode());
        dynamicObject.set("dimension", (Object)dimension);
        dynamicObject.set("status", (Object)"C");
        dynamicObject.set("level", (Object)1);
        dynamicObject.set("isleaf", (Object)1);
        dynamicObject.set("parent", (Object)0L);
        dynamicObject.set("dimtype", (Object)DimsionEnums.METRIC.getNumber());
        dynamicObject.set("longnumber", (Object)number.toString());
        dynamicObject.set("id", (Object)DBServiceHelper.genGlobalLongId());
        dynamicObject.set("serial", (Object)System.nanoTime());
        return dynamicObject;
    }

    static {
        FORMULA_MAP.put(TemplateMetricType.ADJUSTAMT, (Pair<String, String>)Pair.of((Object)(ReportValueFormulaTypeEnum.PLAN_QUOTA.getValue() + "-" + ReportValueFormulaTypeEnum.REPORT_QUOTA.getValue()), (Object)(ReportValueFormulaTypeEnum.PLAN_QUOTA.getName() + "-" + ReportValueFormulaTypeEnum.REPORT_QUOTA.getName())));
        FORMULA_MAP.put(TemplateMetricType.AVAILABLEAMT, (Pair<String, String>)Pair.of((Object)(ReportValueFormulaTypeEnum.PLAN_QUOTA.getValue() + "-" + ReportValueFormulaTypeEnum.PRE_QUOTA.getValue() + "-" + ReportValueFormulaTypeEnum.EXECUTED_QUOTA.getValue()), (Object)(ReportValueFormulaTypeEnum.PLAN_QUOTA.getName() + "-" + ReportValueFormulaTypeEnum.PRE_QUOTA.getName() + "-" + ReportValueFormulaTypeEnum.EXECUTED_QUOTA.getName())));
        FORMULA_MAP.put(TemplateMetricType.EXECUTEAMT, (Pair<String, String>)Pair.of((Object)(ReportValueFormulaTypeEnum.PLAN_QUOTA.getValue() + "-" + ReportValueFormulaTypeEnum.EXECUTED_QUOTA.getValue()), (Object)(ReportValueFormulaTypeEnum.PLAN_QUOTA.getName() + "-" + ReportValueFormulaTypeEnum.EXECUTED_QUOTA.getName())));
        FORMULA_MAP.put(TemplateMetricType.EXECUTEPERCENT, (Pair<String, String>)Pair.of((Object)(ReportValueFormulaTypeEnum.EXECUTED_QUOTA.getValue() + "/" + ReportValueFormulaTypeEnum.PLAN_QUOTA.getValue()), (Object)(ReportValueFormulaTypeEnum.EXECUTED_QUOTA.getName() + "/" + ReportValueFormulaTypeEnum.PLAN_QUOTA.getName())));
        FORMULA_MAP.put(TemplateMetricType.DEVIATIONPERCENT, (Pair<String, String>)Pair.of((Object)("(" + ReportValueFormulaTypeEnum.PLAN_QUOTA.getValue() + "-" + ReportValueFormulaTypeEnum.EXECUTED_QUOTA.getValue() + ")/" + ReportValueFormulaTypeEnum.PLAN_QUOTA.getValue()), (Object)("(" + ReportValueFormulaTypeEnum.PLAN_QUOTA.getName() + "-" + ReportValueFormulaTypeEnum.EXECUTED_QUOTA.getName() + ")/" + ReportValueFormulaTypeEnum.PLAN_QUOTA.getName())));
        DESC_MAP.put(TemplateMetricType.PLANAMT, ResManager.loadKDString((String)"\u6700\u65b0\u751f\u6548\u7684\u8ba1\u5212\u989d\u5ea6", (String)"MetricFieldHelper_0", (String)"tmc-fpm-opplugin", (Object[])new Object[0]));
        DESC_MAP.put(TemplateMetricType.REPORTPLANAMT, ResManager.loadKDString((String)"\u4e0b\u7ea7\u4e3b\u4f53\u5f80\u4e0a\u4e0a\u62a5\u7684\u989d\u5ea6", (String)"MetricFieldHelper_1", (String)"tmc-fpm-opplugin", (Object[])new Object[0]));
        DESC_MAP.put(TemplateMetricType.ORIGINALPLANAMT, ResManager.loadKDString((String)"\u5ba1\u6279\u6838\u5b9a\u540e\u7684\u989d\u5ea6", (String)"MetricFieldHelper_2", (String)"tmc-fpm-opplugin", (Object[])new Object[0]));
        DESC_MAP.put(TemplateMetricType.PLANREFERENCEAMT, ResManager.loadKDString((String)"\u4ece\u4e1a\u52a1\u7aef\u667a\u80fd\u6293\u53d6\u751f\u6210\u7684\u989d\u5ea6", (String)"MetricFieldHelper_3", (String)"tmc-fpm-opplugin", (Object[])new Object[0]));
        DESC_MAP.put(TemplateMetricType.LOCKAMT, ResManager.loadKDString((String)"\u9884\u5360\u6570", (String)"MetricFieldHelper_4", (String)"tmc-fpm-opplugin", (Object[])new Object[0]));
        DESC_MAP.put(TemplateMetricType.ACTMAT, ResManager.loadKDString((String)"\u5b9e\u5360\u6570", (String)"MetricFieldHelper_5", (String)"tmc-fpm-opplugin", (Object[])new Object[0]));
        DESC_MAP.put(TemplateMetricType.ADJUSTAMT, ResManager.loadKDString((String)"\u672c\u671f\u8c03\u6574\u7684\u5408\u8ba1\u603b\u989d", (String)"MetricFieldHelper_6", (String)"tmc-fpm-opplugin", (Object[])new Object[0]));
        DESC_MAP.put(TemplateMetricType.AVAILABLEAMT, ResManager.loadKDString((String)"\u751f\u6548\u8ba1\u5212\u7684\u5269\u4f59\u672a\u4f7f\u7528\u989d\u5ea6", (String)"MetricFieldHelper_7", (String)"tmc-fpm-opplugin", (Object[])new Object[0]));
        DESC_MAP.put(TemplateMetricType.EXECUTEAMT, ResManager.loadKDString((String)"\u672a\u5b9e\u9645\u6267\u884c\u7684\u5269\u4f59\u989d\u5ea6", (String)"MetricFieldHelper_8", (String)"tmc-fpm-opplugin", (Object[])new Object[0]));
        DESC_MAP.put(TemplateMetricType.EXECUTEPERCENT, ResManager.loadKDString((String)"\u6267\u884c\u7387", (String)"MetricFieldHelper_9", (String)"tmc-fpm-opplugin", (Object[])new Object[0]));
        DESC_MAP.put(TemplateMetricType.DEVIATIONPERCENT, ResManager.loadKDString((String)"\u504f\u5dee\u7387", (String)"MetricFieldHelper_10", (String)"tmc-fpm-opplugin", (Object[])new Object[0]));
    }
}

