/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.opplugin.inoutpool;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.opplugin.TmcOperationServicePlugIn;
import kd.tmc.fpm.common.enums.InoutCollectApprovalStatusEnum;
import kd.tmc.fpm.common.enums.InoutCollectInoutDirectionEnum;
import org.apache.commons.lang3.tuple.Pair;

public class ApprovalDisposeSaveOp
extends TmcOperationServicePlugIn {
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] load;
        super.beginOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        HashMap<Long, DynamicObject> collectIdApprovalMap = new HashMap<Long, DynamicObject>(dataEntities.length * 8);
        HashMap<Long, DynamicObject> existsBillMap = new HashMap<Long, DynamicObject>(dataEntities.length);
        this.fillCollectIdMapAndExistBillMap(dataEntities, collectIdApprovalMap, existsBillMap);
        HashSet<Long> allCollectIds = new HashSet<Long>(16);
        Map<Long, Long> entryExistCollectMap = this.getExistCollectIdMap(existsBillMap.keySet());
        Set<Long> existsBillIds = entryExistCollectMap.keySet();
        Set collectIdSet = collectIdApprovalMap.keySet();
        allCollectIds.addAll(existsBillIds);
        allCollectIds.addAll(collectIdSet);
        if (CollectionUtils.isEmpty(allCollectIds)) {
            return;
        }
        String selectFields = String.join((CharSequence)",", "id", "inoutdirection", "approvalstatus", "approvalbillno", "approvalbillid");
        for (DynamicObject dynamicObject : load = TmcDataServiceHelper.load((String)"fpm_inoutcollect", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", allCollectIds)})) {
            int addOrDelete = 0;
            Long collectBillId = (Long)dynamicObject.getPkValue();
            String inoutDirection = dynamicObject.getString("inoutdirection");
            if (!collectIdSet.contains(collectBillId)) {
                dynamicObject.set("approvalstatus", (Object)InoutCollectApprovalStatusEnum.NOT_APPROVAL.getCode());
                dynamicObject.set("approvalbillno", (Object)"");
                dynamicObject.set("approvalbillid", (Object)0L);
                Long approvalBillId = entryExistCollectMap.get(collectBillId);
                DynamicObject approvalBill = (DynamicObject)existsBillMap.get(approvalBillId);
                addOrDelete = -1;
                this.updateFlowCounts(addOrDelete, inoutDirection, approvalBill);
                continue;
            }
            if (existsBillIds.contains(collectBillId)) continue;
            DynamicObject approvalBill = (DynamicObject)collectIdApprovalMap.get(collectBillId);
            dynamicObject.set("approvalstatus", (Object)InoutCollectApprovalStatusEnum.APPROVING.getCode());
            dynamicObject.set("approvalbillno", (Object)approvalBill.getString("billno"));
            dynamicObject.set("approvalbillid", approvalBill.get("id"));
            addOrDelete = 1;
            this.updateFlowCounts(addOrDelete, inoutDirection, approvalBill);
        }
        TmcDataServiceHelper.save((DynamicObject[])load);
        List pairList = collectIdApprovalMap.entrySet().stream().map(entry -> Pair.of(entry.getKey(), (Object)((Long)((DynamicObject)entry.getValue()).getPkValue()))).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(pairList)) {
            return;
        }
        TmcBotpHelper.batchSaveRelation((String)"fpm_inoutcollect", (String)"fpm_approvaldispose", pairList);
    }

    private void updateFlowCounts(int addOrDelete, String inoutDirection, DynamicObject approvalBill) {
        if (approvalBill == null) {
            return;
        }
        if (StringUtils.equals((CharSequence)inoutDirection, (CharSequence)InoutCollectInoutDirectionEnum.IN.getCode())) {
            int inCount = approvalBill.getInt("flowincount");
            approvalBill.set("flowincount", (Object)(inCount + addOrDelete));
        } else if (StringUtils.equals((CharSequence)inoutDirection, (CharSequence)InoutCollectInoutDirectionEnum.OUT.getCode())) {
            int outCount = approvalBill.getInt("flowoutcount");
            approvalBill.set("flowoutcount", (Object)(outCount + addOrDelete));
        }
    }

    private Map<Long, Long> getExistCollectIdMap(Set<Long> existsBillIds) {
        if (CollectionUtils.isEmpty(existsBillIds)) {
            return Collections.emptyMap();
        }
        String entryApplyBillIdField = String.join((CharSequence)".", "entryentity", "entry_applyinfoid");
        String existBillEntryIdSelectFields = String.join((CharSequence)",", "id", entryApplyBillIdField);
        DynamicObject[] existBill = TmcDataServiceHelper.load((String)"fpm_approvaldispose", (String)existBillEntryIdSelectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", existsBillIds)});
        HashMap<Long, Long> map = new HashMap<Long, Long>(existsBillIds.size());
        for (DynamicObject dynamicObject : existBill) {
            DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : dynamicObjectCollection) {
                map.put(entry.getLong("entry_applyinfoid"), dynamicObject.getLong("id"));
            }
        }
        return map;
    }

    private void fillCollectIdMapAndExistBillMap(DynamicObject[] dataEntities, Map<Long, DynamicObject> collectIdApprovalMap, Map<Long, DynamicObject> existsBillMap) {
        for (DynamicObject entity : dataEntities) {
            Long approvalId = entity.getLong("id");
            if (EmptyUtil.isEmpty((Long)approvalId)) {
                approvalId = DB.genLongId((String)EntityMetadataCache.getDataEntityType((String)"fpm_approvaldispose").getAlias());
                entity.set("id", (Object)approvalId);
            } else {
                existsBillMap.put(approvalId, entity);
            }
            DynamicObjectCollection dynamicObjectCollection = entity.getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) continue;
            for (DynamicObject collectBill : dynamicObjectCollection) {
                collectIdApprovalMap.put(collectBill.getLong("entry_applyinfoid"), entity);
            }
        }
    }
}

