/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.cache.serialize;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import kd.tmc.fpm.business.cache.data.CacheBlock;
import kd.tmc.fpm.business.cache.data.CacheCell;
import kd.tmc.fpm.business.cache.data.CacheCellMeta;
import kd.tmc.fpm.business.cache.serialize.IFpmSerializer;

public class CacheBlockSerializer
implements IFpmSerializer<CacheBlock> {
    private CacheCellMeta meta;

    public CacheBlockSerializer(CacheCellMeta meta) {
        this.meta = meta;
    }

    @Override
    public String serialize(CacheBlock object) {
        JSONArray jsonArray = new JSONArray(3);
        jsonArray.add((Object)object.getStart());
        jsonArray.add((Object)object.getEnd());
        JSONArray dataArr = new JSONArray(object.getCellList().size());
        jsonArray.add((Object)dataArr);
        int propCnt = this.meta.getPropList().size();
        for (CacheCell cacheCell : object.getCellList()) {
            if (cacheCell != null) {
                JSONArray valueArr = new JSONArray(propCnt);
                for (String prop : this.meta.getPropList()) {
                    valueArr.add(cacheCell.getPropValue(prop));
                }
                dataArr.add((Object)valueArr);
                continue;
            }
            dataArr.add(null);
        }
        return jsonArray.toJSONString();
    }

    @Override
    public CacheBlock deserialize(String serializeStr) {
        CacheBlock block = new CacheBlock();
        JSONArray array = JSON.parseArray((String)serializeStr);
        if (array.size() != 3) {
            throw new IllegalArgumentException("SerializeStr parse error.");
        }
        block.setStart((Integer)array.get(0));
        block.setEnd((Integer)array.get(1));
        JSONArray dataArr = array.getJSONArray(2);
        ArrayList<CacheCell> cellList = new ArrayList<CacheCell>(dataArr.size());
        block.setCellList(cellList);
        for (int i = 0; i < dataArr.size(); ++i) {
            JSONArray data = dataArr.getJSONArray(i);
            if (data == null) {
                cellList.add(null);
                continue;
            }
            CacheCell cell = new CacheCell();
            for (int j = 0; j < data.size() && j < this.meta.getPropList().size(); ++j) {
                String prop = this.meta.getPropList().get(j);
                Object propVal = data.get(j);
                cell.setPropValue(prop, propVal);
            }
            cellList.add(cell);
        }
        return block;
    }
}

