/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.cache.serialize;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.TypeReference;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import kd.tmc.fpm.business.cache.serialize.IFpmSerializer;
import kd.tmc.fpm.business.spread.formula.Formula;
import kd.tmc.fpm.business.spread.formula.FormulaOperationVal;
import kd.tmc.fpm.business.spread.formula.FormulaOperatorSymbol;
import kd.tmc.fpm.business.spread.formula.IFormulaOperator;
import kd.tmc.fpm.business.spread.formula.enums.FormulaOperationValType;
import kd.tmc.fpm.business.spread.formula.enums.FormulaSymbolEnum;
import kd.tmc.fpm.business.spread.formula.impl.DAGEdge;
import kd.tmc.fpm.business.spread.formula.impl.DAGManager;
import kd.tmc.fpm.business.spread.formula.impl.DAGNode;

public class DagManagerSerializer<T>
implements IFpmSerializer<DAGManager<T>> {
    private Map<T, DAGNode<T>> nodeMap;

    @Override
    public String serialize(DAGManager<T> object) {
        Set<DAGNode<T>> headSet = object.getHeadSet();
        JSONArray headArr = new JSONArray();
        for (DAGNode<T> head : headSet) {
            Formula formula;
            JSONArray nodeArr = new JSONArray();
            T val = head.getVal();
            nodeArr.add(val);
            Set<DAGEdge<T>> edges = head.getEdges();
            if (edges != null && edges.size() > 0) {
                JSONArray edge = this.buildEdge(edges);
                nodeArr.add((Object)edge);
            }
            if ((formula = head.getFormula()) != null) {
                nodeArr.add((Object)this.buildFormula(formula));
            }
            headArr.add((Object)nodeArr);
        }
        return headArr.toJSONString();
    }

    @Override
    public DAGManager<T> deserialize(String serializeStr) {
        this.nodeMap = new HashMap<T, DAGNode<T>>(8);
        HashSet headSet = new HashSet(8);
        JSONArray headSetArr = JSON.parseArray((String)serializeStr);
        for (int i = 0; i < headSetArr.size(); ++i) {
            JSONArray nodeArr = headSetArr.getJSONArray(i);
            Object val = nodeArr.getObject(0, new TypeReference<T>(){}.getType());
            DAGNode<Object> node = this.getOrCreateNode(val);
            if (nodeArr.size() > 1) {
                JSONArray edgeArr = nodeArr.getJSONArray(1);
                Set<DAGEdge<T>> edges = this.parseEdge(edgeArr);
                node.setEdges(edges);
            }
            if (nodeArr.size() > 2) {
                JSONArray formulaArr = nodeArr.getJSONArray(2);
                Formula formula = this.parseFormula(formulaArr);
                node.setFormula(formula);
            }
            headSet.add(node);
        }
        DAGManager manager = new DAGManager();
        manager.rebuild(headSet);
        return manager;
    }

    private DAGNode<T> getOrCreateNode(T val) {
        return this.nodeMap.computeIfAbsent(val, o -> new DAGNode<Object>(val));
    }

    private JSONArray buildEdge(Set<DAGEdge<T>> edges) {
        JSONArray edgeArr = new JSONArray();
        for (DAGEdge<T> edge : edges) {
            T val = edge.getDestNode().getVal();
            edgeArr.add(val);
        }
        return edgeArr;
    }

    private Set<DAGEdge<T>> parseEdge(JSONArray edgeArr) {
        HashSet<DAGEdge<T>> edgeSet = new HashSet<DAGEdge<T>>(8);
        for (int i = 0; i < edgeArr.size(); ++i) {
            DAGEdge<Object> edge = new DAGEdge<Object>();
            edgeSet.add(edge);
            Object val = edgeArr.getObject(i, new TypeReference<T>(){}.getType());
            DAGNode<Object> destNode = this.getOrCreateNode(val);
            edge.setDestNode(destNode);
        }
        return edgeSet;
    }

    private JSONArray buildFormula(Formula formula) {
        JSONArray formulaArr = new JSONArray();
        FormulaOperationVal leftVal = formula.getLeftVal();
        formulaArr.add((Object)leftVal.getName());
        Deque<IFormulaOperator> operatorList = formula.getOperator();
        JSONArray valArr = new JSONArray();
        JSONArray valTypeArr = new JSONArray();
        JSONArray symbolListArr = new JSONArray();
        formulaArr.add((Object)valArr);
        formulaArr.add((Object)valTypeArr);
        formulaArr.add((Object)symbolListArr);
        JSONArray symbolArr = null;
        for (IFormulaOperator operator : operatorList) {
            if (operator instanceof FormulaOperationVal) {
                if (symbolArr == null) {
                    symbolListArr.add((Object)new JSONArray());
                }
                symbolArr = new JSONArray();
                symbolListArr.add((Object)symbolArr);
                valArr.add((Object)((FormulaOperationVal)operator).getName());
                valTypeArr.add((Object)((FormulaOperationVal)operator).getValType().ordinal());
                continue;
            }
            if (!(operator instanceof FormulaOperatorSymbol)) continue;
            if (symbolArr == null) {
                symbolArr = new JSONArray();
                symbolListArr.add((Object)symbolArr);
            }
            symbolArr.add((Object)((FormulaOperatorSymbol)operator).getOpSymbol().ordinal());
        }
        return formulaArr;
    }

    private Formula parseFormula(JSONArray formulaArr) {
        Formula formula = new Formula();
        LinkedList<IFormulaOperator> operatorQueue = new LinkedList<IFormulaOperator>();
        String leftVar = formulaArr.getString(0);
        formula.setLeftVal(new FormulaOperationVal(leftVar, leftVar));
        JSONArray valueArr = formulaArr.getJSONArray(1);
        JSONArray valueTypeArr = formulaArr.getJSONArray(2);
        JSONArray symbolListArr = formulaArr.getJSONArray(3);
        for (int i = 0; i < symbolListArr.size(); ++i) {
            if (i > 0) {
                String value = valueArr.getString(i - 1);
                Integer ordinate = valueTypeArr.getInteger(i - 1);
                FormulaOperationValType valTypeByOrdinate = this.getValTypeByOrdinate(ordinate);
                FormulaOperationVal val = new FormulaOperationVal(value, value);
                val.setValType(valTypeByOrdinate);
                operatorQueue.add(val);
            }
            JSONArray symbolArray = symbolListArr.getJSONArray(i);
            for (int j = 0; j < symbolArray.size(); ++j) {
                Integer ordinate = symbolArray.getInteger(j);
                FormulaSymbolEnum symbolEnum = this.getByOrdinate(ordinate);
                FormulaOperatorSymbol symbol = new FormulaOperatorSymbol(symbolEnum);
                operatorQueue.add(symbol);
            }
        }
        formula.setOperator(operatorQueue);
        return formula;
    }

    private FormulaSymbolEnum getByOrdinate(int ordinate) {
        for (FormulaSymbolEnum value : FormulaSymbolEnum.values()) {
            if (value.ordinal() != ordinate) continue;
            return value;
        }
        return null;
    }

    private FormulaOperationValType getValTypeByOrdinate(int ordinate) {
        for (FormulaOperationValType value : FormulaOperationValType.values()) {
            if (value.ordinal() != ordinate) continue;
            return value;
        }
        return null;
    }

    public static void main(String[] args) {
        DAGManager manager = new DAGManager();
        HashSet headSet = new HashSet();
        DAGNode<String> nodeA = new DAGNode<String>("A");
        DAGNode<String> nodeB = new DAGNode<String>("B");
        DAGNode<String> nodeC = new DAGNode<String>("C");
        nodeA.addEdge(new DAGEdge<String>(nodeB));
        nodeA.addEdge(new DAGEdge<String>(nodeC));
        Formula formula = new Formula();
        formula.setLeftVal(new FormulaOperationVal("A", "A"));
        LinkedList<IFormulaOperator> operatorQueue = new LinkedList<IFormulaOperator>();
        operatorQueue.add(new FormulaOperationVal("B", "B"));
        operatorQueue.add(new FormulaOperatorSymbol(FormulaSymbolEnum.PLUS));
        operatorQueue.add(new FormulaOperationVal("C", "C"));
        formula.setOperator(operatorQueue);
        nodeA.setFormula(formula);
        headSet.add(nodeA);
        manager.setHeadSet(headSet);
        DagManagerSerializer serializer = new DagManagerSerializer();
        String serialize = serializer.serialize(manager);
        System.out.println(serialize);
        Object deserialize = serializer.deserialize(serialize);
        System.out.println(deserialize);
    }
}

