/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.context;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.model.control.BillBizInfo;
import kd.tmc.fpm.business.domain.model.control.ControlBOTPInfo;
import kd.tmc.fpm.business.domain.model.control.PlanExecuteRecord;
import kd.tmc.fpm.business.mvc.repository.IControlRepository;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;

public class ControlBotpUpperHolder {
    private static final String BILL_HEAD = "billhead";
    private static IControlRepository controlRepository = FpmServiceFactory.getBizService(IControlRepository.class);
    private static final ThreadLocal<Map<Long, List<ControlBOTPInfo>>> controlBotpInfoHolder = ThreadLocal.withInitial(() -> new HashMap(16));

    public static void set(DynamicObject[] selectBills) {
        Map<Long, List<ControlBOTPInfo>> longControlBOTPInfoMap = controlBotpInfoHolder.get();
        block0: for (DynamicObject selectBill : selectBills) {
            long selectBillId = selectBill.getLong("id");
            String entityNumber = selectBill.getDataEntityType().getName();
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            Map allEntities = dataEntityType.getAllEntities();
            if (EmptyUtil.isEmpty((Object)allEntities)) continue;
            for (Map.Entry entry : allEntities.entrySet()) {
                Node leafNode;
                String entryKey = (String)entry.getKey();
                EntityType entityType = (EntityType)entry.getValue();
                if (!LinkEntryType.class.isInstance(entityType)) continue;
                String entityTypeName = entityType.getName();
                if (entityTypeName.startsWith(BILL_HEAD)) {
                    DynamicObjectCollection dynamicObjectCollection = selectBill.getDynamicObjectCollection(entryKey);
                    if (EmptyUtil.isEmpty((DynamicObjectCollection)dynamicObjectCollection)) continue;
                    for (DynamicObject linkDy : dynamicObjectCollection) {
                        ControlBOTPInfo controlBOTPInfo = ControlBotpUpperHolder.getControlBOTPInfo(entryKey, linkDy);
                        if (controlBOTPInfo == null) continue;
                        longControlBOTPInfoMap.putIfAbsent(selectBillId, Collections.singletonList(controlBOTPInfo));
                        continue block0;
                    }
                }
                LinkEntryType linkEntryType = (LinkEntryType)entityType;
                Node currentNode = leafNode = new Node(linkEntryType.getName());
                IDataEntityType parent = linkEntryType.getParent();
                while (Objects.nonNull(parent) && EntryType.class.isInstance(parent)) {
                    EntryType entryType = (EntryType)parent;
                    Node tempNode = new Node(entryType.getName(), currentNode);
                    currentNode.setBefore(tempNode);
                    currentNode = tempNode;
                    parent = entryType.getParent();
                }
                DynamicObject dy = selectBill;
                HashSet<ControlBOTPInfo> controlBOTPInfoSet = new HashSet<ControlBOTPInfo>(64);
                ControlBotpUpperHolder.fillLinkInfo(dy, currentNode, controlBOTPInfoSet);
            }
        }
    }

    private static void fillLinkInfo(DynamicObject dy, Node currentNode, Set<ControlBOTPInfo> controlBOTPInfoSet) {
        String entryName = currentNode.getVal();
        DynamicObjectCollection dc = dy.getDynamicObjectCollection(entryName);
        if (EmptyUtil.isEmpty((DynamicObjectCollection)dc)) {
            return;
        }
        for (DynamicObject dynamicObject : dc) {
            ControlBOTPInfo controlBOTPInfo;
            if (currentNode.hasNext()) {
                ControlBotpUpperHolder.fillLinkInfo(dynamicObject, currentNode.next, controlBOTPInfoSet);
                continue;
            }
            if (!LinkEntryType.class.isInstance(dynamicObject.getDataEntityType()) || (controlBOTPInfo = ControlBotpUpperHolder.getControlBOTPInfo(currentNode.val, dynamicObject)) == null) continue;
            controlBOTPInfoSet.add(controlBOTPInfo);
        }
    }

    public static void set(List<PlanExecuteRecord> planExecuteRecordList) {
        List<Long> planExecuteRecordIds = planExecuteRecordList.stream().map(PlanExecuteRecord::getId).distinct().collect(Collectors.toList());
        List<PlanExecuteRecord> relatePlanExecuteRecordList = controlRepository.loadRelatePlanExecuteRecord(planExecuteRecordIds);
        if (EmptyUtil.isEmpty(relatePlanExecuteRecordList)) {
            return;
        }
        Map<Long, List<PlanExecuteRecord>> relatePlanExecuteRecordMap = relatePlanExecuteRecordList.stream().collect(Collectors.groupingBy(PlanExecuteRecord::getRelateRecordId));
        Map<Long, List<ControlBOTPInfo>> longListMap = controlBotpInfoHolder.get();
        for (PlanExecuteRecord planExecuteRecord : planExecuteRecordList) {
            List controlBOTPInfoList;
            Long planExecuteRecordId = planExecuteRecord.getId();
            List currentRelatePlanExecuteRecords = relatePlanExecuteRecordMap.getOrDefault(planExecuteRecordId, Collections.emptyList());
            BillBizInfo billBizInfo = planExecuteRecord.getBillBizInfo();
            if (Objects.isNull(billBizInfo) || EmptyUtil.isNoEmpty((Object)(controlBOTPInfoList = longListMap.computeIfAbsent(billBizInfo.getBillId(), k -> new ArrayList(16))))) continue;
            ControlBOTPInfo currentControlBOTPInfo = ControlBotpUpperHolder.getControlBOTPInfoFromPlanExecuteRecord(planExecuteRecord);
            HashSet<ControlBOTPInfo> controlBOTPInfoSet = new HashSet<ControlBOTPInfo>(16);
            for (PlanExecuteRecord currentRelatePlanExecuteRecord : currentRelatePlanExecuteRecords) {
                ControlBOTPInfo relateControlBOTPInfo = ControlBotpUpperHolder.getControlBOTPInfoFromPlanExecuteRecord(currentRelatePlanExecuteRecord);
                if (Objects.equals(currentControlBOTPInfo, relateControlBOTPInfo)) continue;
                controlBOTPInfoSet.add(relateControlBOTPInfo);
            }
            controlBOTPInfoList.addAll(controlBOTPInfoSet);
        }
    }

    private static ControlBOTPInfo getControlBOTPInfoFromPlanExecuteRecord(PlanExecuteRecord planExecuteRecord) {
        ControlBOTPInfo controlBOTPInfo = new ControlBOTPInfo();
        BillBizInfo billBizInfo = planExecuteRecord.getBillBizInfo();
        controlBOTPInfo.setId(billBizInfo.getBillId());
        controlBOTPInfo.setEntityType(billBizInfo.getEntityType());
        controlBOTPInfo.setEntryId(billBizInfo.getEntryId());
        return controlBOTPInfo;
    }

    private static ControlBOTPInfo getControlBOTPInfo(String entryKey, DynamicObject linkRow) {
        Long tableId = linkRow.getLong(entryKey + "_stableid");
        Long sourceBillId = linkRow.getLong(entryKey + "_sbillid");
        Long sourceEntryId = linkRow.getLong(entryKey + "_sid");
        TableDefine tableDefine = EntityMetadataCache.loadTableDefine((Long)tableId);
        if (EmptyUtil.isEmpty((Object)tableDefine)) {
            return null;
        }
        ControlBOTPInfo controlBOTPInfo = new ControlBOTPInfo();
        controlBOTPInfo.setEntityType(tableDefine.getEntityNumber());
        controlBOTPInfo.setId(sourceBillId);
        controlBOTPInfo.setEntryId(sourceEntryId);
        return controlBOTPInfo;
    }

    public static List<ControlBOTPInfo> get(Long billId) {
        return controlBotpInfoHolder.get().getOrDefault(billId, Collections.emptyList());
    }

    public static void clean() {
        controlBotpInfoHolder.remove();
    }

    private static class Node
    implements Iterator<Node> {
        private String val;
        private Node next;
        private Node before;

        public Node(String val) {
            this(val, null);
        }

        public Node(String val, Node next) {
            this.val = val;
            this.next = next;
        }

        public String getVal() {
            return this.val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public Node getNext() {
            return this.next;
        }

        public void setNext(Node next) {
            this.next = next;
        }

        public Node getBefore() {
            return this.before;
        }

        public void setBefore(Node before) {
            this.before = before;
        }

        @Override
        public boolean hasNext() {
            return Objects.nonNull(this.next);
        }

        @Override
        public Node next() {
            return this.next;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            Node current = this;
            while (current.hasNext()) {
                sb.append(current.getVal()).append("/");
                current = current.next;
            }
            if (sb.length() > 0) {
                sb.deleteCharAt(sb.length() - 1);
            }
            return sb.toString();
        }
    }
}

