/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.dataproc.openapi.balancequery.generator.impl;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.dataproc.openapi.balancequery.factory.AvailableReportDataFactory;
import kd.tmc.fpm.business.dataproc.openapi.balancequery.generator.IAvailableAmtCalculate;
import kd.tmc.fpm.business.dataproc.openapi.balancequery.generator.IBalanceQueryResultGenerator;
import kd.tmc.fpm.business.dataproc.openapi.balancequery.generator.impl.AmountUnitConverterAvailableAmtCalculate;
import kd.tmc.fpm.business.dataproc.openapi.balancequery.generator.impl.DimensionInfoCacheManager;
import kd.tmc.fpm.business.dataproc.openapi.model.AvailableReportData;
import kd.tmc.fpm.business.dataproc.openapi.model.BalanceQueryDetailInfo;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.mvc.service.context.ControlContext;
import kd.tmc.fpm.business.utils.LogFormatUtil;
import kd.tmc.fpm.common.bean.DimensionInfoBean;

public abstract class AbstractBalanceQueryResultGenerator
implements IBalanceQueryResultGenerator {
    protected ControlContext controlContext;
    private final boolean accurate;
    protected final Log logger = LogFactory.getLog(this.getClass());
    private AbstractBalanceQueryResultGenerator abstractBalanceQueryResultGenerator;
    protected IAvailableAmtCalculate<AvailableReportData> availableAmtCalculate;
    protected DimensionInfoCacheManager dimensionInfoCacheManager;

    public AbstractBalanceQueryResultGenerator(ControlContext controlContext, boolean accurate) {
        this(controlContext, accurate, new AmountUnitConverterAvailableAmtCalculate());
    }

    public AbstractBalanceQueryResultGenerator(ControlContext controlContext, boolean accurate, IAvailableAmtCalculate<AvailableReportData> availableAmtCalculate) {
        this.controlContext = controlContext;
        this.accurate = accurate;
        this.availableAmtCalculate = availableAmtCalculate;
        this.dimensionInfoCacheManager = new DimensionInfoCacheManager();
    }

    public AbstractBalanceQueryResultGenerator(AbstractBalanceQueryResultGenerator abstractBalanceQueryResultGenerator) {
        this.abstractBalanceQueryResultGenerator = abstractBalanceQueryResultGenerator;
        this.controlContext = abstractBalanceQueryResultGenerator.controlContext;
        this.accurate = abstractBalanceQueryResultGenerator.accurate;
        this.availableAmtCalculate = abstractBalanceQueryResultGenerator.availableAmtCalculate;
        this.dimensionInfoCacheManager = abstractBalanceQueryResultGenerator.dimensionInfoCacheManager;
    }

    @Override
    public List<BalanceQueryDetailInfo> generate() {
        if (Objects.nonNull(this.abstractBalanceQueryResultGenerator)) {
            return this.abstractBalanceQueryResultGenerator.generate();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isAccurate() {
        return this.accurate;
    }

    protected void addReportDataListAndUpdateAvailableAmt(BalanceQueryDetailInfo balanceQueryDetailInfo, List<ReportData> reportDataList) {
        if (EmptyUtil.isEmpty(reportDataList)) {
            return;
        }
        for (ReportData reportData : balanceQueryDetailInfo.getMatchedSameReportDataAll()) {
            balanceQueryDetailInfo.addMatchedReportData(reportData);
        }
        balanceQueryDetailInfo.updateAvailableAmt(this.calculateAvailableAmt(balanceQueryDetailInfo, reportDataList));
    }

    protected BigDecimal calculateAvailableAmt(BalanceQueryDetailInfo balanceQueryDetailInfo, List<ReportData> reportDataList) {
        return this.calculateAvailableAmt(balanceQueryDetailInfo, this.sumReportData(reportDataList));
    }

    protected BigDecimal calculateAvailableAmt(BalanceQueryDetailInfo balanceQueryDetailInfo, ReportData reportData) {
        FundPlanSystem system = this.controlContext.getSystem(reportData.getSystemId());
        AvailableReportData availableReportData = AvailableReportDataFactory.getAvailableReportData(reportData, system, balanceQueryDetailInfo.getControlStrategyDetail());
        return this.availableAmtCalculate.calculate(availableReportData);
    }

    protected List<ReportData> mainReportData(List<ReportData> reportDataList) {
        Map<Boolean, List<ReportData>> reportDataMap = reportDataList.stream().collect(Collectors.groupingBy(ReportData::isMainTable));
        return reportDataMap.getOrDefault(Boolean.TRUE, reportDataMap.get(Boolean.FALSE));
    }

    protected void check(BalanceQueryDetailInfo balanceQueryDetailInfo, DimensionInfoBean dimensionInfoBean, List<ReportData> reportDataList) {
        if (EmptyUtil.isEmpty(reportDataList)) {
            FundPlanSystem system = this.controlContext.getSystem(balanceQueryDetailInfo.getSystemId());
            this.logger.info("\u4f53\u7cfb\uff1a{}\uff0c\u7ef4\u5ea6\u7ec4\u5408:{}\u672a\u5339\u914d\u4e0a\u6570\u636e\uff0c\u6267\u884c\u53c2\u6570\uff1a{}", new Object[]{system.getName(), dimensionInfoBean, balanceQueryDetailInfo.getControlExecuteParam()});
            String message = String.format(ResManager.loadKDString((String)"\u4f53\u7cfb\u3010%1$s\u3011\u7ef4\u5ea6\u7ec4\u5408\u3010%2$s\u3011\u672a\u5339\u914d\u4e0a\u6570\u636e\u3002", (String)"AbstractBalanceQueryResultGenerator_1", (String)"tmc-fpm-business", (Object[])new Object[0]), system.getName(), LogFormatUtil.formatDimensionBeanInfo(dimensionInfoBean, system));
            throw new KDBizException(message);
        }
    }

    protected ReportData sumReportData(List<ReportData> reportDataList) {
        ReportData data = this.getReportData(reportDataList.get(0));
        this.sum2ReportData(data, reportDataList);
        return data;
    }

    protected ReportData getReportData(ReportData data) {
        ReportData reportData = new ReportData(data);
        reportData.setId(data.getId());
        return reportData;
    }

    protected void sum2ReportData(ReportData targetReportData, List<ReportData> reportDataList) {
        this.sum2ReportData(targetReportData, reportDataList, true);
    }

    protected void sum2ReportData(ReportData targetReportData, List<ReportData> reportDataList, boolean needClear) {
        if (needClear) {
            targetReportData.clearAmt();
        }
        reportDataList.forEach(rd -> this.sum2ReportData(targetReportData, (ReportData)rd));
    }

    protected void sum2ReportData(ReportData targetReportData, ReportData sourceReportData) {
        targetReportData.add(sourceReportData);
        targetReportData.getSourceIdList().add(sourceReportData.getId());
    }

    protected void updatePeriodMemberForCurrentPeriod(ReportData reportData) {
        this.updateDimValue(reportData, reportData.getReportPeriodId(), td -> td.getDimType().isPeriodDim());
    }

    protected void updateSubjectId(ReportData reportData, Long subjectId) {
        this.updateDimValue(reportData, subjectId, td -> td.getDimType().isSubjectDim());
    }

    protected void updateDimValue(ReportData reportData, Long memberId, Predicate<TemplateDim> predicate) {
        List<TemplateDim> dimList = reportData.getDimList();
        List<Object> dataDimValList = reportData.getDimValList();
        for (int i = 0; i < dimList.size(); ++i) {
            if (!predicate.test(dimList.get(i))) continue;
            dataDimValList.set(i, memberId);
        }
    }
}

