/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.dataproc.openapi.balancequery.generator.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.dataproc.openapi.balancequery.generator.impl.AbstractBalanceQueryResultGenerator;
import kd.tmc.fpm.business.dataproc.openapi.model.BalanceQueryDetailInfo;
import kd.tmc.fpm.business.dataproc.query.IReportDataQueryService;
import kd.tmc.fpm.business.dataproc.query.ReportDataQueryService;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.model.control.ControlStrategy;
import kd.tmc.fpm.business.domain.model.control.ControlStrategyDetail;
import kd.tmc.fpm.business.domain.model.control.DimValueListInfo;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.index.generate.bean.QueryIndexInfo;
import kd.tmc.fpm.business.domain.model.index.generate.bean.WarpBean;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.utils.DimensionInfoHelper;
import kd.tmc.fpm.business.utils.ListHelper;
import kd.tmc.fpm.common.bean.DimensionInfoBean;
import kd.tmc.fpm.common.utils.NumberUtils;

public class ControlStrategyBalanceQueryResultGenerator
extends AbstractBalanceQueryResultGenerator {
    private IReportDataQueryService reportDataQueryService = new ReportDataQueryService();

    public ControlStrategyBalanceQueryResultGenerator(AbstractBalanceQueryResultGenerator abstractBalanceQueryResultGenerator) {
        super(abstractBalanceQueryResultGenerator);
    }

    @Override
    public List<BalanceQueryDetailInfo> generate() {
        List<BalanceQueryDetailInfo> balanceQueryDetailInfoList = super.generate();
        this.completeUpperSubjectDataIfNeed(balanceQueryDetailInfoList);
        for (BalanceQueryDetailInfo balanceQueryDetailInfo : balanceQueryDetailInfoList) {
            ControlStrategy controlStrategy = this.controlContext.getControlStrategy(balanceQueryDetailInfo.getSystemId(), balanceQueryDetailInfo.getReportTypeId(), balanceQueryDetailInfo.getReportOrgId());
            if (Objects.isNull(controlStrategy)) continue;
            ControlStrategyDetail controlStrategyDetail = balanceQueryDetailInfo.getControlStrategyDetail();
            if (Objects.isNull(controlStrategyDetail)) {
                this.notControl(balanceQueryDetailInfo);
                continue;
            }
            this.controlByControlStrategy(balanceQueryDetailInfo);
        }
        return balanceQueryDetailInfoList;
    }

    private void controlByControlStrategy(BalanceQueryDetailInfo balanceQueryDetailInfo) {
        ControlStrategyDetail controlStrategyDetail = balanceQueryDetailInfo.getControlStrategyDetail();
        List<ControlStrategyDetail.DetailControlBasis> detailControlBasisList = controlStrategyDetail.getDetailControlBasisList();
        if (EmptyUtil.isEmpty(detailControlBasisList)) {
            this.controlNotDetail(balanceQueryDetailInfo);
            return;
        }
        this.detailControl(balanceQueryDetailInfo, detailControlBasisList);
    }

    private void detailControl(BalanceQueryDetailInfo balanceQueryDetailInfo, List<ControlStrategyDetail.DetailControlBasis> detailControlBasisList) {
        List<ReportData> reportDataList;
        DimensionInfoBean dimensionInfoBeanByFilter;
        Long periodMemId;
        Dimension period;
        Map periodMemMap;
        Long parentId;
        Map detailControlMap = detailControlBasisList.stream().collect(Collectors.groupingBy(ba -> ba.getDimensionType().isDetailDim(), Collectors.mapping(ControlStrategyDetail.DetailControlBasis::getDimensionId, Collectors.toSet())));
        Set optionalDimIds = detailControlMap.getOrDefault(Boolean.FALSE, Collections.emptySet());
        List<Long> floatMatchedDimIdS = balanceQueryDetailInfo.getControlExecuteParam().getFloatMatchedDimIdS();
        Set<Long> waitMatchOptionDimIds = ListHelper.asSet(optionalDimIds);
        floatMatchedDimIdS.forEach(waitMatchOptionDimIds::remove);
        FundPlanSystem system = this.controlContext.getSystem(balanceQueryDetailInfo.getSystemId());
        Dimension subjectDim = this.dimensionInfoCacheManager.getDimension(system, DimensionType.SUBJECTS);
        Long completeParentSubjectId = balanceQueryDetailInfo.getCompleteParentSubjectId();
        if (!EmptyUtil.isEmpty(waitMatchOptionDimIds)) {
            this.exception(balanceQueryDetailInfo, waitMatchOptionDimIds);
        }
        ControlStrategy controlStrategy = balanceQueryDetailInfo.getControlStrategy();
        ReportData reportData = balanceQueryDetailInfo.getControlExecuteParam().getReportData();
        if (controlStrategy.getPeriodControlStrategyType().isCurrentControl() && !NumberUtils.equalsZero((Long)(parentId = ((DimMember)(periodMemMap = (period = this.dimensionInfoCacheManager.getDimension(system, DimensionType.PERIOD)).getAllDimMemberList().stream().collect(Collectors.toMap(DimMember::getId, Function.identity()))).get(periodMemId = (Long)reportData.getDimValByDimType(DimensionType.PERIOD))).getParentId()))) {
            DimensionInfoBean dimensionInfoBean = DimensionInfoHelper.getDimensionInfoBean(reportData);
            DimensionInfoHelper.replaceDimValue(dimensionInfoBean, period.getId(), parentId);
            ReportData parentPeriodData = balanceQueryDetailInfo.getQueryIndexInfo().findOne(dimensionInfoBean);
            balanceQueryDetailInfo.getControlExecuteParam().setReportData(parentPeriodData);
            balanceQueryDetailInfo.getDimensionInfoBean().replaceValueIfContains(period.getId(), (Object)parentId);
        }
        if (EmptyUtil.isNoEmpty((Long)completeParentSubjectId)) {
            dimensionInfoBeanByFilter = DimensionInfoHelper.getDimensionInfoBeanByFilter(reportData, td -> td.getDimType().isSystemDim() || optionalDimIds.contains(td.getDimensionId()));
            dimensionInfoBeanByFilter.replaceValueIfContains(subjectDim.getId(), (Object)completeParentSubjectId);
            reportDataList = balanceQueryDetailInfo.getQueryIndexInfo().findList(dimensionInfoBeanByFilter);
            if (EmptyUtil.isEmpty(reportDataList)) {
                String matchRuleNumber = balanceQueryDetailInfo.getControlExecuteParam().getMatchRule().getNumber();
                String controlStrategyName = balanceQueryDetailInfo.getControlStrategy().getName();
                String controlDimSubjectName = this.dimensionInfoCacheManager.getDimMember(subjectDim, completeParentSubjectId).getName();
                String message = String.format(ResManager.loadKDString((String)"\u4f53\u7cfb\u3010%1$s\u3011\u4f7f\u7528\u4e1a\u52a1\u53d6\u6570\u89c4\u5219\u3010%2$s\u3011\u3001\u63a7\u5236\u7b56\u7565\u3010%3$s\u3011\u79d1\u76ee\u3010%4$s\u3011\u4e3a\u6309\u660e\u7ec6\u9879\u63a7\uff0c\u4f46\u5339\u914d\u4e0d\u4e0a\u5bf9\u5e94\u7684\u53ef\u9009\u7ef4\u5ea6\u3002", (String)"ControlStrategyBalanceQueryResultGenerator_0", (String)"tmc-fpm-business", (Object[])new Object[0]), system.getName(), matchRuleNumber, controlStrategyName, controlDimSubjectName);
                throw new KDBizException(message);
            }
            this.updateSubjectId(reportData, completeParentSubjectId);
            balanceQueryDetailInfo.setDimensionInfoBean(dimensionInfoBeanByFilter);
        } else {
            dimensionInfoBeanByFilter = balanceQueryDetailInfo.getDimensionInfoBean().copy();
            for (Long floatMatchedDimId : floatMatchedDimIdS) {
                if (optionalDimIds.contains(floatMatchedDimId)) continue;
                dimensionInfoBeanByFilter.removeDimensionInfo(floatMatchedDimId);
            }
            reportDataList = balanceQueryDetailInfo.getQueryIndexInfo().findList(dimensionInfoBeanByFilter);
        }
        DimensionInfoBean controlDimensionInfoBean = dimensionInfoBeanByFilter.copy();
        balanceQueryDetailInfo.setControlDimensionInfoBean(controlDimensionInfoBean);
        Dimension periodDim = this.dimensionInfoCacheManager.getDimension(system, DimensionType.PERIOD);
        DimMember reportPeriodMember = this.dimensionInfoCacheManager.getDimMember(periodDim, balanceQueryDetailInfo.getReportPeriodId());
        if (EmptyUtil.isNoEmpty(reportPeriodMember.getChildren()) && controlStrategy.getPeriodControlStrategyType().isCurrentControl()) {
            this.updatePeriodMemberForCurrentPeriod(reportData);
            this.addReportDataListAndUpdateAvailableAmt(balanceQueryDetailInfo, this.mainReportData(reportDataList));
            return;
        }
        Set<Long> detailDimIds = detailControlMap.getOrDefault(Boolean.TRUE, Collections.emptySet());
        if (EmptyUtil.isNoEmpty(detailDimIds)) {
            List<Long> list = balanceQueryDetailInfo.getControlExecuteParam().getDetailDimBitMap().findList(detailDimIds);
            Optional<ReportData> first = reportDataList.stream().filter(rd -> list.contains(rd.getId())).findFirst();
            if (!first.isPresent()) {
                throw new KDBizException("detail dimensionIds:" + detailDimIds + "not matched.");
            }
            reportData = first.get();
            Map<Long, Object> detailDimValueMap = DimensionInfoHelper.getDetailDimValueMap(reportData, detailDimIds);
            detailDimValueMap.forEach((arg_0, arg_1) -> ((DimensionInfoBean)controlDimensionInfoBean).addDimensionInfo(arg_0, arg_1));
            Predicate<ReportData> detailFieldMatchFilter = DimensionInfoHelper.getDetailFieldMatchFilter(detailDimValueMap, detailDimIds);
            reportDataList = reportDataList.stream().filter(rd -> !rd.isMainTable()).filter(detailFieldMatchFilter).collect(Collectors.toList());
            if (EmptyUtil.isEmpty(reportDataList)) {
                String matchRuleNumber = balanceQueryDetailInfo.getControlExecuteParam().getMatchRule().getNumber();
                String controlStrategyName = balanceQueryDetailInfo.getControlStrategy().getName();
                String controlDimSubjectName = this.dimensionInfoCacheManager.getDimMember(subjectDim, completeParentSubjectId).getName();
                String message = String.format(ResManager.loadKDString((String)"\u4f53\u7cfb\u3010%1$s\u3011\u4f7f\u7528\u4e1a\u52a1\u53d6\u6570\u89c4\u5219\u3010%2$s\u3011\u3001\u63a7\u5236\u7b56\u7565\u3010%3$s\u3011\u79d1\u76ee\u3010%4$s\u3011\u4e3a\u6309\u660e\u7ec6\u9879\u63a7\uff0c\u4f46\u5339\u914d\u4e0d\u4e0a\u5bf9\u5e94\u7684\u660e\u7ec6\u7ef4\u5ea6\u3002", (String)"ControlStrategyBalanceQueryResultGenerator_1", (String)"tmc-fpm-business", (Object[])new Object[0]), system.getName(), matchRuleNumber, controlStrategyName, controlDimSubjectName);
                throw new KDBizException(message);
            }
        } else {
            reportDataList = this.mainReportData(reportDataList);
        }
        this.addReportDataListAndUpdateAvailableAmt(balanceQueryDetailInfo, reportDataList);
    }

    private void exception(BalanceQueryDetailInfo balanceQueryDetailInfo, Set<Long> waitMatchOptionDimIds) {
        FundPlanSystem system = this.controlContext.getSystem(balanceQueryDetailInfo.getSystemId());
        Dimension subjectDim = this.dimensionInfoCacheManager.getDimension(system, DimensionType.SUBJECTS);
        ControlStrategyDetail controlStrategyDetail = balanceQueryDetailInfo.getControlStrategyDetail();
        String matchRuleNumber = balanceQueryDetailInfo.getControlExecuteParam().getMatchRule().getNumber();
        String controlStrategyName = balanceQueryDetailInfo.getControlStrategy().getName();
        String optionalDimName = waitMatchOptionDimIds.stream().map(optionalDimId -> this.dimensionInfoCacheManager.getDimension(system, (Long)optionalDimId)).map(Dimension::getName).collect(Collectors.joining(","));
        String notMatchDimSubjectName = this.dimensionInfoCacheManager.getDimMember(subjectDim, balanceQueryDetailInfo.getSubjectId()).getName();
        String controlDimSubjectName = this.dimensionInfoCacheManager.getDimMember(subjectDim, controlStrategyDetail.getSubjectId()).getName();
        String message = String.format(ResManager.loadKDString((String)"\u4f53\u7cfb\u3010%1$s\u3011\u4f7f\u7528\u4e1a\u52a1\u53d6\u6570\u89c4\u5219\u3010%2$s\u3011\u3001\u63a7\u5236\u7b56\u7565\u3010%3$s\u3011\u79d1\u76ee\u3010%4$s\u3011\u4e3a\u6309\u660e\u7ec6\u9879\u63a7\uff0c\u4f46\u79d1\u76ee\u3010%5$s\u3011\u5339\u914d\u4e0d\u4e0a\u53ef\u9009\u7ef4\u5ea6\u3010%6$s\u3011\u3002", (String)"ControlStrategyBalanceQueryResultGenerator_2", (String)"tmc-fpm-business", (Object[])new Object[0]), system.getName(), matchRuleNumber, controlStrategyName, controlDimSubjectName, notMatchDimSubjectName, optionalDimName);
        throw new KDBizException(message);
    }

    private void controlNotDetail(BalanceQueryDetailInfo balanceQueryDetailInfo) {
        QueryIndexInfo<Long, ReportData> queryIndexInfo = balanceQueryDetailInfo.getQueryIndexInfo();
        ReportData reportData = balanceQueryDetailInfo.getControlExecuteParam().getReportData();
        ReportData sumReportData = this.getReportData(reportData);
        ControlStrategy controlStrategy = balanceQueryDetailInfo.getControlStrategy();
        if (controlStrategy.getPeriodControlStrategyType().isCurrentControl()) {
            this.updatePeriodMemberForCurrentPeriod(sumReportData);
        }
        DimensionInfoBean dimensionInfoBeanByFilter = DimensionInfoHelper.getDimensionInfoBeanByFilter(sumReportData, td -> td.getDimType().isSystemDim());
        Long completeParentSubjectId = balanceQueryDetailInfo.getCompleteParentSubjectId();
        if (EmptyUtil.isNoEmpty((Long)completeParentSubjectId)) {
            Dimension subjectDim = this.dimensionInfoCacheManager.getDimension(this.controlContext.getSystem(balanceQueryDetailInfo.getSystemId()), DimensionType.SUBJECTS);
            dimensionInfoBeanByFilter.replaceValueIfContains(subjectDim.getId(), (Object)completeParentSubjectId);
        }
        List<ReportData> list = queryIndexInfo.findList(dimensionInfoBeanByFilter);
        balanceQueryDetailInfo.setControlDimensionInfoBean(dimensionInfoBeanByFilter.copy());
        this.addReportDataListAndUpdateAvailableAmt(balanceQueryDetailInfo, this.mainReportData(list));
    }

    private void notControl(BalanceQueryDetailInfo balanceQueryDetailInfo) {
        FundPlanSystem system = this.controlContext.getSystem(balanceQueryDetailInfo.getSystemId());
        QueryIndexInfo<Long, ReportData> queryIndexInfo = balanceQueryDetailInfo.getQueryIndexInfo();
        DimensionInfoBean dimensionInfoBean = balanceQueryDetailInfo.getDimensionInfoBean();
        Dimension periodDim = this.dimensionInfoCacheManager.getDimension(system, DimensionType.PERIOD);
        dimensionInfoBean.replaceValueIfContains(periodDim.getId(), (Object)balanceQueryDetailInfo.getReportPeriodId());
        ReportData reportData = queryIndexInfo.findOne(dimensionInfoBean);
        if (reportData == null) {
            this.logger.info("\u4f53\u7cfb\u3010%1$s\u3011\u4f7f\u7528\u4e1a\u52a1\u53d6\u6570\u89c4\u5219\u3010%2$s\u3011\u5339\u914d\u5230\u7684\u7ef4\u5ea6\u7ec4\u5408\u3010%3$s\u3011\u5339\u914d\u4e0d\u5230\u7f16\u5236\u8868\u6570\u636e\u3002");
            throw new KDBizException("");
        }
        DimensionInfoBean dimensionInfoBeanByFilter = DimensionInfoHelper.getDimensionInfoBeanByFilter(reportData, td -> td.getDimType().isSystemDim());
        List<ReportData> indexInfoList = queryIndexInfo.findList(dimensionInfoBeanByFilter);
        balanceQueryDetailInfo.setControlDimensionInfoBean(dimensionInfoBeanByFilter.copy());
        this.addReportDataListAndUpdateAvailableAmt(balanceQueryDetailInfo, this.mainReportData(indexInfoList));
    }

    private void completeUpperSubjectDataIfNeed(List<BalanceQueryDetailInfo> balanceQueryDetailInfoList) {
        List<ReportData> dataForAllSystem = this.queryCompleteSubjectDataIfNeed(balanceQueryDetailInfoList);
        if (EmptyUtil.isEmpty(dataForAllSystem)) {
            return;
        }
        Map<Long, List<ReportData>> reportIdDataMap = dataForAllSystem.stream().collect(Collectors.groupingBy(ReportData::getReportId));
        for (BalanceQueryDetailInfo balanceQueryDetailInfo : balanceQueryDetailInfoList) {
            if (!balanceQueryDetailInfo.hasControlStrategy() || EmptyUtil.isEmpty((Long)balanceQueryDetailInfo.getCompleteParentSubjectId())) continue;
            Set reportIds = balanceQueryDetailInfo.getControlExecuteParam().getMatchedReportDataList().stream().map(ReportData::getReportId).collect(Collectors.toSet());
            for (Long reportId : reportIds) {
                List<ReportData> reportDataList = reportIdDataMap.get(reportId);
                if (EmptyUtil.isEmpty(reportDataList)) continue;
                QueryIndexInfo<Long, ReportData> queryIndexInfo = balanceQueryDetailInfo.getQueryIndexInfo();
                reportDataList.forEach(rd -> queryIndexInfo.updateIndex(new WarpBean<Long, ReportData>(rd.getId(), DimensionInfoHelper.getDimensionInfoBean(rd), (ReportData)rd)));
            }
        }
    }

    private List<ReportData> queryCompleteSubjectDataIfNeed(List<BalanceQueryDetailInfo> balanceQueryDetailInfoList) {
        DimValueListInfo dimValueListInfo = new DimValueListInfo();
        HashSet reportIds = new HashSet(16);
        HashMap cache = new HashMap(16);
        for (BalanceQueryDetailInfo balanceQueryDetailInfo : balanceQueryDetailInfoList) {
            Long currentSubjectId;
            if (!balanceQueryDetailInfo.hasControlStrategy()) continue;
            ReportData reportData = balanceQueryDetailInfo.getControlExecuteParam().getReportData();
            Long subjectId = currentSubjectId = balanceQueryDetailInfo.getSubjectId();
            ControlStrategy controlStrategy = balanceQueryDetailInfo.getControlStrategy();
            if (!cache.containsKey(subjectId)) {
                List<ControlStrategyDetail> controlStrategyDetails = controlStrategy.getControlStrategyDetails();
                controlStrategyDetails.forEach(csd -> cache.put(csd.getSubjectId(), csd));
            }
            ControlStrategyDetail controlStrategyDetail = (ControlStrategyDetail)cache.get(subjectId);
            while (EmptyUtil.isNoEmpty((Long)subjectId) && EmptyUtil.isNoEmpty((Object)controlStrategyDetail) && EmptyUtil.isEmpty((Object)controlStrategyDetail.getControlIntensity())) {
                subjectId = controlStrategyDetail.getParentId();
                controlStrategyDetail = (ControlStrategyDetail)cache.get(subjectId);
            }
            if (EmptyUtil.isEmpty((Long)subjectId)) continue;
            if (Objects.isNull(controlStrategyDetail)) {
                this.logger.warn("\u4f53\u7cfb\uff1a{}\uff0c\u63a7\u5236\u7b56\u7565\uff1a{}\uff0c\u627e\u4e0d\u5230\u79d1\u76ee\uff1a{}\u7684\u660e\u7ec6\u63a7\u5236\u7b56\u7565\u3002");
                throw new KDBizException("controlStrategy: " + controlStrategy.getName());
            }
            if (Objects.equals(currentSubjectId, subjectId)) {
                balanceQueryDetailInfo.setControlStrategyDetail(controlStrategyDetail);
                continue;
            }
            balanceQueryDetailInfo.setControlStrategyDetail(controlStrategyDetail);
            FundPlanSystem system = this.controlContext.getSystem(balanceQueryDetailInfo.getSystemId());
            Dimension subjectDim = this.dimensionInfoCacheManager.getDimension(system, DimensionType.SUBJECTS);
            balanceQueryDetailInfo.setCompleteParentSubjectId(subjectId);
            dimValueListInfo.addDimensionValue(subjectDim, subjectId);
            Dimension periodDim = this.dimensionInfoCacheManager.getDimension(system, DimensionType.PERIOD);
            dimValueListInfo.addDimensionListValue(periodDim, ListHelper.asList(balanceQueryDetailInfo.getReportPeriodId(), reportData.getDimValByDimensionId(periodDim.getId())));
            dimValueListInfo.addDimensionValue(this.dimensionInfoCacheManager.getDimension(system, DimensionType.ORG), balanceQueryDetailInfo.getReportOrgId());
            Dimension currencyDim = this.dimensionInfoCacheManager.getDimension(system, DimensionType.CURRENCY);
            dimValueListInfo.addDimensionValue(currencyDim, reportData.getDimValByDimensionId(currencyDim.getId()));
            balanceQueryDetailInfo.getControlExecuteParam().getMatchedReportDataList().stream().map(ReportData::getReportId).forEach(reportIds::add);
        }
        if (dimValueListInfo.isEmpty()) {
            return Collections.emptyList();
        }
        return this.reportDataQueryService.queryReportDataForAllSystem(t -> {
            t.setDimIdList(dimValueListInfo.getDimensionList());
            t.setDimValList(dimValueListInfo.getDimValueList());
            t.setReportIdS(new ArrayList<Long>(reportIds));
            t.setNeedDimIfValueIsNotEmpty(true);
            t.setEffectFlag(true);
        });
    }
}

