/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.dataproc.openapi.balancequery.generator.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.dataproc.openapi.balancequery.generator.impl.AbstractBalanceQueryResultGenerator;
import kd.tmc.fpm.business.dataproc.openapi.model.BalanceQueryDetailInfo;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.index.generate.QueryIndexInfoMapGenerator;
import kd.tmc.fpm.business.domain.model.index.generate.bean.QueryIndexInfo;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.mvc.service.context.ControlContext;
import kd.tmc.fpm.business.mvc.service.params.ControlExecuteParam;
import kd.tmc.fpm.business.utils.CommonUtils;

public class DefaultBalanceQueryResultGenerator
extends AbstractBalanceQueryResultGenerator {
    public DefaultBalanceQueryResultGenerator(ControlContext controlContext, boolean accurate) {
        super(controlContext, accurate);
    }

    @Override
    public List<BalanceQueryDetailInfo> generate() {
        List<ControlExecuteParam> controlExecuteParamList = this.controlContext.getControlExecuteParamList();
        if (EmptyUtil.isEmpty(controlExecuteParamList)) {
            List<ControlExecuteParam> failedControlExecuteParamList = this.controlContext.getFailedControlExecuteParamList();
            String message = failedControlExecuteParamList.stream().map(ControlExecuteParam::getFailedCause).distinct().collect(Collectors.joining("\r\n"));
            throw new KDBizException(message);
        }
        ArrayList<BalanceQueryDetailInfo> balanceQueryDetailInfoList = new ArrayList<BalanceQueryDetailInfo>(controlExecuteParamList.size());
        for (ControlExecuteParam controlExecuteParam : controlExecuteParamList) {
            if (Objects.isNull(controlExecuteParam.getReportData())) {
                this.logger.warn("controlExecuteParam:{} reportData isn null", (Object)controlExecuteParam);
                continue;
            }
            BalanceQueryDetailInfo balanceQueryDetailInfo = new BalanceQueryDetailInfo(controlExecuteParam);
            balanceQueryDetailInfo.setControlStrategy(this.controlContext.getControlStrategy(controlExecuteParam.getSystemId(), controlExecuteParam.getReportTypeId(), controlExecuteParam.getReportOrgId()));
            balanceQueryDetailInfoList.add(balanceQueryDetailInfo);
            List<ReportData> matchedReportDataList = new ArrayList<ReportData>(controlExecuteParam.getMatchedReportDataList());
            matchedReportDataList.addAll(controlExecuteParam.getMatchedSameReportDataList());
            matchedReportDataList.addAll(controlExecuteParam.getOptionalMaybeNeedReportDataList());
            matchedReportDataList = CommonUtils.getDistinctList(matchedReportDataList, ReportData::getId);
            FundPlanSystem system = this.controlContext.getSystem(controlExecuteParam.getSystemId());
            QueryIndexInfo<Long, ReportData> reportDataQueryIndexInfo = QueryIndexInfoMapGenerator.buildReportDataIndex(matchedReportDataList, system);
            balanceQueryDetailInfo.setQueryIndexInfo(reportDataQueryIndexInfo);
        }
        return balanceQueryDetailInfoList;
    }
}

