/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.dataproc.openapi.balancequery.generator.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.exception.KDBizException;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.index.BitMap;
import kd.tmc.fpm.business.utils.ListHelper;

public class DimensionInfoCacheManager {
    private BitMap<Object, Dimension> dimensionBitMap = new BitMap(16);
    private Map<Long, DimMember> dimMemberMap = new HashMap<Long, DimMember>(64);

    public Dimension getDimension(FundPlanSystem system, DimensionType dimensionType) {
        if (dimensionType.isCustomDim()) {
            throw new KDBizException("custom dimension should not call this method.");
        }
        Set<Object> keys = ListHelper.asSet(new Object[]{system.getId(), dimensionType});
        Dimension dimension = this.dimensionBitMap.findOne(keys);
        if (dimension != null) {
            return dimension;
        }
        dimension = system.getMainDimensionByDimType(dimensionType);
        if (dimension == null) {
            throw new KDBizException("system:" + system.getName() + " dimensionType:" + dimensionType.getNumber() + "is not exists.");
        }
        this.dimensionBitMap.addValue(keys, dimension);
        return dimension;
    }

    public DimMember getDimMember(Dimension dimension, Long memberId) {
        DimMember dimMember = this.dimMemberMap.get(memberId);
        if (Objects.nonNull(dimMember)) {
            return dimMember;
        }
        List<DimMember> allDimMemberList = dimension.getAllDimMemberList();
        for (DimMember member : allDimMemberList) {
            this.dimMemberMap.putIfAbsent(member.getId(), member);
        }
        dimMember = this.dimMemberMap.get(memberId);
        if (Objects.isNull(dimMember)) {
            throw new KDBizException("system:" + dimension.getSystemId() + ",dimension" + dimension.getName() + " memberId:" + memberId + "is not exists");
        }
        return dimMember;
    }

    public Dimension getDimension(FundPlanSystem system, Long dimensionId) {
        Set<Object> keys = ListHelper.asSet(system.getId(), dimensionId);
        Dimension dimension = this.dimensionBitMap.findOne(keys);
        if (dimension != null) {
            return dimension;
        }
        dimension = system.getMainDimensionByDimensionId(dimensionId);
        if (dimension == null) {
            throw new KDBizException("system:" + system.getName() + " dimensionId:" + dimensionId + "is not exists.");
        }
        this.dimensionBitMap.addValue(keys, dimension);
        return dimension;
    }
}

