/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.dataproc.openapi.balancequery.generator.impl;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.tmc.fpm.business.dataproc.openapi.balancequery.generator.impl.AbstractBalanceQueryResultGenerator;
import kd.tmc.fpm.business.dataproc.openapi.model.BalanceQueryDetailInfo;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.index.BitMap;
import kd.tmc.fpm.business.domain.model.index.generate.bean.QueryIndexInfo;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.mvc.service.params.ControlExecuteParam;
import kd.tmc.fpm.business.utils.DimensionInfoHelper;
import kd.tmc.fpm.common.bean.DimensionInfoBean;

public class NoControlStrategyAccurateBalanceQueryResultGenerator
extends AbstractBalanceQueryResultGenerator {
    public NoControlStrategyAccurateBalanceQueryResultGenerator(AbstractBalanceQueryResultGenerator abstractBalanceQueryResultGenerator) {
        super(abstractBalanceQueryResultGenerator);
    }

    @Override
    public List<BalanceQueryDetailInfo> generate() {
        List<BalanceQueryDetailInfo> balanceQueryDetailInfoList = super.generate();
        if (!this.isAccurate()) {
            for (BalanceQueryDetailInfo balanceQueryDetailInfo : balanceQueryDetailInfoList) {
                if (balanceQueryDetailInfo.hasControlStrategy()) continue;
                FundPlanSystem system = this.controlContext.getSystem(balanceQueryDetailInfo.getSystemId());
                Dimension periodDim = this.dimensionInfoCacheManager.getDimension(system, DimensionType.PERIOD);
                DimensionInfoBean dimensionInfoBean = balanceQueryDetailInfo.getDimensionInfoBean();
                dimensionInfoBean.replaceValueIfContains(periodDim.getId(), (Object)balanceQueryDetailInfo.getReportPeriodId());
                QueryIndexInfo<Long, ReportData> queryIndexInfo = balanceQueryDetailInfo.getQueryIndexInfo();
                List<ReportData> reportDataList = queryIndexInfo.findList(dimensionInfoBean);
                this.check(balanceQueryDetailInfo, dimensionInfoBean, reportDataList);
                balanceQueryDetailInfo.setControlDimensionInfoBean(dimensionInfoBean.copy());
                this.addReportDataListAndUpdateAvailableAmt(balanceQueryDetailInfo, this.mainReportData(reportDataList));
            }
            return balanceQueryDetailInfoList;
        }
        for (BalanceQueryDetailInfo balanceQueryDetailInfo : balanceQueryDetailInfoList) {
            if (balanceQueryDetailInfo.hasControlStrategy()) continue;
            DimensionInfoBean dimensionInfoBean = balanceQueryDetailInfo.getDimensionInfoBean();
            ControlExecuteParam controlExecuteParam = balanceQueryDetailInfo.getControlExecuteParam();
            if (!controlExecuteParam.matchedDetail()) {
                FundPlanSystem system = this.controlContext.getSystem(balanceQueryDetailInfo.getSystemId());
                Dimension periodDim = this.dimensionInfoCacheManager.getDimension(system, DimensionType.PERIOD);
                dimensionInfoBean.replaceValueIfContains(periodDim.getId(), (Object)balanceQueryDetailInfo.getReportPeriodId());
            }
            QueryIndexInfo<Long, ReportData> queryIndexInfo = balanceQueryDetailInfo.getQueryIndexInfo();
            List<ReportData> reportDataList = queryIndexInfo.findList(dimensionInfoBean);
            DimensionInfoBean controlDimensionInfoBean = dimensionInfoBean.copy();
            balanceQueryDetailInfo.setControlDimensionInfoBean(controlDimensionInfoBean);
            if (!controlExecuteParam.matchedDetail()) {
                this.addReportDataListAndUpdateAvailableAmt(balanceQueryDetailInfo, reportDataList);
                continue;
            }
            this.check(balanceQueryDetailInfo, dimensionInfoBean, reportDataList);
            BitMap<Long, Long> detailDimBitMap = controlExecuteParam.getDetailDimBitMap();
            ReportData reportData = reportDataList.stream().max(Comparator.comparing(rd -> detailDimBitMap.getKeys(rd.getId()).size())).get();
            Set<Long> detailDimIds = detailDimBitMap.getKeys(reportData.getId());
            ArrayList<ReportData> dataList = new ArrayList<ReportData>(16);
            boolean flag = true;
            for (ReportData rd2 : reportDataList) {
                Set<Long> keys = detailDimBitMap.getKeys(rd2.getId());
                if (keys.size() != detailDimIds.size() || !detailDimIds.containsAll(keys)) continue;
                dataList.add(rd2);
                if (!flag) continue;
                Map<Long, Object> detailDimValueMap = DimensionInfoHelper.getDetailDimValueMap(rd2, keys);
                detailDimValueMap.forEach((arg_0, arg_1) -> ((DimensionInfoBean)controlDimensionInfoBean).addDimensionInfo(arg_0, arg_1));
                flag = false;
            }
            this.addReportDataListAndUpdateAvailableAmt(balanceQueryDetailInfo, dataList);
        }
        return balanceQueryDetailInfoList;
    }
}

