/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.dataproc.openapi.balancequery.generator.impl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.tmc.fpm.business.dataproc.openapi.balancequery.generator.IAvailableAmtCalculate;
import kd.tmc.fpm.business.dataproc.openapi.model.AvailableReportData;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.utils.CommonUtils;
import kd.tmc.fpm.business.utils.MetricValueUtils;

public class ReportDataAvailableAmtCalculate
implements IAvailableAmtCalculate<AvailableReportData> {
    @Override
    public BigDecimal calculate(AvailableReportData availableReportData) {
        ReportData reportData = new ReportData(availableReportData.getReportData());
        BigDecimal planAmt = reportData.getPlanAmt();
        BigDecimal hundred = AvailableReportData.getHundred();
        BigDecimal divide = BigDecimal.ONE.divide(hundred, 2, RoundingMode.HALF_UP);
        planAmt = availableReportData.getCoefficient().multiply(planAmt).multiply(divide);
        reportData.setPlanAmt(planAmt);
        return CommonUtils.getBigDecimalValue(MetricValueUtils.evalMetricValue(availableReportData.getFormula(), reportData));
    }
}

