/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.dataproc.openapi.model;

import java.math.BigDecimal;
import kd.tmc.fpm.business.dataproc.openapi.model.BalanceQueryDetailInfo;
import kd.tmc.fpm.common.bean.DimensionInfoBean;
import kd.tmc.fpm.common.utils.NumberUtils;

public class AvailableInfo {
    private DimensionInfoBean dimensionInfoBean;
    private Long entryId;
    private BigDecimal remainAvailableAmt;
    private BigDecimal minAvailableAmt;

    public AvailableInfo(DimensionInfoBean dimensionInfoBean, Long entryId, BigDecimal availableAmt) {
        this.dimensionInfoBean = dimensionInfoBean;
        this.entryId = entryId;
        this.remainAvailableAmt = availableAmt;
        this.minAvailableAmt = availableAmt;
    }

    public DimensionInfoBean getDimensionInfoBean() {
        return this.dimensionInfoBean;
    }

    public void setDimensionInfoBean(DimensionInfoBean dimensionInfoBean) {
        this.dimensionInfoBean = dimensionInfoBean;
    }

    public Long getEntryId() {
        return this.entryId;
    }

    public void setEntryId(Long entryId) {
        this.entryId = entryId;
    }

    public BigDecimal getRemainAvailableAmt() {
        return this.remainAvailableAmt;
    }

    public void setRemainAvailableAmt(BigDecimal remainAvailableAmt) {
        this.remainAvailableAmt = remainAvailableAmt;
    }

    public void updateRemainAvailableAmt(BigDecimal bigDecimal) {
        this.remainAvailableAmt = this.remainAvailableAmt.add(bigDecimal);
    }

    public void updateMinAvailableAmt(BalanceQueryDetailInfo balanceQueryDetailInfo) {
        BigDecimal availableAmt = balanceQueryDetailInfo.getAvailableAmt();
        if (NumberUtils.lessThan((BigDecimal)availableAmt, (BigDecimal)this.minAvailableAmt)) {
            this.remainAvailableAmt = this.minAvailableAmt = availableAmt;
            this.dimensionInfoBean = balanceQueryDetailInfo.getControlDimensionInfoBean();
        }
    }

    public boolean isOverage(BigDecimal bigDecimal) {
        return NumberUtils.lessThan((BigDecimal)this.remainAvailableAmt, (BigDecimal)bigDecimal);
    }
}

