/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.dataproc.query.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.dataproc.openapi.balancequery.factory.BalanceQueryResultGeneratorFactory;
import kd.tmc.fpm.business.dataproc.openapi.balancequery.generator.IBalanceQueryResultGenerator;
import kd.tmc.fpm.business.dataproc.openapi.balancequery.generator.impl.BalanceResultConverter;
import kd.tmc.fpm.business.dataproc.openapi.model.BalanceQueryDetailInfo;
import kd.tmc.fpm.business.dataproc.openapi.model.BalanceQueryParam;
import kd.tmc.fpm.business.dataproc.openapi.model.BalanceQueryParamCheckResult;
import kd.tmc.fpm.business.dataproc.openapi.model.BalanceQueryResult;
import kd.tmc.fpm.business.dataproc.query.IBalanceQueryService;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.PlanExecuteOpType;
import kd.tmc.fpm.business.domain.model.control.BillMatchRule;
import kd.tmc.fpm.business.domain.model.control.ControlAmountCache;
import kd.tmc.fpm.business.domain.model.control.ControlStrategy;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.mvc.converter.utils.ConverterUtils;
import kd.tmc.fpm.business.mvc.repository.impl.ControlRepository;
import kd.tmc.fpm.business.mvc.service.IControlExecuteParamPostProcessor;
import kd.tmc.fpm.business.mvc.service.context.ControlContext;
import kd.tmc.fpm.business.mvc.service.dto.ControlExcuteServiceLogParamDTO;
import kd.tmc.fpm.business.mvc.service.impl.AbstractControlExecuteStrategy;
import kd.tmc.fpm.business.mvc.service.impl.AvailableAmtReportOrgPostProcessor;
import kd.tmc.fpm.business.mvc.service.impl.ControlContextFillBackPostProcessor;
import kd.tmc.fpm.business.mvc.service.impl.ControlExecuteParamPostProcessorImpl;
import kd.tmc.fpm.business.mvc.service.impl.MatchFieldRelateMergeKeyPostProcessor;
import kd.tmc.fpm.business.mvc.service.impl.NewMatchInfoBackFillControlExecuteStrategy;
import kd.tmc.fpm.business.mvc.service.impl.ReportOrgEnableDatePostProcessor;
import kd.tmc.fpm.business.mvc.service.impl.SubjectCheckPostProcessorImpl;
import kd.tmc.fpm.business.mvc.service.match.factory.ControlMatchServiceFactory;
import kd.tmc.fpm.business.mvc.service.params.ControlExecuteParam;
import kd.tmc.fpm.business.service.rpc.helper.GenerateControlExecLogParamHelper;
import kd.tmc.fpm.business.utils.CommonUtils;
import kd.tmc.fpm.business.utils.ListHelper;
import kd.tmc.fpm.common.helper.StringHelper;

public class BalanceQueryServiceImpl
implements IBalanceQueryService {
    private static final Log logger = LogFactory.getLog(BalanceQueryServiceImpl.class);
    private ControlRepository controlRepository = new ControlRepository();

    @Override
    public FpmOperateResult<List<BalanceQueryResult>> queryAvailableBalance(BalanceQueryParam balanceQueryParam) {
        try {
            BalanceQueryParamCheckResult balanceQueryParamCheckResult = this.check(balanceQueryParam);
            if (balanceQueryParamCheckResult.isFailed()) {
                return FpmOperateResult.error(balanceQueryParamCheckResult.getMessage());
            }
            ControlContext controlContext = this.getControlContext();
            controlContext.addControlExecuteParamPostProcessor(new AvailableAmtReportOrgPostProcessor(balanceQueryParamCheckResult.getSystemReportOrgMap(), balanceQueryParam.getReportOrgNumber()));
            this.fillControlExecuteParamList(balanceQueryParamCheckResult, controlContext);
            this.match(controlContext, balanceQueryParamCheckResult);
            List<ControlExecuteParam> controlExecuteParamList = controlContext.getControlExecuteParamList();
            if (EmptyUtil.isEmpty(controlExecuteParamList)) {
                List<ControlExecuteParam> failedControlExecuteParamList = controlContext.getFailedControlExecuteParamList();
                if (EmptyUtil.isEmpty(failedControlExecuteParamList)) {
                    return FpmOperateResult.error(ResManager.loadKDString((String)"\u67e5\u4e0d\u5230\u6709\u6548\u7684\u8d44\u91d1\u8ba1\u5212\u8bb0\u5f55\uff0c\u8bf7\u68c0\u67e5\u76f8\u5173\u914d\u7f6e\uff0c\u4f8b\u5982\u201c\u7f16\u62a5\u4e3b\u4f53\u53ef\u7528\u72b6\u6001\u53ca\u751f\u6548\u65e5\u671f\u3001\u4e1a\u52a1\u53d6\u6570\u89c4\u5219\u914d\u7f6e\u3001\u4e1a\u52a1\u5355\u636e\u65e5\u671f\u4e3a\u7a7a\u201d\u7b49\u3002", (String)"BalanceQueryServiceImpl_0", (String)"tmc-fpm-business", (Object[])new Object[0]));
                }
                return FpmOperateResult.error(failedControlExecuteParamList.stream().map(ControlExecuteParam::getFailedCause).distinct().collect(Collectors.joining("\r\n")));
            }
            List<ControlExecuteParam> failedControlExecuteParamList = controlContext.getFailedControlExecuteParamList();
            if (EmptyUtil.isNoEmpty(failedControlExecuteParamList)) {
                logger.warn("\u5931\u8d25\u539f\u56e0\uff1a{}\uff0c\u53c2\u6570\uff1a{}", (Object)failedControlExecuteParamList.stream().map(ControlExecuteParam::getFailedCause).collect(Collectors.joining("\r\n")), controlExecuteParamList);
            }
            IBalanceQueryResultGenerator balanceQueryResultGenerator = BalanceQueryResultGeneratorFactory.getBalanceQueryResultGenerator(controlContext, balanceQueryParam.isAccurate());
            List<BalanceQueryDetailInfo> balanceQueryDetailInfoList = balanceQueryResultGenerator.generate();
            BalanceResultConverter balanceResultConverter = new BalanceResultConverter(controlContext);
            return FpmOperateResult.success(balanceResultConverter.convert(balanceQueryDetailInfoList));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return FpmOperateResult.error(e.getMessage());
        }
    }

    private BalanceQueryParamCheckResult check(BalanceQueryParam balanceQueryParam) {
        String reportOrgNumber;
        String reportTypeNumber;
        String entityName;
        BalanceQueryParamCheckResult balanceQueryParamCheckResult = new BalanceQueryParamCheckResult(balanceQueryParam.isAccurate());
        String bizObjectNo = balanceQueryParam.getBizObjectNo();
        if (EmptyUtil.isEmpty((String)bizObjectNo)) {
            balanceQueryParamCheckResult.setMessage(ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61.\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BalanceQueryServiceImpl_1", (String)"tmc-fpm-business", (Object[])new Object[0]));
            return balanceQueryParamCheckResult;
        }
        try {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)bizObjectNo);
            entityName = dataEntityType.getDisplayName().getLocaleValue();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            balanceQueryParamCheckResult.setMessage(e.getMessage());
            return balanceQueryParamCheckResult;
        }
        String bizBillNo = balanceQueryParam.getBizBillNo();
        if (EmptyUtil.isEmpty((String)bizBillNo)) {
            balanceQueryParamCheckResult.setMessage(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BalanceQueryServiceImpl_2", (String)"tmc-fpm-business", (Object[])new Object[0]));
            return balanceQueryParamCheckResult;
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)bizObjectNo, (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)bizBillNo)});
        if (Objects.isNull(dynamicObject)) {
            String message = String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u4e0d\u5b58\u5728\u4e1a\u52a1\u5355\u636e\u7f16\u7801\u4e3a\u3010%2$s\u3011\u7684\u4e1a\u52a1\u5355\u636e\u3002", (String)"BalanceQueryServiceImpl_3", (String)"tmc-fpm-business", (Object[])new Object[0]), entityName, bizBillNo);
            balanceQueryParamCheckResult.setMessage(message);
            return balanceQueryParamCheckResult;
        }
        balanceQueryParamCheckResult.setDynamicObject(dynamicObject);
        Function<Set, QFilter> numberFun = number -> new QFilter("number", "in", number).and(new QFilter("enable", "=", (Object)"1"));
        String bodySysNumber = balanceQueryParam.getBodySysNumber();
        if (EmptyUtil.isNoEmpty((String)bodySysNumber)) {
            String[] bodySystemNumbers = StringHelper.split((String)bodySysNumber, (String[])new String[]{",", ";", "_", "#", " ", "%"});
            List list = QueryServiceHelper.queryPrimaryKeys((String)"fpm_bodysysmanage", (QFilter[])new QFilter[]{numberFun.apply(ListHelper.asSet(bodySystemNumbers))}, null, (int)-1);
            if (EmptyUtil.isEmpty((Collection)list)) {
                String message = String.format(ResManager.loadKDString((String)"\u6309\u7f16\u7801\u3010%1$s\u3011\u65e0\u6cd5\u5339\u914d\u5230\u7cfb\u7edf\u4e2d\u53ef\u7528\u72b6\u6001\u7684\u4f53\u7cfb\u3002", (String)"BalanceQueryServiceImpl_4", (String)"tmc-fpm-business", (Object[])new Object[0]), bodySysNumber);
                balanceQueryParamCheckResult.setMessage(message);
                return balanceQueryParamCheckResult;
            }
            balanceQueryParamCheckResult.setSystemIds(list.stream().map(Long.class::cast).collect(Collectors.toSet()));
        }
        if (EmptyUtil.isNoEmpty((String)(reportTypeNumber = balanceQueryParam.getReportTypeNumber()))) {
            String[] reportTypeNumbers = StringHelper.split((String)reportTypeNumber, (String[])new String[]{",", ";", "_", "#", " ", "%"});
            List list = QueryServiceHelper.queryPrimaryKeys((String)"fpm_orgreporttype", (QFilter[])new QFilter[]{numberFun.apply(ListHelper.asSet(reportTypeNumbers))}, null, (int)-1);
            if (EmptyUtil.isEmpty((Collection)list)) {
                String message = String.format(ResManager.loadKDString((String)"\u6309\u7f16\u7801\u3010%1$s\u3011\u65e0\u6cd5\u5339\u914d\u5230\u7cfb\u7edf\u4e2d\u53ef\u7528\u7684\u7f16\u62a5\u7c7b\u578b\u3002", (String)"BalanceQueryServiceImpl_5", (String)"tmc-fpm-business", (Object[])new Object[0]), reportTypeNumber);
                balanceQueryParamCheckResult.setMessage(message);
                return balanceQueryParamCheckResult;
            }
            balanceQueryParamCheckResult.setReportTypeIds(list.stream().map(Long.class::cast).collect(Collectors.toSet()));
        }
        if (EmptyUtil.isNoEmpty((String)(reportOrgNumber = balanceQueryParam.getReportOrgNumber()))) {
            DynamicObjectCollection dynamicObjects;
            String selectFields = String.join((CharSequence)",", "bodysystem", "id");
            QFilter qFilter = numberFun.apply(ListHelper.asSet(reportOrgNumber)).and(new QFilter("dimtype", "=", (Object)DimensionType.ORG.getNumber()));
            if (EmptyUtil.isNoEmpty(balanceQueryParamCheckResult.getSystemIds())) {
                qFilter = qFilter.and(new QFilter("bodysystem", "in", balanceQueryParamCheckResult.getSystemIds()));
            }
            if (EmptyUtil.isEmpty((DynamicObjectCollection)(dynamicObjects = QueryServiceHelper.query((String)"fpm_member", (String)selectFields, (QFilter[])new QFilter[]{qFilter})))) {
                String message = String.format(ResManager.loadKDString((String)"\u6309\u7f16\u62a5\u4e3b\u4f53\u7f16\u7801\u3010%1$s\u3011\u5728\u7cfb\u7edf\u4e2d\u5339\u914d\u4e0d\u5230\u6709\u6548\u7684\u4f53\u7cfb\u4fe1\u606f\u3002", (String)"BalanceQueryServiceImpl_7", (String)"tmc-fpm-business", (Object[])new Object[0]), reportOrgNumber);
                balanceQueryParamCheckResult.setMessage(message);
                return balanceQueryParamCheckResult;
            }
            Map<Long, Long> systemReportOrgMap = balanceQueryParamCheckResult.getSystemReportOrgMap();
            for (DynamicObject dy : dynamicObjects) {
                systemReportOrgMap.put(dy.getLong("bodysystem"), dy.getLong("id"));
            }
        }
        return balanceQueryParamCheckResult;
    }

    private void match(ControlContext controlContext, BalanceQueryParamCheckResult balanceQueryParamCheckResult) {
        List<ControlExecuteParam> controlExecuteParamList = controlContext.getControlExecuteParamList();
        if (EmptyUtil.isEmpty(controlExecuteParamList)) {
            return;
        }
        controlExecuteParamList.sort(Comparator.comparing(ControlExecuteParam::getActAmount));
        Set<Long> reportTypeIds = balanceQueryParamCheckResult.getReportTypeIds();
        NewMatchInfoBackFillControlExecuteStrategy newMatchInfoBackFillControlExecuteStrategy = new NewMatchInfoBackFillControlExecuteStrategy(new AbstractControlExecuteStrategy(controlContext){}, ControlMatchServiceFactory.getAvailableAmtReportTypeFilterControlMatchService(controlContext, reportTypeIds.toArray(new Long[0])));
        newMatchInfoBackFillControlExecuteStrategy.beforeDoControl();
        newMatchInfoBackFillControlExecuteStrategy.validate();
    }

    private void fillControlExecuteParamList(BalanceQueryParamCheckResult balanceQueryParamCheckResult, ControlContext controlContext) {
        List<BillMatchRule> billMatchRuleList = this.getMatchRule(balanceQueryParamCheckResult);
        DynamicObject[] bills = new DynamicObject[]{balanceQueryParamCheckResult.getDynamicObject()};
        List<ControlExcuteServiceLogParamDTO> paramDTOList = GenerateControlExecLogParamHelper.generatePlanExecuteRecordParamsOfWrite(bills, controlContext, billMatchRuleList);
        List<ControlExecuteParam> controlExecuteParams = ConverterUtils.convertList(ControlExecuteParam.class, paramDTOList);
        List<IControlExecuteParamPostProcessor> controlExecuteParamPostProcessorList = controlContext.getControlExecuteParamPostProcessorList();
        controlExecuteParamPostProcessorList.sort(Comparator.comparing(IControlExecuteParamPostProcessor::getOrder));
        controlExecuteParamPostProcessorList.forEach(p -> p.postProcess(controlContext, controlExecuteParams));
        Set<Long> systemIds = controlExecuteParams.stream().map(ControlExecuteParam::getMatchRule).map(BillMatchRule::getSystemId).collect(Collectors.toSet());
        if (EmptyUtil.isEmpty(systemIds)) {
            return;
        }
        List<ControlStrategy> controlStrategies = this.controlRepository.loadStrategy(systemIds, true);
        controlContext.addControlStrategy(controlStrategies);
        controlContext.setControlExecuteParamList(controlExecuteParams);
    }

    private ControlContext getControlContext() {
        ControlContext controlContext = new ControlContext();
        controlContext.setPlanExecuteOpType(PlanExecuteOpType.WRITE);
        controlContext.addControlExecuteParamPostProcessor(new ControlExecuteParamPostProcessorImpl());
        controlContext.addControlExecuteParamPostProcessor(new ControlContextFillBackPostProcessor());
        controlContext.addControlExecuteParamPostProcessor(new ReportOrgEnableDatePostProcessor());
        controlContext.addControlExecuteParamPostProcessor(new SubjectCheckPostProcessorImpl());
        controlContext.addControlExecuteParamPostProcessor(new MatchFieldRelateMergeKeyPostProcessor());
        controlContext.setControlAmountCache(new ControlAmountCache());
        controlContext.setCheckDetailControl(true);
        return controlContext;
    }

    private List<BillMatchRule> getMatchRule(BalanceQueryParamCheckResult balanceQueryParamCheckResult) {
        Set<Long> systemIds = balanceQueryParamCheckResult.getSystemIds();
        String bizObjectNo = balanceQueryParamCheckResult.getBizObjectNo();
        if (EmptyUtil.isEmpty(systemIds)) {
            return CommonUtils.getValueOrDefault(this.controlRepository.loadControlMatchRule(bizObjectNo), Collections.emptyList());
        }
        return this.controlRepository.loadControlMatchRule(bizObjectNo, systemIds.toArray(new Long[0]));
    }
}

