/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.dataproc.save.domain;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;

public class DataSaveResult {
    private Set<Long> saveIds = new HashSet<Long>(256);
    private Set<Long> updateIds = new HashSet<Long>(256);
    private Set<Long> deleteIds = new HashSet<Long>(256);
    private Map<Long, List<Long>> sourceIdAndIdMap;
    private List<DynamicObject> deleteMainDataList = new LinkedList<DynamicObject>();
    private List<DynamicObject> saveMainDataList = new LinkedList<DynamicObject>();

    public DataSaveResult() {
        this.sourceIdAndIdMap = new HashMap<Long, List<Long>>(32);
    }

    public void addSaveId(Long saveId) {
        this.saveIds.add(saveId);
    }

    public void addUpdateId(Long updateId) {
        this.updateIds.add(updateId);
    }

    public void addDeleteId(Long deleteId) {
        this.deleteIds.add(deleteId);
    }

    public void addDeleteMainDataList(List<DynamicObject> deleteMainDataList) {
        this.deleteMainDataList.addAll(deleteMainDataList);
    }

    public void addSaveMainData(DynamicObject saveMainData) {
        this.saveMainDataList.add(saveMainData);
    }

    public void addSourceIdAndIdMapping(Long sourceId, Long id) {
        List reportDataIdList = this.sourceIdAndIdMap.computeIfAbsent(sourceId, key -> new ArrayList(1));
        reportDataIdList.add(id);
    }

    public Map<Long, List<Long>> getSourceIdAndIdMap() {
        return this.sourceIdAndIdMap;
    }

    public Set<Long> getSaveIds() {
        return this.saveIds;
    }

    public Set<Long> getUpdateIds() {
        return this.updateIds;
    }

    public Set<Long> getDeleteIds() {
        return this.deleteIds;
    }

    public List<DynamicObject> getDeleteMainDataList() {
        return this.deleteMainDataList;
    }

    public List<DynamicObject> getSaveMainDataList() {
        return this.saveMainDataList;
    }

    public boolean containsUpdateId(Long dataId) {
        return this.updateIds.contains(dataId);
    }

    public boolean containsDeleteId(Long dataId) {
        return this.deleteIds.contains(dataId);
    }

    public boolean containsSaveId(Long dataId) {
        return this.saveIds.contains(dataId);
    }
}

