/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.dataproc.save.domain;

import java.io.Serializable;
import kd.tmc.fpm.business.domain.enums.FpmErrorCodeEnum;

public class FpmResponse<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String code;
    private String message;
    private T data;

    public FpmResponse(String code, String message, T data) {
        this.code = code;
        this.message = message;
        this.data = data;
    }

    public static <T> FpmResponse<T> success(T data) {
        return new FpmResponse<T>("00000", null, data);
    }

    public static <T> FpmResponse<T> error(String code, String errorMessage) {
        return new FpmResponse<Object>(code, errorMessage, null);
    }

    public static <T> FpmResponse<T> error(String code, String errorMessage, Object ... args) {
        if (args != null && args.length > 0) {
            return new FpmResponse<Object>(code, String.format(errorMessage, args), null);
        }
        return new FpmResponse<Object>(code, errorMessage, null);
    }

    public static <T> FpmResponse<T> error(FpmErrorCodeEnum responseCodeEnum) {
        return new FpmResponse<Object>(responseCodeEnum.getCode(), responseCodeEnum.getMessage(), null);
    }

    public static <T> FpmResponse<T> build(FpmErrorCodeEnum responseCodeEnum, T data) {
        return new FpmResponse<T>(responseCodeEnum.getCode(), responseCodeEnum.getMessage(), data);
    }

    public boolean isSuccess() {
        return FpmErrorCodeEnum.SUCCESS.getCode().equals(this.code);
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }
}

