/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.dataproc.save.impl;

import java.util.List;
import java.util.Set;
import kd.bos.db.tx.CommitListener;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;
import kd.tmc.fpm.common.helper.FpmGlobalConfigHelper;
import kd.tmc.fpm.olap.command.ShrekCommand;
import kd.tmc.fpm.olap.command.ShrekSyncReportDataCommand;
import kd.tmc.fpm.olap.command.executor.ShrekExecutor;
import kd.tmc.fpm.olap.enums.ShrekSyncStatus;
import kd.tmc.fpm.olap.enums.SyncLogType;
import kd.tmc.fpm.olap.model.ShrekSyncLog;
import kd.tmc.fpm.olap.service.log.SyncLogSaveService;

public class AbstractShrekSyncService {
    protected SyncLogSaveService syncLogSaveService = FpmServiceFactory.getBizService(SyncLogSaveService.class);
    protected static final Log logger = LogFactory.getLog(AbstractShrekSyncService.class);

    protected void addSyncDataListener(final Long systemId) {
        TX.addCommitListener((CommitListener)new CommitListener(){

            public void onCommitted() {
                try (TXHandle tx = TX.requiresNew();){
                    ShrekSyncReportDataCommand syncReportDataCommand = new ShrekSyncReportDataCommand();
                    syncReportDataCommand.setSystemId(systemId);
                    ShrekExecutor.execute((ShrekCommand)syncReportDataCommand);
                }
            }
        });
    }

    public void setSyncLog(Long systemId, Set<Long> ids, List<ShrekSyncLog> logList, SyncLogType logType) {
        for (Long id : ids) {
            ShrekSyncLog log = new ShrekSyncLog();
            log.setSystemId(systemId);
            log.setEntityId(id);
            log.setEntityName("fpm_report");
            log.setLogType(logType);
            log.setSyncStatus(ShrekSyncStatus.WAIT_SYNC);
            logList.add(log);
        }
    }

    public boolean isOpen() {
        return FpmGlobalConfigHelper.getBooleanConfigByKey((String)"startmutilsync");
    }
}

