/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.dataproc.save.impl;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.KDDateUtils;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.dataproc.exception.UpdateException;
import kd.tmc.fpm.business.dataproc.save.IDataSaveService;
import kd.tmc.fpm.business.dataproc.save.domain.SqlEntity;
import kd.tmc.fpm.business.dataproc.save.domain.UpdateResult;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.mvc.converter.utils.ConverterUtils;
import kd.tmc.fpm.business.mvc.service.DataParamFillBack;
import kd.tmc.fpm.business.utils.CommonUtils;
import org.apache.commons.compress.utils.Lists;

public class DataSaveServiceImpl
implements IDataSaveService {
    private static Log logger = LogFactory.getLog(DataSaveServiceImpl.class);
    public static final int BATCH_EXECUTE_SIZE = 1000;
    private int batchSize = 1000;

    @Override
    public <T, P> FpmOperateResult<Void> saveEntryData(List<T> dataList, P pk) {
        return this.saveEntryData(DBRouteConst.TMC, dataList, pk, false);
    }

    @Override
    public <T, P> FpmOperateResult<Void> saveEntryDataThrow(List<T> dataList, P pkValue) {
        return this.saveEntryData(DBRouteConst.TMC, dataList, pkValue, true);
    }

    @Override
    public <T, P> FpmOperateResult<Void> saveEntryData(DBRoute dbRoute, List<T> dataList, P pkValue, boolean throwException) {
        if (EmptyUtil.isEmpty(dataList)) {
            return FpmOperateResult.success();
        }
        try {
            List<DynamicObject> dynamicObjectList = ConverterUtils.convertList(DynamicObject.class, dataList);
            if (EmptyUtil.isEmpty(dynamicObjectList)) {
                return FpmOperateResult.success();
            }
            DynamicObject dynamicObject = dynamicObjectList.get(0);
            IDataEntityType dataEntityType = dynamicObject.getDataEntityType();
            List<IDataEntityProperty> properties = dataEntityType.getProperties().stream().filter(p -> !p.isDbIgnore()).filter(p -> EmptyUtil.isNoEmpty((String)p.getAlias())).collect(Collectors.toList());
            if (EmptyUtil.isEmpty(properties)) {
                return FpmOperateResult.success();
            }
            StringBuilder sql = new StringBuilder();
            sql.append("insert into ").append(dataEntityType.getAlias());
            if (EmptyUtil.isNoEmpty(pkValue)) {
                sql.append(" (fid");
            }
            StringBuilder placeHolder = new StringBuilder();
            placeHolder.append("?");
            for (int i = 0; i < properties.size(); ++i) {
                sql.append(",").append(((IDataEntityProperty)properties.get(i)).getAlias());
                placeHolder.append(",?");
            }
            sql.append(") VALUES ( ").append((CharSequence)placeHolder).append(")");
            String realSql = sql.toString();
            int index = 0;
            while (index + this.batchSize <= dynamicObjectList.size()) {
                List<DynamicObject> subList = dynamicObjectList.subList(index, index + this.batchSize);
                this.save(dbRoute, subList, realSql, properties, pkValue);
                index += this.batchSize;
            }
            if (index < dynamicObjectList.size()) {
                this.save(dbRoute, dynamicObjectList.subList(index, dynamicObjectList.size()), realSql, properties, pkValue);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            if (throwException) {
                throw e;
            }
            return FpmOperateResult.error(e.getMessage());
        }
        return FpmOperateResult.success();
    }

    @Override
    public <T> FpmOperateResult<Void> saveEntity(T entity) {
        if (Objects.isNull(entity)) {
            return FpmOperateResult.success();
        }
        return this.saveEntityList(Collections.singletonList(entity));
    }

    @Override
    public <T> FpmOperateResult<Void> saveEntityList(List<T> dataList) {
        return this.saveEntityList(DBRouteConst.TMC, dataList);
    }

    @Override
    public <T> FpmOperateResult<Void> saveEntityList(DBRoute dbRoute, List<T> dataList) {
        if (EmptyUtil.isEmpty(dataList)) {
            return FpmOperateResult.success();
        }
        return this.saveEntryData(dbRoute, dataList, null, true);
    }

    public <P> void save(DBRoute dbRoute, List<DynamicObject> dynamicObjectList, String realSql, List<IDataEntityProperty> properties, P pk) {
        if (EmptyUtil.isEmpty(dynamicObjectList)) {
            return;
        }
        logger.info("sql:{}", (Object)realSql);
        ArrayList<Object[]> params = new ArrayList<Object[]>(dynamicObjectList.size());
        int size = EmptyUtil.isEmpty(pk) ? properties.size() : properties.size() + 1;
        for (DynamicObject dy : dynamicObjectList) {
            Object[] param = new Object[size];
            int j = 0;
            if (EmptyUtil.isNoEmpty(pk)) {
                param[j] = pk;
                ++j;
            }
            for (int i = 0; i < properties.size(); ++i) {
                IDataEntityProperty property = properties.get(i);
                String propertyName = property.getName();
                param[j] = this.formatValueIfNeed(property, dy.get(propertyName));
                ++j;
            }
            params.add(param);
        }
        DB.executeBatch((DBRoute)dbRoute, (String)realSql, params);
    }

    private Object formatValueIfNeed(IDataEntityProperty property, Object val) {
        Object value = this.fillNull(property, val);
        if (value instanceof Date) {
            return new Timestamp(((Date)value).getTime());
        }
        return value;
    }

    @Override
    public <T, P> FpmOperateResult<Void> saveEntryDataInTransaction(List<T> dataList, P pk) {
        return this.saveEntryDataInTransaction(DBRouteConst.TMC, dataList, pk);
    }

    @Override
    public <T, P> FpmOperateResult<Void> saveEntryDataInTransaction(DBRoute dbRoute, List<T> dataList, P pkValue) {
        Throwable throwable = null;
        try (TXHandle tx = TX.requiresNew();){
            FpmOperateResult<Void> fpmOperateResult = this.saveEntryData(dataList, pkValue);
            return fpmOperateResult;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            tx.markRollback();
            FpmOperateResult<Void> fpmOperateResult = FpmOperateResult.error(e.getMessage());
            return fpmOperateResult;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
    }

    @Override
    public <T> FpmOperateResult<UpdateResult> updateEntity(T entity, Consumer<Set<String>> propConsumer) {
        if (EmptyUtil.isEmpty(entity)) {
            return FpmOperateResult.success();
        }
        return this.updateEntityList(Collections.singletonList(entity), propConsumer);
    }

    @Override
    public <T> FpmOperateResult<UpdateResult> updateEntityList(List<T> entity, Consumer<Set<String>> propConsumer) {
        return this.updateEntityList(DBRouteConst.TMC, entity, propConsumer);
    }

    @Override
    public <T> FpmOperateResult<UpdateResult> updateEntityList(DBRoute dbRoute, List<T> entity, Consumer<Set<String>> propConsumer) {
        if (EmptyUtil.isEmpty(entity)) {
            return FpmOperateResult.success();
        }
        List<DynamicObject> dynamicObjectList = ConverterUtils.convertList(DynamicObject.class, entity);
        if (EmptyUtil.isEmpty(dynamicObjectList)) {
            return FpmOperateResult.success();
        }
        if (Objects.isNull(propConsumer)) {
            throw new KDBizException("update prop Consumer must not null");
        }
        HashSet needUpdateProps = new HashSet(10);
        propConsumer.accept(needUpdateProps);
        Predicate<IDataEntityProperty> filter = prop -> EmptyUtil.isEmpty((Collection)needUpdateProps) || needUpdateProps.contains(prop.getName());
        DynamicObject dynamicObject = dynamicObjectList.get(0);
        IDataEntityType dataEntityType = dynamicObject.getDataEntityType();
        Map propertiesMap = dataEntityType.getProperties().stream().filter(p -> !p.isDbIgnore()).filter(p -> EmptyUtil.isNoEmpty((String)p.getAlias())).filter(filter::test).collect(Collectors.toMap(IMetadata::getName, Function.identity()));
        if (propertiesMap.size() != needUpdateProps.size()) {
            throw new KDBizException("please confirm input update props is mapped database.");
        }
        StringBuilder sql = new StringBuilder();
        sql.append("update ").append(dataEntityType.getAlias()).append(" set ");
        ArrayList<IDataEntityProperty> properties = new ArrayList<IDataEntityProperty>(needUpdateProps.size());
        for (String prop2 : needUpdateProps) {
            IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)propertiesMap.get(prop2);
            sql.append(iDataEntityProperty.getAlias()).append(" =?,");
            properties.add(iDataEntityProperty);
        }
        sql.deleteCharAt(sql.length() - 1);
        String id = dataEntityType.getProperties().stream().filter(p -> Objects.equals("id", p.getName())).findFirst().get().getAlias();
        sql.append(" where ").append(id).append(" = ?");
        String realSql = sql.toString();
        int index = 0;
        int updateResult = 0;
        UpdateResult result = new UpdateResult();
        Consumer<Integer> resultConsumer = this.getResultConsumer(result);
        while (index + this.batchSize <= dynamicObjectList.size()) {
            List<DynamicObject> subList = dynamicObjectList.subList(index, index + this.batchSize);
            int[] update = this.update(dbRoute, subList, realSql, properties);
            updateResult += this.getTotalUpdateCount(update, resultConsumer);
            index += this.batchSize;
        }
        if (index < dynamicObjectList.size()) {
            int[] update = this.update(dbRoute, dynamicObjectList.subList(index, dynamicObjectList.size()), realSql, properties);
            updateResult += this.getTotalUpdateCount(update, resultConsumer);
        }
        result.setUpdateCount(updateResult);
        return FpmOperateResult.success(result);
    }

    private int[] update(DBRoute dbRoute, List<DynamicObject> dynamicObjectList, String realSql, List<IDataEntityProperty> properties) {
        if (EmptyUtil.isEmpty(dynamicObjectList)) {
            return new int[0];
        }
        logger.info("sql:{}", (Object)realSql);
        ArrayList<Object[]> params = new ArrayList<Object[]>(dynamicObjectList.size());
        for (DynamicObject dy : dynamicObjectList) {
            Object[] param = new Object[properties.size() + 1];
            for (int i = 0; i < properties.size(); ++i) {
                IDataEntityProperty property = properties.get(i);
                String propertyName = property.getName();
                param[i] = this.formatValueIfNeed(property, dy.get(propertyName));
            }
            Object pkValue = dy.get("id");
            if (EmptyUtil.isEmpty((Object)pkValue)) {
                throw new KDBizException("update data where pkValue is null ...");
            }
            param[param.length - 1] = pkValue;
            params.add(param);
        }
        return DB.executeBatch((DBRoute)dbRoute, (String)realSql, params);
    }

    @Override
    public <T> FpmOperateResult<UpdateResult> update(SqlEntity<T> sqlEntity, DataParamFillBack<T, List<Object>> biConsumer) {
        String alias;
        String prop;
        int i;
        this.check(sqlEntity);
        String[] split = sqlEntity.getUpdateFields().split(",");
        String[] conditionSplit = sqlEntity.getConditionFields().split(",");
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)sqlEntity.getEntityName());
        String tableName = dataEntityType.getAlias();
        StringBuilder sql = new StringBuilder();
        sql.append("update ").append(tableName).append(" set ");
        int count = 0;
        for (i = 0; i < split.length; ++i) {
            prop = split[i];
            alias = dataEntityType.getProperty(prop).getAlias();
            if (EmptyUtil.isEmpty((String)alias)) continue;
            sql.append(alias).append(" =? ,");
            ++count;
        }
        sql.deleteCharAt(sql.length() - 1);
        for (i = 0; i < conditionSplit.length; ++i) {
            prop = conditionSplit[i];
            alias = dataEntityType.getProperty(prop).getAlias();
            if (EmptyUtil.isEmpty((String)alias)) continue;
            ++count;
            if (i == 0) {
                sql.append(" where ").append(alias).append("=?");
                continue;
            }
            sql.append(" and ").append(alias).append("=?");
        }
        List<T> entityList = sqlEntity.getEntityList();
        ArrayList<Object[]> execParams = new ArrayList<Object[]>(this.batchSize);
        DBRoute dbRoute = sqlEntity.getDbRoute();
        String realSql = sql.toString();
        logger.info("\u5373\u5c06\u66f4\u65b0\u7684sql\uff1a{}", (Object)realSql);
        int updateCount = 0;
        for (T t : entityList) {
            ArrayList list = new ArrayList(split.length);
            biConsumer.accept(t, list);
            if (list.size() != count) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u5230\u7684\u53c2\u6570\u4e2a\u6570\uff1a\u201c%1$s\u201d\u8ddf\u66f4\u65b0\u5b57\u6bb5\u548c\u6761\u4ef6\u5b57\u6bb5\u7684\u603b\u4e2a\u6570:\u201c%2$s\u201d\u4e0d\u4e00\u81f4", (String)"DataSaveServiceImpl_0", (String)"tmc-fpm-business", (Object[])new Object[0]), list.size(), count));
            }
            execParams.add(list.toArray());
            if (++updateCount != this.batchSize) continue;
            DB.executeBatch((DBRoute)dbRoute, (String)realSql, execParams);
            execParams.clear();
            updateCount = 0;
        }
        if (EmptyUtil.isEmpty(execParams)) {
            return FpmOperateResult.success();
        }
        DB.executeBatch((DBRoute)dbRoute, (String)realSql, execParams);
        return FpmOperateResult.success();
    }

    @Override
    public void batchExecuteSize(int size) {
        this.batchSize = size;
    }

    @Override
    public <T> FpmOperateResult<UpdateResult> update(final IDataSaveService.Constants constants, List<T> entityList, DataParamFillBack<T, List<Object>> biConsumer) {
        String sql = constants.getSql();
        if (EmptyUtil.isEmpty((String)sql)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"Constants:\u201c%1$s\u201d\u5bf9\u5e94\u7684sql\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u4fe1\u606f", (String)"DataSaveServiceImpl_1", (String)"tmc-fpm-business", (Object[])new Object[0]), new Object[]{constants}));
        }
        UpdateResult updateResult = this.updateBySqlInfo(new IDataSaveService.SqlInfo(){

            @Override
            public String getSql() {
                return constants.getSql();
            }

            @Override
            public DBRoute getDbRoute() {
                return constants.getDbRoute();
            }
        }, entityList, biConsumer);
        return FpmOperateResult.success(updateResult);
    }

    @Override
    public <T> UpdateResult updateBySqlInfo(IDataSaveService.SqlInfo sqlInfo, List<T> entityList, DataParamFillBack<T, List<Object>> biConsumer) {
        String sql = sqlInfo.getSql();
        if (EmptyUtil.isEmpty((String)sql)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u66f4\u65b0\u7684:sql\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u4fe1\u606f", (String)"DataSaveServiceImpl_2", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
        if (EmptyUtil.isEmpty(entityList)) {
            logger.info("\u4f20\u5165\u7684\u5b9e\u4f53\u5bf9\u8c61\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u4e0d\u5904\u7406...");
            return new UpdateResult();
        }
        int count = 0;
        int index = 0;
        while ((index = sql.indexOf("?", index)) != -1) {
            ++count;
            ++index;
        }
        logger.info("\u5373\u5c06\u66f4\u65b0\u7684sql\uff1a{}", (Object)sql);
        ArrayList<Object[]> execParams = new ArrayList<Object[]>(this.batchSize);
        int updateCount = 0;
        int updateResult = 0;
        UpdateResult result = new UpdateResult();
        Consumer<Integer> resultConsumer = this.getResultConsumer(result);
        for (T t : entityList) {
            ArrayList list = new ArrayList(count);
            biConsumer.accept(t, list);
            if (list.size() != count) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u5230\u7684\u53c2\u6570\u4e2a\u6570\uff1a\u201c%1$s\u201d\u8ddf\u66f4\u65b0\u5b57\u6bb5\u7684\u5360\u4f4d\u7b26\u4e2a\u6570:\u201c%2$s\u201d\u4e0d\u4e00\u81f4", (String)"DataSaveServiceImpl_4", (String)"tmc-fpm-business", (Object[])new Object[0]), list.size(), count));
            }
            execParams.add(list.toArray());
            if (++updateCount != this.batchSize) continue;
            int[] executeBatch = DB.executeBatch((DBRoute)sqlInfo.getDbRoute(), (String)sql, execParams);
            updateResult += this.getTotalUpdateCount(executeBatch, resultConsumer);
            execParams.clear();
            updateCount = 0;
        }
        if (EmptyUtil.isNoEmpty(execParams)) {
            int[] executeBatch = DB.executeBatch((DBRoute)sqlInfo.getDbRoute(), (String)sql, execParams);
            updateResult += this.getTotalUpdateCount(executeBatch, resultConsumer);
        }
        result.setUpdateCount(updateResult);
        return result;
    }

    @Override
    public <T> void updateAndCheckResult(final IDataSaveService.Constants constants, List<T> entityList, DataParamFillBack<T, List<Object>> biConsumer) {
        this.updateAndCheckResult(new IDataSaveService.SqlInfo(){

            @Override
            public String getSql() {
                return constants.getSql();
            }

            @Override
            public DBRoute getDbRoute() {
                return constants.getDbRoute();
            }
        }, entityList, biConsumer);
    }

    @Override
    public <T> void updateAndCheckResult(IDataSaveService.SqlInfo sqlInfo, List<T> entityList, DataParamFillBack<T, List<Object>> biConsumer) {
        entityList.forEach(item -> {
            ArrayList objects = Lists.newArrayList();
            biConsumer.accept(item, objects);
            int updateCount = DB.update((DBRoute)sqlInfo.getDbRoute(), (String)sqlInfo.getSql(), (Object[])objects.toArray(new Object[0]));
            if (updateCount <= 0) {
                String sb = "update SQL:" + sqlInfo.getSql() + ", param: \u3010" + objects + "\u3011,expect update count >=\u30101\u3011, actual update count :\u3010" + updateCount + "\u3011please try again later\u3002";
                throw new UpdateException(item, sqlInfo.getSql(), objects.toArray(), updateCount, sb);
            }
        });
    }

    @Override
    public <T> FpmOperateResult<UpdateResult> updateSingle(IDataSaveService.Constants constants, T entity, DataParamFillBack<T, List<Object>> biConsumer) {
        if (Objects.isNull(entity)) {
            return FpmOperateResult.success();
        }
        return this.update(constants, Collections.singletonList(entity), biConsumer);
    }

    @Override
    public <T> FpmOperateResult<UpdateResult> updateInTransaction(SqlEntity<T> sqlEntity, DataParamFillBack<T, List<Object>> biConsumer) {
        Throwable throwable = null;
        try (TXHandle tx = TX.requiresNew();){
            FpmOperateResult<UpdateResult> fpmOperateResult = this.update(sqlEntity, biConsumer);
            return fpmOperateResult;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            tx.markRollback();
            FpmOperateResult<UpdateResult> fpmOperateResult = FpmOperateResult.error(e.getMessage());
            return fpmOperateResult;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
    }

    @Override
    public <T> FpmOperateResult<UpdateResult> updateInTransaction(IDataSaveService.Constants constants, List<T> entityList, DataParamFillBack<T, List<Object>> biConsumer) {
        try (TXHandle tx = TX.requiresNew();){
            try {
                this.update(constants, entityList, biConsumer);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                tx.markRollback();
                FpmOperateResult<UpdateResult> fpmOperateResult = FpmOperateResult.error(e.getMessage());
                if (tx != null) {
                    if (var5_5 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            var5_5.addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
                return fpmOperateResult;
            }
        }
        return FpmOperateResult.success();
    }

    private Consumer<Integer> getResultConsumer(UpdateResult updateResult) {
        AtomicInteger atomicInteger = new AtomicInteger(0);
        return integer -> {
            int index = atomicInteger.getAndIncrement();
            if (integer <= 0) {
                updateResult.addFailedIndex(index);
            }
        };
    }

    private Object fillNull(IDataEntityProperty property, Object value) {
        if (Objects.nonNull(value)) {
            if (BigDecimal.class.isInstance(value)) {
                return CommonUtils.getIfZeroValue((BigDecimal)value);
            }
            return value;
        }
        Class propertyType = property.getPropertyType();
        if (propertyType.isAssignableFrom(Long.class) || propertyType.isAssignableFrom(Long.TYPE)) {
            return 0L;
        }
        if (propertyType.isAssignableFrom(Integer.class) || propertyType.isAssignableFrom(Integer.TYPE)) {
            return 0;
        }
        if (propertyType.isAssignableFrom(String.class)) {
            return "";
        }
        if (propertyType.isAssignableFrom(Date.class)) {
            return KDDateUtils.now();
        }
        if (propertyType.isAssignableFrom(BigDecimal.class)) {
            return BigDecimal.ZERO;
        }
        if (propertyType.isAssignableFrom(Float.class) || propertyType.isAssignableFrom(Float.TYPE)) {
            return 0.0;
        }
        if (propertyType.isAssignableFrom(Double.class) || propertyType.isAssignableFrom(Double.TYPE)) {
            return 0.0;
        }
        if (propertyType.isAssignableFrom(Boolean.class) || propertyType.isAssignableFrom(Boolean.TYPE)) {
            return false;
        }
        if (propertyType.isAssignableFrom(Character.class) || propertyType.isAssignableFrom(Character.TYPE)) {
            return "";
        }
        throw new KDBizException("unKnow type\uff1a" + propertyType.getName());
    }

    private int getTotalUpdateCount(int[] updateRowArr, Consumer<Integer> resultConsumer) {
        if (Objects.isNull(updateRowArr) || updateRowArr.length == 0) {
            return 0;
        }
        int updateCount = 0;
        for (int i = 0; i < updateRowArr.length; ++i) {
            updateCount += updateRowArr[i];
            resultConsumer.accept(updateRowArr[i]);
        }
        return updateCount;
    }

    private <T> void check(SqlEntity<T> sqlEntity) {
        List<T> entityList;
        String entityName = sqlEntity.getEntityName();
        if (EmptyUtil.isEmpty((String)entityName)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u66f4\u65b0\u5bf9\u5b9e\u4f53\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (String)"DataSaveServiceImpl_5", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
        String updateFields = sqlEntity.getUpdateFields();
        if (EmptyUtil.isEmpty((String)updateFields)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u66f4\u65b0\u5b57\u6bb5\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a", (String)"DataSaveServiceImpl_6", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
        String conditionFields = sqlEntity.getConditionFields();
        if (EmptyUtil.isEmpty((String)conditionFields)) {
            if (sqlEntity.isNeedCondition()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u9700\u8981\u66f4\u65b0\u6761\u4ef6\uff0c\u4e14\u66f4\u65b0\u6761\u4ef6\u5b57\u6bb5\u4e3a\u7a7a", (String)"DataSaveServiceImpl_7", (String)"tmc-fpm-business", (Object[])new Object[0]));
            }
            sqlEntity.setConditionFields("");
        }
        if (EmptyUtil.isEmpty(entityList = sqlEntity.getEntityList())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u5b9e\u4f53\u5bf9\u8c61\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (String)"DataSaveServiceImpl_8", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
    }
}

