/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.dataproc.save.impl;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.fpm.business.dataproc.save.IInOutCollectSaveService;
import kd.tmc.fpm.business.dataproc.save.domain.DataSaveResult;
import kd.tmc.fpm.business.domain.enums.ApplyStatus;
import kd.tmc.fpm.business.domain.model.inoutpool.InoutCollect;
import kd.tmc.fpm.business.mvc.repository.IInoutCollectRepository;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;

public class InOutCollectSaveServiceImpl
implements IInOutCollectSaveService {
    private final IInoutCollectRepository iInoutCollectRepository = FpmServiceFactory.getBizService(IInoutCollectRepository.class);

    @Override
    public void saveOrUpdateReportRelation(List<Long> ids, DataSaveResult dataSaveResult) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        List<InoutCollect> inoutCollectList = this.iInoutCollectRepository.load(ids);
        Map<Long, List<Long>> inOutBillIdAndReportDataIdMap = dataSaveResult.getSourceIdAndIdMap();
        List<DynamicObject> deleteReportDataList = dataSaveResult.getDeleteMainDataList();
        List<DynamicObject> saveReportDataList = dataSaveResult.getSaveMainDataList();
        LinkedList<InoutCollect> updateInoutCollectList = new LinkedList<InoutCollect>();
        for (InoutCollect currInOutData : inoutCollectList) {
            Map reportIdToReportDataMap;
            Long billId = currInOutData.getId();
            List<InoutCollect.InoutReportRelation> inoutReportRelationList = currInOutData.getInoutReportRelationList();
            AtomicBoolean deleteFlag = new AtomicBoolean(false);
            boolean insertFlag = false;
            HashSet reportDataIdSet = new HashSet(inOutBillIdAndReportDataIdMap.get(billId));
            Set reportIdSet = deleteReportDataList.stream().filter(dy -> reportDataIdSet.contains(dy.getPkValue())).map(dy -> (DynamicObject)dy.getParent()).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
            if (!CollectionUtils.isEmpty(reportIdSet)) {
                inoutReportRelationList.removeIf(item -> {
                    if (reportIdSet.contains(item.getPlanReportId())) {
                        deleteFlag.set(true);
                        return true;
                    }
                    return false;
                });
            }
            if (!CollectionUtils.isEmpty(reportIdToReportDataMap = saveReportDataList.stream().filter(dy -> reportDataIdSet.contains(dy.getPkValue())).collect(Collectors.toMap(dy -> {
                DynamicObject reportDy = (DynamicObject)dy.getParent();
                return reportDy.getLong("id");
            }, Function.identity(), (a, b) -> b)))) {
                insertFlag = true;
                List existDBRelationList = inoutReportRelationList.stream().filter(item -> reportIdToReportDataMap.containsKey(item.getPlanReportId())).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(existDBRelationList)) {
                    inoutReportRelationList.removeAll(existDBRelationList);
                }
                reportIdToReportDataMap.forEach((reportId, reportDataDy) -> {
                    InoutCollect.InoutReportRelation relationInfo = this.buildRelationInfo((Long)reportId, (DynamicObject)reportDataDy, currInOutData);
                    inoutReportRelationList.add(relationInfo);
                });
            }
            if (!deleteFlag.get() && !insertFlag) continue;
            ApplyStatus applyStatus = CollectionUtils.isEmpty(inoutReportRelationList) ? ApplyStatus.NOT_APPLY : currInOutData.getApplyStatus();
            currInOutData.setApplyStatus(applyStatus);
            updateInoutCollectList.add(currInOutData);
        }
        if (!CollectionUtils.isEmpty(updateInoutCollectList)) {
            this.iInoutCollectRepository.save(inoutCollectList);
        }
    }

    private InoutCollect.InoutReportRelation buildRelationInfo(Long reportId, DynamicObject reportDataDy, InoutCollect currInOutData) {
        DynamicObject reportDy = (DynamicObject)reportDataDy.getParent();
        InoutCollect.InoutReportRelation relationInfo = new InoutCollect.InoutReportRelation();
        relationInfo.setBodySysId(reportDataDy.getLong("system"));
        relationInfo.setBatchNo(currInOutData.getBatchNo());
        relationInfo.setPlanReport(reportDy.getString("name"));
        relationInfo.setPlanReportId(reportId);
        Long reportTypeId = reportDy.getLong("reportperiod.reporttype.id");
        relationInfo.setReportTypeId(reportTypeId);
        relationInfo.setReportOrgId(reportDataDy.getLong("orgmem"));
        relationInfo.setReportPeriodId(reportDataDy.getLong("periodmem"));
        relationInfo.setReferPlanDate(currInOutData.getCurrentPlanDate());
        relationInfo.setReferPlanAmount(currInOutData.getCurrentPlanAmount());
        return relationInfo;
    }
}

