/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.dataproc.save.impl;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.dataproc.exception.FpmRequestException;
import kd.tmc.fpm.business.dataproc.save.domain.FpmResponse;
import kd.tmc.fpm.business.dataproc.save.domain.ReportDataBatchSaveParam;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.FpmErrorCodeEnum;
import kd.tmc.fpm.business.domain.enums.TemplateType;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.report.BatchSaveSDKReportData;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.mvc.converter.TemplatePOConverter;
import kd.tmc.fpm.business.mvc.converter.utils.ConverterUtils;
import kd.tmc.fpm.business.mvc.repository.IDimensionRepository;
import kd.tmc.fpm.business.mvc.repository.IReportRepository;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;
import kd.tmc.fpm.business.utils.FpmDataServiceHelper;
import org.apache.commons.collections4.CollectionUtils;

public class ReportDataBatchSaveParamTransferStrategy {
    private final IDimensionRepository iDimensionRepository = FpmServiceFactory.getBizService(IDimensionRepository.class);
    private final IReportRepository iReportRepository = FpmServiceFactory.getBizService(IReportRepository.class);
    private FpmResponse<Void> result;
    private FundPlanSystem fundPlanSystem;
    private ReportTemplate reportTemplate;
    private Report report;

    public void process(ReportDataBatchSaveParam saveParam) {
        if (!this.setFundPlanSystem(saveParam.getSystemCode())) {
            this.result = FpmResponse.error(FpmErrorCodeEnum.REQUEST_PARAM_ERROR);
            return;
        }
        if (!this.setAndValidateReportTemplate(this.fundPlanSystem.getId(), saveParam.getTemplateCode())) {
            return;
        }
        Optional<DimMember> reportPeriodOp = this.fundPlanSystem.getMainDimensionByDimType(DimensionType.PERIOD).getAllDimMemberList().stream().filter(dimMember -> Objects.equals(dimMember.getNumber(), saveParam.getReportPeriodCode())).findAny();
        if (!reportPeriodOp.isPresent()) {
            this.result = FpmResponse.error(FpmErrorCodeEnum.REQUEST_PARAM_ERROR);
            return;
        }
        Long reportPeriodId = reportPeriodOp.get().getId();
        Optional<DimMember> reportOrgOp = this.fundPlanSystem.getMainDimensionByDimType(DimensionType.ORG).getAllDimMemberList().stream().filter(dimMember -> Objects.equals(dimMember.getNumber(), saveParam.getReportOrgCode())).findAny();
        if (!reportOrgOp.isPresent()) {
            this.result = FpmResponse.error(FpmErrorCodeEnum.REQUEST_PARAM_ERROR);
            return;
        }
        Long reportOrgId = reportOrgOp.get().getId();
        if (!this.setReport(this.fundPlanSystem.getId(), this.reportTemplate.getId(), reportPeriodId, reportOrgId)) {
            this.result = FpmResponse.error(FpmErrorCodeEnum.NON_EXIST_REPORT);
            return;
        }
        if (!this.validateReportBillStatusIfNeed(saveParam) || !this.validateReportPlanStatusIfNeed(saveParam)) {
            return;
        }
        if (CollectionUtils.isNotEmpty(this.report.getReportDataList())) {
            List<ReportData> sdkReportDataList = this.report.getReportDataList().stream().map(data -> {
                BatchSaveSDKReportData sdkReportData = new BatchSaveSDKReportData((ReportData)data);
                return sdkReportData;
            }).collect(Collectors.toList());
            this.report.setReportDataList(sdkReportDataList);
        }
        try {
            ConverterUtils.convertWithArgs(Report.class, saveParam, this.report, this.fundPlanSystem, reportOrgId);
        }
        catch (FpmRequestException e) {
            this.result = FpmResponse.error(e.getErrorCodeEnum().getCode(), e.getErrorMeg());
            return;
        }
        this.result = FpmResponse.success(null);
    }

    public FpmResponse<Void> getResult() {
        return this.result;
    }

    public Report getReport() {
        return this.report;
    }

    public FundPlanSystem getFundPlanSystem() {
        return this.fundPlanSystem;
    }

    private boolean setFundPlanSystem(String systemCode) {
        QFilter qFilter = new QFilter("number", "=", (Object)systemCode);
        Object[] systemDyArr = TmcDataServiceHelper.load((String)"fpm_bodysysmanage", (String)"id", (QFilter[])qFilter.toArray());
        if (EmptyUtil.isEmpty((Object[])systemDyArr) || systemDyArr.length > 1) {
            return false;
        }
        this.fundPlanSystem = this.iDimensionRepository.loadSystem(systemDyArr[0].getLong("id"));
        return true;
    }

    private boolean setAndValidateReportTemplate(Long systemId, String templateCode) {
        QFilter qFilter = new QFilter("number", "=", (Object)templateCode).and("model", "=", (Object)systemId);
        DynamicObject template = FpmDataServiceHelper.loadSingle("fpm_template", new QFilter[]{qFilter});
        if (EmptyUtil.isEmpty((DynamicObject)template)) {
            this.result = FpmResponse.error(FpmErrorCodeEnum.REQUEST_PARAM_ERROR);
            return false;
        }
        this.reportTemplate = TemplatePOConverter.convertToTemplate(template);
        if (!this.reportTemplate.isMainTable() || this.reportTemplate.getTemplateType() != TemplateType.FIXED) {
            this.result = FpmResponse.error(FpmErrorCodeEnum.ONLY_MAIN_REPORT.getCode(), FpmErrorCodeEnum.ONLY_MAIN_REPORT.getMessage(), this.reportTemplate.getNumber());
            return false;
        }
        return true;
    }

    private boolean setReport(Long systemId, Long templateId, Long reportPeriodId, Long reportOrgId) {
        QFilter qFilter = new QFilter("bodysys", "=", (Object)systemId);
        qFilter.and("template", "=", (Object)templateId);
        qFilter.and("reportperiod", "=", (Object)reportPeriodId);
        qFilter.and("reportorg", "=", (Object)reportOrgId);
        DynamicObject reportDy = TmcDataServiceHelper.loadSingle((String)"fpm_report", (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (EmptyUtil.isEmpty((DynamicObject)reportDy)) {
            return false;
        }
        long reportId = reportDy.getLong("id");
        this.report = this.iReportRepository.loadReportWithAllDimension(reportId);
        return true;
    }

    private boolean validateReportBillStatusIfNeed(ReportDataBatchSaveParam saveParam) {
        boolean validateResult;
        boolean bl = validateResult = EmptyUtil.isEmpty((Object)((Object)saveParam.getBillStatus())) || this.report.getProcessStatus() == saveParam.getBillStatus();
        if (!validateResult) {
            this.result = FpmResponse.error(FpmErrorCodeEnum.INVALID_BILL_STATUS.getCode(), FpmErrorCodeEnum.INVALID_BILL_STATUS.getMessage(), this.report.getNumber(), this.report.getProcessStatus().getName(), saveParam.getBillStatus().getName());
            return false;
        }
        return true;
    }

    private boolean validateReportPlanStatusIfNeed(ReportDataBatchSaveParam saveParam) {
        boolean validateResult;
        boolean bl = validateResult = EmptyUtil.isEmpty((Object)((Object)saveParam.getPlanStatus())) || this.report.getReportStatus() == saveParam.getPlanStatus();
        if (!validateResult) {
            this.result = FpmResponse.error(FpmErrorCodeEnum.INVALID_PLAN_STATUS.getCode(), FpmErrorCodeEnum.INVALID_PLAN_STATUS.getMessage(), this.report.getNumber(), this.report.getReportStatus().getName(), saveParam.getPlanStatus().getName());
            return false;
        }
        return true;
    }
}

