/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.dataproc.save.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fpm.business.dataproc.save.IDataSaveService;
import kd.tmc.fpm.business.dataproc.save.domain.UpdateResult;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.ReportPlanType;
import kd.tmc.fpm.business.domain.enums.ReportProcessStatus;
import kd.tmc.fpm.business.domain.enums.TemplateUseType;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.MetricMember;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.report.SumPlanReport;
import kd.tmc.fpm.business.domain.model.sumplan.DetailEntryReportData;
import kd.tmc.fpm.business.domain.model.sumplan.MainEntryReportData;
import kd.tmc.fpm.business.domain.model.sumplan.SourceIdEntryData;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanParamConfig;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanParamConfigInfo;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanUpdateInfo;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.domain.service.ISumPlanService;
import kd.tmc.fpm.business.mvc.repository.IReportRepository;
import kd.tmc.fpm.business.mvc.repository.dto.ReportQDTO;
import kd.tmc.fpm.business.service.sumreport.service.ISummaryConfigService;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;
import kd.tmc.fpm.business.utils.CommonUtils;
import kd.tmc.fpm.common.trace.IFpmTraceSpan;
import kd.tmc.fpm.common.trace.IFpmTracer;
import org.apache.commons.collections4.CollectionUtils;

public class ReportDataBatchUpperSumService {
    private static final Log logger = LogFactory.getLog(ReportDataBatchUpperSumService.class);
    protected IDataSaveService iDataSaveService;
    protected ISumPlanService iSumPlanService;
    protected IReportRepository iReportRepository = FpmServiceFactory.getBizService(IReportRepository.class);
    private ISummaryConfigService iSummaryConfigService;
    protected Report report;
    protected FundPlanSystem fundPlanSystem;
    protected SumPlanParamConfig sumPlanParamConfig;
    private Map<Long, SumPlanParamConfigInfo> sumOrgConfigMap;
    private List<MetricMember> updateMetricMembers;

    public ReportDataBatchUpperSumService(Report report, FundPlanSystem fundPlanSystem, List<MetricMember> metricMembers) {
        this.iDataSaveService = FpmServiceFactory.getBizService(IDataSaveService.class);
        this.iSumPlanService = FpmServiceFactory.getBizService(ISumPlanService.class);
        this.iSummaryConfigService = FpmServiceFactory.getBizService(ISummaryConfigService.class);
        this.report = report;
        this.fundPlanSystem = fundPlanSystem;
        this.sumPlanParamConfig = this.iSummaryConfigService.getSummaryParamConfig(report);
        this.sumOrgConfigMap = Objects.nonNull(this.sumPlanParamConfig) ? this.sumPlanParamConfig.getConfigInfoList().stream().collect(Collectors.toMap(SumPlanParamConfigInfo::getOrgMemberId, Function.identity(), (a, b) -> b)) : new HashMap<Long, SumPlanParamConfigInfo>(1);
        this.updateMetricMembers = metricMembers;
    }

    public boolean upperSum() {
        try (IFpmTraceSpan span = IFpmTracer.getInstance().createSpan(ReportDataBatchUpperSumService.class.getSimpleName() + "process");){
            logger.info("\u62a5\u8868\u6570\u636e\u6279\u91cf\u5411\u4e0a\u6c47\u603b-\u5f00\u59cb-\u62a5\u8868[{}]", (Object)this.report.getId());
            span.addTag("validate before report upperSum");
            if (!this.validateBeforeReportUpperSum()) {
                boolean bl = false;
                return bl;
            }
            span.addTag("planning report upperSum");
            int successSize = 0;
            ReportData reportData = this.report.getReportDataList().stream().filter(rd -> !rd.isAuxiliaryInfo()).findAny().get();
            Long currReportOrgId = (Long)reportData.getDimValByDimType(DimensionType.ORG);
            boolean allowSumFlag = true;
            while (this.sumOrgConfigMap.containsKey(currReportOrgId) && allowSumFlag) {
                Long parentOrgId = this.sumOrgConfigMap.get(currReportOrgId).getParentId();
                if (Objects.isNull(parentOrgId) || !this.sumOrgConfigMap.containsKey(parentOrgId) || !this.sumOrgConfigMap.get(parentOrgId).isSumAuditNode()) {
                    currReportOrgId = parentOrgId;
                    continue;
                }
                SumPlanReport parentSumPlanReport = this.getSumPlanSimpleReport(parentOrgId, this.report.getCurrentReportPeriod().getId());
                if (Objects.isNull(parentSumPlanReport)) {
                    currReportOrgId = parentOrgId;
                    continue;
                }
                if (!this.sumAtEachLevel(parentOrgId, this.report, parentSumPlanReport)) break;
                currReportOrgId = parentOrgId;
                allowSumFlag = parentSumPlanReport.getProcessStatus() == ReportProcessStatus.AUDIT;
                ++successSize;
            }
            logger.info("\u62a5\u8868\u6570\u636e\u6279\u91cf\u5411\u4e0a\u6c47\u603b-\u7ed3\u675f-\u62a5\u8868[{}]-\u5171\u5411[{}]\u4e2a\u6c47\u603b\u8868\u6210\u529f\u6c47\u603b", (Object)this.report.getId(), (Object)successSize);
        }
        return true;
    }

    private boolean validateBeforeReportUpperSum() {
        if (!this.report.getTemplate().isMainTable() || this.report.getProcessStatus() != ReportProcessStatus.AUDIT || this.report.getTemplate().getTemplateUse() != TemplateUseType.PLANING || CollectionUtils.isEmpty(this.report.getReportDataList())) {
            logger.info("\u62a5\u8868\u6570\u636e\u6279\u91cf\u5411\u4e0a\u6c47\u603b-\u62a5\u8868[{}]\u72b6\u6001[{}][{}][{}]\u4e0d\u7b26\u5408\u8981\u6c42-\u4e0d\u6c47\u603b", new Object[]{this.report.getId(), this.report.getProcessStatus(), this.report.getReportStatus(), this.report.getTemplate().getTemplateUse()});
            return false;
        }
        Optional<ReportData> reportDataOpt = this.report.getReportDataList().stream().filter(rd -> !rd.isAuxiliaryInfo()).findAny();
        if (!reportDataOpt.isPresent()) {
            logger.info("\u62a5\u8868\u6570\u636e\u6279\u91cf\u5411\u4e0a\u6c47\u603b-\u62a5\u8868[{}]\u4e0d\u5b58\u5728\u6709\u6548\u6570\u636e", (Object)this.report.getId());
            return false;
        }
        return true;
    }

    private boolean sumAtEachLevel(Long sumOrgId, Report report, SumPlanReport upperSumReport) {
        ArrayList<Report> reportList = new ArrayList<Report>(1);
        reportList.add(report);
        String dLockName = String.format("%s.%s.%s", CacheKeyUtil.getAcctId(), "planingReportUpperSum", sumOrgId);
        FpmOperateResult upperSumResult = CommonUtils.processInDLock(dLockName, () -> this.iSumPlanService.sdkReportPlanReportUpperSum(reportList, upperSumReport, this.fundPlanSystem, this.updateMetricMembers));
        if (!upperSumResult.isSuccess()) {
            logger.info("\u7f16\u5236\u8868[{}]\u5411\u6c47\u603b\u8868[{}]\u6c47\u603b-\u5931\u8d25", (Object)report.getId(), (Object)upperSumReport.getId());
            return false;
        }
        return this.batchSaveOrUpdate((SumPlanUpdateInfo)upperSumResult.getData());
    }

    private SumPlanReport getSumPlanSimpleReport(Long sumOrgId, Long reportPeriodId) {
        ReportQDTO reportQDTO = new ReportQDTO();
        reportQDTO.setReportOrgId(sumOrgId);
        reportQDTO.setReportPeriodId(reportPeriodId);
        reportQDTO.setReportPlanType(ReportPlanType.SUMPLAN);
        List<Report> sumPlanReportList = this.iReportRepository.loadSimpleReport(reportQDTO, propDTO -> {
            propDTO.setNeedTemplate(true);
            propDTO.setNeedCompanyMember(true);
            propDTO.setNeedPeriodMember(true);
        });
        if (!kd.bos.orm.util.CollectionUtils.isEmpty(sumPlanReportList)) {
            List finalSumPlanReportList = sumPlanReportList.stream().map(item -> (SumPlanReport)item).collect(Collectors.toList());
            return (SumPlanReport)finalSumPlanReportList.get(0);
        }
        return null;
    }

    private boolean batchSaveOrUpdate(SumPlanUpdateInfo sumPlanUpdateInfo) {
        if (Objects.isNull(sumPlanUpdateInfo)) {
            return true;
        }
        List<ReportData> updateReportDataList = sumPlanUpdateInfo.getUpdateReportDataList();
        logger.info("\u5f00\u59cb\u66f4\u65b0\u9700\u8981\u66f4\u65b0\u7684\u7f16\u5236\u6570\u636e\uff1a{}\u6761", (Object)updateReportDataList.size());
        FpmOperateResult<UpdateResult> updateResult = this.iDataSaveService.update(IDataSaveService.Constants.SUM_REPORT_REPORT_DATA_UPDATE_BY_SDK, updateReportDataList, (t, d) -> {
            d.add(t.getPlanAmt());
            d.add(t.getReportPlanAmt());
            d.add(t.getOriginalPlanAmt());
            d.add(t.getPlanReferenceAmt());
            d.add(t.getLockAmt());
            d.add(t.getActAmt());
            d.add(t.getId());
        });
        if (!updateResult.isSuccess()) {
            return false;
        }
        SumPlanReport sumPlanReport = sumPlanUpdateInfo.getSumPlanReport();
        if (Objects.nonNull(sumPlanReport)) {
            FpmOperateResult<Void> saveResult = this.iDataSaveService.saveEntryDataThrow(new ArrayList<SourceIdEntryData>(sumPlanUpdateInfo.getSaveSourceIdEntryDataSet()), sumPlanReport.getId());
            if (!saveResult.isSuccess()) {
                return false;
            }
            return this.saveReportData(sumPlanUpdateInfo, sumPlanReport);
        }
        return true;
    }

    private boolean saveReportData(SumPlanUpdateInfo sumPlanUpdateInfo, SumPlanReport sumPlanReport) {
        List<ReportData> saveReportDataList = sumPlanUpdateInfo.getSaveReportDataList();
        logger.info("\u6c47\u603b\u7f16\u5236\u8868\uff1a{} \u5f00\u59cb\u4fdd\u5b58\u7f16\u5236\u6570\u636e:{}\u6761", (Object)sumPlanReport.getId(), (Object)saveReportDataList.size());
        ArrayList<MainEntryReportData> mainEntryReportDataList = new ArrayList<MainEntryReportData>(saveReportDataList.size());
        ArrayList<DetailEntryReportData> detailEntryReportDataList = new ArrayList<DetailEntryReportData>(saveReportDataList.size());
        for (ReportData reportData : saveReportDataList) {
            MainEntryReportData mainEntryReportData = new MainEntryReportData(reportData);
            mainEntryReportData.setId(reportData.getId());
            mainEntryReportData.setSystemId(sumPlanReport.getSystemId());
            mainEntryReportDataList.add(mainEntryReportData);
            DetailEntryReportData detailEntryReportData = new DetailEntryReportData(reportData);
            detailEntryReportData.setId(reportData.getId());
            detailEntryReportDataList.add(detailEntryReportData);
        }
        FpmOperateResult<Void> saveResult = this.iDataSaveService.saveEntryDataThrow(mainEntryReportDataList, sumPlanReport.getId());
        if (!saveResult.isSuccess()) {
            return false;
        }
        saveResult = this.iDataSaveService.saveEntryDataThrow(detailEntryReportDataList, sumPlanReport.getId());
        return saveResult.isSuccess();
    }
}

