/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.enums;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import kd.tmc.fpm.business.domain.model.dimension.member.AccountMember;
import kd.tmc.fpm.business.domain.model.dimension.member.CurrencyMember;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.OrgMember;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;

public enum DimensionType {
    ORG("Org"),
    PERIOD("Period"),
    CURRENCY("Currency"),
    SUBJECTS("Subjects"),
    SETTLEMENT_TYPE("Settlement Method"),
    COMPANY("Company"),
    DETAILDIM("Detaildim"),
    METRIC("Metric"),
    CUSTOM("Custom"),
    ACCOUNTTYPE("AccountType"),
    AMTTYPE("AmtType"),
    ADJUSTDATATYPE("AdjustDataType");

    private String number;

    private DimensionType(String number) {
        this.number = number;
    }

    public String getNumber() {
        return this.number;
    }

    public static DimensionType getDimsionByNumber(String number) {
        for (DimensionType dt : DimensionType.values()) {
            if (!number.equalsIgnoreCase(dt.getNumber())) continue;
            return dt;
        }
        return null;
    }

    public static Set<DimensionType> getSystemDimensionTypeList() {
        HashSet<DimensionType> dimensionTypeSet = new HashSet<DimensionType>(8);
        dimensionTypeSet.add(ORG);
        dimensionTypeSet.add(PERIOD);
        dimensionTypeSet.add(SUBJECTS);
        dimensionTypeSet.add(CURRENCY);
        return Collections.unmodifiableSet(dimensionTypeSet);
    }

    public static Set<DimensionType> getVirtualDimensionTypeList() {
        HashSet<DimensionType> dimensionTypeSet = new HashSet<DimensionType>(8);
        dimensionTypeSet.add(ACCOUNTTYPE);
        dimensionTypeSet.add(AMTTYPE);
        dimensionTypeSet.add(ADJUSTDATATYPE);
        return Collections.unmodifiableSet(dimensionTypeSet);
    }

    public boolean isMainDimensionType() {
        return this.isOrgDim() || this.isCurrencyDim() || this.isSubjectDim() || this.isPeriodDim() || this.isSettlementType() || this.isCompany() || this.isCustomDim();
    }

    public boolean isDefaultCompareMainDimension() {
        return this.isOrgDim() || this.isCurrencyDim() || this.isSubjectDim() || this.isPeriodDim();
    }

    public boolean isSystemDim() {
        return DimensionType.getSystemDimensionTypeList().contains((Object)this);
    }

    public boolean isCurrencyDim() {
        return this == CURRENCY;
    }

    public boolean isSubjectDim() {
        return this == SUBJECTS;
    }

    public boolean isPeriodDim() {
        return this == PERIOD;
    }

    public boolean isOrgDim() {
        return this == ORG;
    }

    public boolean isMetric() {
        return this == METRIC;
    }

    public boolean isDetailDim() {
        return this == DETAILDIM;
    }

    public boolean isCustomDim() {
        return this == CUSTOM;
    }

    public boolean isCompany() {
        return this == COMPANY;
    }

    public boolean isSettlementType() {
        return this == SETTLEMENT_TYPE;
    }

    public boolean isVirtualDim() {
        return DimensionType.getVirtualDimensionTypeList().contains((Object)this);
    }

    public Class<? extends DimMember> getMemberTypeByDimensionType() {
        switch (this) {
            case SUBJECTS: {
                return AccountMember.class;
            }
            case PERIOD: {
                return PeriodMember.class;
            }
            case CURRENCY: {
                return CurrencyMember.class;
            }
            case ORG: {
                return OrgMember.class;
            }
        }
        return DimMember.class;
    }

    public int getAnalyseDimOrder() {
        return DimensionType.getAnalyseDimOrder(this);
    }

    public static int getAnalyseDimOrder(DimensionType type) {
        switch (type) {
            case ORG: {
                return 0;
            }
            case PERIOD: {
                return 1;
            }
            case SUBJECTS: {
                return 2;
            }
            case CURRENCY: {
                return 3;
            }
        }
        return 99;
    }
}

