/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.enums;

import java.util.Objects;
import kd.tmc.fpm.common.enums.FlowEnum;

public enum FlowType {
    BALANCE("A", 3, 1000001L),
    IN("B", 1, 1000010L),
    OUT("C", 2, 1000011L),
    NONLIMIT("D", 4, 1000100L),
    NETINFLOW("E", 0, 1000101L);

    private String number;
    private int order;
    private long virtualId;

    private FlowType(String number, int order, long virtualId) {
        this.number = number;
        this.order = order;
        this.virtualId = virtualId;
    }

    public String getNumber() {
        return this.number;
    }

    public int getOrder() {
        return this.order;
    }

    public static FlowType getByNumber(String number) {
        for (FlowType mt : FlowType.values()) {
            if (!number.equalsIgnoreCase(mt.getNumber())) continue;
            return mt;
        }
        return null;
    }

    public static FlowType getByVid(long virtualId) {
        for (FlowType mt : FlowType.values()) {
            if (!Objects.equals(mt.getVirtualId(), virtualId)) continue;
            return mt;
        }
        return null;
    }

    public static FlowEnum convertEnum(FlowType type) {
        for (FlowEnum mt : FlowEnum.values()) {
            if (!Objects.equals(mt.getValue(), type.getNumber())) continue;
            return mt;
        }
        return null;
    }

    public long getVirtualId() {
        String virtualIdStr = String.valueOf(this.virtualId);
        virtualIdStr = virtualIdStr + "000000000000";
        return Long.parseLong(virtualIdStr);
    }

    public static boolean isIn(String number) {
        return Objects.equals(number, IN.getNumber());
    }

    public static boolean isOut(String number) {
        return Objects.equals(number, OUT.getNumber());
    }

    public static boolean isBalance(String number) {
        return Objects.equals(number, BALANCE.getNumber());
    }

    public static boolean isNetIn(String number) {
        return Objects.equals(number, NETINFLOW.getNumber());
    }

    public static boolean isNonLimit(String number) {
        return Objects.equals(number, NONLIMIT.getNumber());
    }

    public boolean isNonLimitLevel() {
        return Objects.equals(this.number, IN.getNumber()) || Objects.equals(this.number, OUT.getNumber()) || Objects.equals(this.number, BALANCE.getNumber());
    }

    public static boolean isTotalRowsShowType(String number) {
        return FlowType.isIn(number) || FlowType.isOut(number) || FlowType.isBalance(number) || FlowType.isNetIn(number);
    }

    public static boolean isOppositeFlowType(String flow1, String flow2) {
        return FlowType.isIn(flow1) && FlowType.isOut(flow2) || FlowType.isOut(flow1) && FlowType.isIn(flow2);
    }
}

