/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.enums;

import kd.bos.exception.KDBizException;
import kd.tmc.fbp.common.enums.MultiLangEnumBridge;
import kd.tmc.fpm.business.domain.enums.ITypeEnum;
import kd.tmc.fpm.business.domain.enums.PlanExecuteOpType;

public enum InspectErrorType implements ITypeEnum
{
    REPEAT_OCCUPY_WRITE("REPEAT_OCCUPY_WRITE", new MultiLangEnumBridge("\u91cd\u590d\u9884\u5360/\u5b9e\u5360", "InspectErrorType_0", "tmc-fpm-business")),
    OVERAGE_OCCUPY_RELEASE("OVERAGE_OCCUPY_RELEASE", new MultiLangEnumBridge("\u9884\u5360\u91ca\u653e\u8d85\u989d", "InspectErrorType_1", "tmc-fpm-business")),
    OVERAGE_ACTUAL_RELEASE("OVERAGE_ACTUAL_RELEASE", new MultiLangEnumBridge("\u5b9e\u5360\u8fd4\u8fd8\u8d85\u989d", "InspectErrorType_2", "tmc-fpm-business")),
    NOT_RELEASE_OCCUPY("NOT_RELEASE_OCCUPY", new MultiLangEnumBridge("\u672a\u91ca\u653e\u9884\u5360", "InspectErrorType_3", "tmc-fpm-business")),
    RELEASE_ERROR("RELEASE_ERROR", new MultiLangEnumBridge("\u91ca\u653e\u989d\u5ea6\u4e0d\u6b63\u786e", "InspectErrorType_4", "tmc-fpm-business")),
    OCCUPY_ERROR("OCCUPY_ERROR", new MultiLangEnumBridge("\u9884\u5360\u5f02\u5e38", "InspectErrorType_5", "tmc-fpm-business")),
    OCCUPY_CANCEL_ERROR("OCCUPY_CANCEL_ERROR", new MultiLangEnumBridge("\u53d6\u6d88\u9884\u5360\u5f02\u5e38", "InspectErrorType_6", "tmc-fpm-business")),
    OCCUPY_RELEASE_ERROR("OCCUPY_RELEASE_ERROR", new MultiLangEnumBridge("\u91ca\u653e\u9884\u5360\u5f02\u5e38", "InspectErrorType_7", "tmc-fpm-business")),
    ACTUAL_ERROR("ACTUAL_ERROR", new MultiLangEnumBridge("\u5b9e\u5360\u5f02\u5e38", "InspectErrorType_8", "tmc-fpm-business")),
    ACTUAL_CANCEL_ERROR("ACTUAL_CANCEL_ERROR", new MultiLangEnumBridge("\u53d6\u6d88\u5b9e\u5360\u5f02\u5e38", "InspectErrorType_9", "tmc-fpm-business")),
    ACTUAL_RELEASE_ERROR("ACTUAL_RELEASE_ERROR", new MultiLangEnumBridge("\u5b9e\u5360\u8fd4\u8fd8\u5f02\u5e38", "InspectErrorType_10", "tmc-fpm-business")),
    ACTUAL_UPDATE_ERROR("ACTUAL_UPDATE_ERROR", new MultiLangEnumBridge("\u5b9e\u5360\u66f4\u65b0\u5f02\u5e38", "InspectErrorType_11", "tmc-fpm-business"));

    private String number;
    private MultiLangEnumBridge message;

    public MultiLangEnumBridge getMessage() {
        return this.message;
    }

    private InspectErrorType(String number, MultiLangEnumBridge message) {
        this.number = number;
        this.message = message;
    }

    public String getErrorMessage() {
        return this.message.loadKDString();
    }

    @Override
    public String getNumber() {
        return this.number;
    }

    public static InspectErrorType getInspectErrorTypeByPlanExecuteOp(PlanExecuteOpType planExecuteOpType) {
        switch (planExecuteOpType) {
            case PRE_OCCUPY_WRITE: {
                return OCCUPY_ERROR;
            }
            case PRE_OCCUPY_DELETE: {
                return OCCUPY_CANCEL_ERROR;
            }
            case PRE_OCCUPY_RELEASE: {
                return OCCUPY_RELEASE_ERROR;
            }
            case WRITE: {
                return ACTUAL_ERROR;
            }
            case CANCEL: {
                return ACTUAL_CANCEL_ERROR;
            }
            case RELEASE: {
                return ACTUAL_RELEASE_ERROR;
            }
            case UPDATE: {
                return ACTUAL_UPDATE_ERROR;
            }
        }
        throw new KDBizException("unknown PlanExecuteOpType:" + planExecuteOpType);
    }
}

