/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.enums;

import kd.tmc.fpm.business.domain.enums.ITypeEnum;

public enum PlanExecuteOpType implements ITypeEnum
{
    WRITE("A"),
    CANCEL("B"),
    PRE_OCCUPY_WRITE("C"),
    PRE_OCCUPY_RELEASE("D"),
    PRE_OCCUPY_DELETE("E"),
    RELEASE("F"),
    UPDATE("G"),
    INSPECT("Z");

    private final String value;

    private PlanExecuteOpType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public static PlanExecuteOpType get(String value) {
        if (value == null) {
            return null;
        }
        for (PlanExecuteOpType se : PlanExecuteOpType.values()) {
            if (!value.equals(se.getValue())) continue;
            return se;
        }
        return null;
    }

    @Override
    public String getNumber() {
        return this.value;
    }

    public boolean isPositiveOp() {
        if (this == WRITE) {
            return true;
        }
        return this == PRE_OCCUPY_WRITE;
    }

    public boolean isOccupy() {
        return this == PRE_OCCUPY_WRITE;
    }

    public boolean isOccupyCancel() {
        return this == PRE_OCCUPY_DELETE;
    }

    public boolean isRelease() {
        return this == PRE_OCCUPY_RELEASE || this == RELEASE;
    }

    public boolean isDelete() {
        return this == PRE_OCCUPY_DELETE || this == CANCEL;
    }

    public boolean isOccupyRelease() {
        return this == PRE_OCCUPY_RELEASE;
    }

    public boolean isWrite() {
        return this == WRITE;
    }

    public boolean isOccupyOp() {
        return this == PRE_OCCUPY_WRITE || this == PRE_OCCUPY_DELETE || this == PRE_OCCUPY_RELEASE;
    }

    public boolean isUpdate() {
        return this == UPDATE;
    }

    public boolean isActRelease() {
        return this == RELEASE;
    }

    public boolean isReleaseOrUpdateOrInspect() {
        return this.isUpdate() || this.isActRelease() || this == INSPECT;
    }

    public boolean isReleaseOrUpdate() {
        return this.isUpdate() || this.isActRelease();
    }
}

