/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.formula;

import java.math.BigDecimal;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import kd.bos.exception.KDBizException;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.Expr;
import kd.bos.formula.excel.FormulaException;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.AmountUnit;
import kd.tmc.fpm.business.domain.model.index.node.TreeNode;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.spread.formula.Formula;
import kd.tmc.fpm.business.spread.formula.FormulaOperationValUp;
import kd.tmc.fpm.business.spread.formula.FormulaOperatorSymbol;
import kd.tmc.fpm.business.spread.formula.IFormulaOperator;
import kd.tmc.fpm.business.spread.formula.impl.DAGNode;
import kd.tmc.fpm.business.spread.formula.impl.DAGNodeVisitListener;
import kd.tmc.fpm.business.utils.CommonUtils;
import kd.tmc.fpm.business.utils.MetricValueUtils;
import kd.tmc.fpm.common.enums.AmountUnitEnum;
import kd.tmc.fpm.common.helper.AmountCurrencyRateHelper;
import org.apache.commons.collections.CollectionUtils;

public class CalcTreeNodeVisitListener
implements DAGNodeVisitListener<TreeNode> {
    private Set<TreeNode> reCalcValSet = new HashSet<TreeNode>();
    private Map<TreeNode, Formula> formulaMap;

    public CalcTreeNodeVisitListener() {
    }

    public CalcTreeNodeVisitListener(Map<TreeNode, Formula> formulaMap) {
        this.formulaMap = formulaMap;
    }

    @Override
    public void visit(DAGNode<TreeNode> node) {
        TreeNode treeNode = node.getVal();
        Formula formula = this.formulaMap.get(treeNode);
        List<Object> dataList = treeNode.getDataList();
        if (formula != null && CollectionUtils.isNotEmpty(dataList)) {
            ReportData reportData = (ReportData)dataList.get(0);
            AmountUnit amountUnit = reportData.getAmountUnit();
            if (Objects.isNull((Object)amountUnit)) {
                amountUnit = AmountUnit.ONE;
            }
            reportData.setPlanAmt(this.calculate(formula, ReportData::getPlanAmt, amountUnit));
            reportData.setLockAmt(this.calculate(formula, ReportData::getLockAmt, amountUnit));
            reportData.setActAmt(this.calculate(formula, ReportData::getActAmt, amountUnit));
            reportData.setOriginalPlanAmt(this.calculate(formula, ReportData::getOriginalPlanAmt, amountUnit));
            reportData.setReportPlanAmt(this.calculate(formula, ReportData::getReportPlanAmt, amountUnit));
            reportData.setOffsetAmt(this.calculate(formula, ReportData::getOffsetAmt, amountUnit));
            reportData.setHoldLockAmt(this.calculate(formula, ReportData::getHoldLockAmt, amountUnit));
            reportData.setHoldActAmt(this.calculate(formula, ReportData::getHoldActAmt, amountUnit));
            reportData.setPlanReferenceAmt(this.calculate(formula, ReportData::getPlanReferenceAmt, amountUnit));
            this.reCalcValSet.add(treeNode);
        }
    }

    private BigDecimal calculate(Formula formula, Function<ReportData, BigDecimal> amtFunction, AmountUnit targetUnit) {
        Object result;
        StringBuilder sb = new StringBuilder();
        Deque<IFormulaOperator> rightOperators = formula.getOperator();
        int idx = 0;
        HashMap<String, BigDecimal> variableMap = new HashMap<String, BigDecimal>(rightOperators.size());
        for (IFormulaOperator rightOperator : rightOperators) {
            if (rightOperator instanceof FormulaOperationValUp) {
                String symbol = "x" + idx++;
                sb.append(symbol);
                FormulaOperationValUp formulaOp = (FormulaOperationValUp)rightOperator;
                TreeNode treeNode = (TreeNode)formulaOp.getName();
                List<Object> dataList = treeNode.getDataList();
                if (CollectionUtils.isEmpty(dataList)) {
                    variableMap.put(symbol, BigDecimal.ZERO);
                    continue;
                }
                BigDecimal amt = dataList.stream().map(ReportData.class::cast).map(item -> {
                    AmountUnitEnum targetUnitEnum;
                    BigDecimal currentAmt = CommonUtils.getValueIfNull((BigDecimal)amtFunction.apply((ReportData)item));
                    AmountUnitEnum sourceUnitEnum = AmountUnit.convert(item.getAmountUnit());
                    if (sourceUnitEnum == (targetUnitEnum = AmountUnit.convert(targetUnit))) {
                        return currentAmt;
                    }
                    return AmountCurrencyRateHelper.convertAmt((BigDecimal)currentAmt, (AmountUnitEnum)sourceUnitEnum, (AmountUnitEnum)targetUnitEnum);
                }).map(CommonUtils::getValueIfNull).reduce(BigDecimal.ZERO, BigDecimal::add);
                variableMap.put(symbol, amt);
                continue;
            }
            if (!(rightOperator instanceof FormulaOperatorSymbol)) continue;
            FormulaOperatorSymbol formulaOperatorSymbol = (FormulaOperatorSymbol)rightOperator;
            String opSymbol = formulaOperatorSymbol.getOpSymbol().getSymbol();
            sb.append(opSymbol);
        }
        String amtExpressScript = sb.toString().trim().replace(" ", "");
        if (EmptyUtil.isEmpty((String)amtExpressScript)) {
            return BigDecimal.ZERO;
        }
        String script = MetricValueUtils.handleNum(amtExpressScript);
        Expr expr = FormulaEngine.parseFormula((String)script);
        try {
            result = FormulaEngine.execExcelFormula((Expr)expr, variableMap);
        }
        catch (Throwable ex) {
            if (ex instanceof ArithmeticException) {
                result = BigDecimal.ZERO;
            }
            if (ex instanceof FormulaException) {
                result = BigDecimal.ZERO;
            }
            throw new KDBizException(ex.getMessage());
        }
        return new BigDecimal(result.toString());
    }

    public Set<TreeNode> getReCalcValSet() {
        return this.reCalcValSet;
    }

    public void setReCalcValSet(Set<TreeNode> reCalcValSet) {
        this.reCalcValSet = reCalcValSet;
    }
}

