/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.model.control;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.model.control.ControlTraceInfo;
import kd.tmc.fpm.business.domain.model.control.PlanExecuteRecord;
import kd.tmc.fpm.business.domain.model.report.ReportData;

public class ControlAmountCache {
    private Map<Long, AmountInfo> amountCache = new HashMap<Long, AmountInfo>(128);
    private Map<Long, Long> reportDataIdSystemIdMap = new HashMap<Long, Long>(128);

    public void updateLockAmount(Long reportDataId, BigDecimal updateAmount) {
        if (EmptyUtil.isEmpty((BigDecimal)updateAmount)) {
            return;
        }
        AmountInfo amountInfo = this.getAndCheck(reportDataId);
        BigDecimal amount = amountInfo.getLockDiffAmt();
        amount = amount.add(updateAmount);
        amountInfo.setUpdate(true);
        amountInfo.setLockDiffAmt(amount);
    }

    public void updateActAmount(Long reportDataId, BigDecimal updateAmount) {
        if (EmptyUtil.isEmpty((BigDecimal)updateAmount)) {
            return;
        }
        AmountInfo amountInfo = this.getAndCheck(reportDataId);
        BigDecimal amount = amountInfo.getActDiffAmt();
        amount = amount.add(updateAmount);
        amountInfo.setUpdate(true);
        amountInfo.setActDiffAmt(amount);
    }

    public ControlAmountCache copy() {
        ControlAmountCache controlAmountCache = new ControlAmountCache();
        for (Map.Entry<Long, AmountInfo> entry : this.amountCache.entrySet()) {
            Long reportDataId = entry.getKey();
            AmountInfo amountInfo = entry.getValue();
            controlAmountCache.amountCache.putIfAbsent(reportDataId, amountInfo.copy());
        }
        controlAmountCache.reportDataIdSystemIdMap.putAll(this.reportDataIdSystemIdMap);
        return controlAmountCache;
    }

    public BigDecimal getAvailableLockAmt(Long reportDataId) {
        return this.amountCache.get(reportDataId).getLockDiffAmt();
    }

    public BigDecimal getAvailableActAmt(Long reportDataId) {
        return this.amountCache.get(reportDataId).getActDiffAmt();
    }

    private AmountInfo getAndCheck(Long reportDataId) {
        AmountInfo amountInfo = this.amountCache.get(reportDataId);
        if (Objects.isNull(amountInfo)) {
            throw new KDBizException("reportDataId:" + reportDataId + " amountInfo not init");
        }
        return amountInfo;
    }

    public void init(ControlTraceInfo controlTraceInfo) {
        List<PlanExecuteRecord> executeRecordList = controlTraceInfo.getExecuteRecordList();
        for (PlanExecuteRecord planExecuteRecord : executeRecordList) {
            List<ReportData> matchedReportDataList = planExecuteRecord.getMatchedReportDataList();
            this.init(matchedReportDataList, planExecuteRecord.getSystemId());
        }
    }

    public void init(List<ReportData> reportDataList, Long systemId) {
        for (ReportData reportData : reportDataList) {
            this.initAmountCache(reportData);
            this.reportDataIdSystemIdMap.put(reportData.getId(), systemId);
        }
    }

    public void init(ReportData reportData, Long systemId) {
        this.initAmountCache(reportData);
        this.reportDataIdSystemIdMap.put(reportData.getId(), systemId);
    }

    public List<AmountInfo> getUpdateData() {
        return this.amountCache.values().stream().filter(AmountInfo::isUpdate).filter(a -> a.getActDiffAmt().compareTo(BigDecimal.ZERO) != 0 || a.getLockDiffAmt().compareTo(BigDecimal.ZERO) != 0).collect(Collectors.toList());
    }

    public List<AmountInfo> getAllData() {
        return new ArrayList<AmountInfo>(this.amountCache.values());
    }

    public Long getSystemId(Long reportDataId) {
        return this.reportDataIdSystemIdMap.getOrDefault(reportDataId, 0L);
    }

    private void initAmountCache(ReportData reportData) {
        Long reportDataId = reportData.getId();
        this.amountCache.computeIfAbsent(reportDataId, key -> this.createAmountInfo(reportData));
    }

    public AmountInfo createAmountInfo(ReportData reportData) {
        AmountInfo amountInfo = new AmountInfo();
        amountInfo.setUpdate(false);
        amountInfo.setReportDataId(reportData.getId());
        amountInfo.setReportId(reportData.getReportId());
        amountInfo.setLockDiffAmt(BigDecimal.ZERO);
        amountInfo.setActDiffAmt(BigDecimal.ZERO);
        return amountInfo;
    }

    public class AmountInfo {
        private Long reportDataId;
        private Long reportId;
        private BigDecimal lockDiffAmt;
        private BigDecimal ActDiffAmt;
        private boolean update;

        public Long getReportDataId() {
            return this.reportDataId;
        }

        public void setReportDataId(Long reportDataId) {
            this.reportDataId = reportDataId;
        }

        public Long getReportId() {
            return this.reportId;
        }

        public void setReportId(Long reportId) {
            this.reportId = reportId;
        }

        public BigDecimal getLockDiffAmt() {
            return this.lockDiffAmt;
        }

        public void setLockDiffAmt(BigDecimal lockDiffAmt) {
            this.lockDiffAmt = lockDiffAmt;
        }

        public BigDecimal getActDiffAmt() {
            return this.ActDiffAmt;
        }

        public void setActDiffAmt(BigDecimal actDiffAmt) {
            this.ActDiffAmt = actDiffAmt;
        }

        public boolean isUpdate() {
            return this.update;
        }

        public void setUpdate(boolean update) {
            this.update = update;
        }

        public AmountInfo copy() {
            AmountInfo amountInfo = new AmountInfo();
            amountInfo.setUpdate(this.isUpdate());
            amountInfo.setActDiffAmt(this.getActDiffAmt());
            amountInfo.setLockDiffAmt(this.getLockDiffAmt());
            amountInfo.setReportId(this.getReportId());
            amountInfo.setReportDataId(this.getReportDataId());
            return amountInfo;
        }

        public Long getSystemId() {
            return (Long)ControlAmountCache.this.reportDataIdSystemIdMap.get(this.reportDataId);
        }

        public String toString() {
            return "AmountInfo{reportDataId=" + this.reportDataId + ", reportId=" + this.reportId + ", lockDiffAmt=" + this.lockDiffAmt + ", ActDiffAmt=" + this.ActDiffAmt + ", update=" + this.update + '}';
        }
    }
}

