/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.model.control;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.ControlRequestStatus;
import kd.tmc.fpm.business.domain.enums.PlanExecuteOpType;
import kd.tmc.fpm.business.domain.model.control.ControlAmountCache;
import kd.tmc.fpm.business.domain.service.IUpdateEntity;
import kd.tmc.fpm.business.utils.CommonUtils;

public class ControlRequestUpdateInfo
implements IUpdateEntity<ControlRequestUpdateInfo> {
    private Long id;
    private Long requestId;
    private ControlRequestStatus controlRequestStatus = ControlRequestStatus.INIT;
    private PlanExecuteOpType planExecuteOpType;
    private Map<Long, ControlRequestDetailUpdateInfo> controlRequestDetailUpdateInfoMap = new HashMap<Long, ControlRequestDetailUpdateInfo>(256);
    private boolean amtChanged;

    public static ControlRequestUpdateInfo newInstance(PlanExecuteOpType planExecuteOpType) {
        ControlRequestUpdateInfo controlRequestUpdateInfo = new ControlRequestUpdateInfo();
        controlRequestUpdateInfo.setPlanExecuteOpType(planExecuteOpType);
        return controlRequestUpdateInfo;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getRequestId() {
        return this.requestId;
    }

    public void setRequestId(Long requestId) {
        this.requestId = requestId;
    }

    public ControlRequestStatus getControlRequestStatus() {
        return this.controlRequestStatus;
    }

    public void setControlRequestStatus(ControlRequestStatus controlRequestStatus) {
        this.controlRequestStatus = controlRequestStatus;
    }

    public void updateByAmountInfo(ControlAmountCache.AmountInfo amountInfo) {
        Long reportDataId = amountInfo.getReportDataId();
        Long reportId = amountInfo.getReportId();
        this.amtChanged = true;
        ControlRequestDetailUpdateInfo controlRequestDetailUpdateInfo = this.controlRequestDetailUpdateInfoMap.computeIfAbsent(reportDataId, k -> new ControlRequestDetailUpdateInfo(reportDataId, reportId));
        controlRequestDetailUpdateInfo.setFactExecuteAmt(amountInfo.getActDiffAmt());
        controlRequestDetailUpdateInfo.setLockExecuteAmt(amountInfo.getLockDiffAmt());
    }

    public void addLockExecuteAmt(Long reportDataId, Long reportId, BigDecimal lockExecuteAmt) {
        if (EmptyUtil.isEmpty((BigDecimal)lockExecuteAmt)) {
            return;
        }
        this.amtChanged = true;
        ControlRequestDetailUpdateInfo controlRequestDetailUpdateInfo = this.controlRequestDetailUpdateInfoMap.computeIfAbsent(reportDataId, k -> new ControlRequestDetailUpdateInfo(reportDataId, reportId));
        if (EmptyUtil.isEmpty((Long)controlRequestDetailUpdateInfo.getReportId())) {
            controlRequestDetailUpdateInfo.setReportId(reportId);
        }
        controlRequestDetailUpdateInfo.addLockExecuteAmt(lockExecuteAmt);
    }

    public void addFactExecuteAmt(Long reportDataId, Long reportId, BigDecimal factExecuteAmt) {
        if (EmptyUtil.isEmpty((BigDecimal)factExecuteAmt)) {
            return;
        }
        this.amtChanged = true;
        ControlRequestDetailUpdateInfo controlRequestDetailUpdateInfo = this.controlRequestDetailUpdateInfoMap.computeIfAbsent(reportDataId, k -> new ControlRequestDetailUpdateInfo(reportDataId, reportId));
        if (EmptyUtil.isEmpty((Long)controlRequestDetailUpdateInfo.getReportId())) {
            controlRequestDetailUpdateInfo.setReportId(reportId);
        }
        controlRequestDetailUpdateInfo.addFactExecuteAmt(factExecuteAmt);
    }

    public void addControlRequestDetailUpdateInfo(ControlRequestDetailUpdateInfo detailUpdateInfo) {
        Long reportDataId = detailUpdateInfo.getReportDataId();
        this.controlRequestDetailUpdateInfoMap.put(reportDataId, detailUpdateInfo);
    }

    public void clear() {
        this.amtChanged = true;
        this.controlRequestDetailUpdateInfoMap.clear();
    }

    public void remove(Long reportDataId) {
        if (EmptyUtil.isEmpty((Long)reportDataId)) {
            return;
        }
        this.amtChanged = true;
        this.controlRequestDetailUpdateInfoMap.remove(reportDataId);
    }

    public boolean isAmtChanged() {
        return this.amtChanged;
    }

    public void setAmtChanged(boolean amtChanged) {
        this.amtChanged = amtChanged;
    }

    public BigDecimal getLockExecuteAmt(Long reportDataId) {
        ControlRequestDetailUpdateInfo controlRequestDetailUpdateInfo = this.controlRequestDetailUpdateInfoMap.get(reportDataId);
        if (EmptyUtil.isEmpty((Object)controlRequestDetailUpdateInfo)) {
            return BigDecimal.ZERO;
        }
        return controlRequestDetailUpdateInfo.getLockExecuteAmt();
    }

    public BigDecimal getFactExecuteAmt(Long reportDataId) {
        ControlRequestDetailUpdateInfo controlRequestDetailUpdateInfo = this.controlRequestDetailUpdateInfoMap.get(reportDataId);
        if (EmptyUtil.isEmpty((Object)controlRequestDetailUpdateInfo)) {
            return BigDecimal.ZERO;
        }
        return controlRequestDetailUpdateInfo.getFactExecuteAmt();
    }

    public Set<Long> getReportDataIds() {
        return this.controlRequestDetailUpdateInfoMap.keySet();
    }

    public List<ControlRequestDetailUpdateInfo> getControlRequestDetailUpdateInfos() {
        return this.controlRequestDetailUpdateInfoMap.values().stream().sorted(Comparator.comparing(ControlRequestDetailUpdateInfo::getReportId)).collect(Collectors.toList());
    }

    public PlanExecuteOpType getPlanExecuteOpType() {
        return this.planExecuteOpType;
    }

    public void setPlanExecuteOpType(PlanExecuteOpType planExecuteOpType) {
        this.planExecuteOpType = planExecuteOpType;
    }

    public String toString() {
        return "ControlRequestUpdateInfo{requestId=" + this.requestId + ", controlRequestStatus=" + this.controlRequestStatus + ", controlRequestDetailUpdateInfo=" + CommonUtils.getSubListForSize(new ArrayList<ControlRequestDetailUpdateInfo>(this.controlRequestDetailUpdateInfoMap.values()), 3) + ", planExecuteOpType=" + this.planExecuteOpType + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ControlRequestUpdateInfo that = (ControlRequestUpdateInfo)o;
        return Objects.equals(this.requestId, that.requestId);
    }

    public int hashCode() {
        return Objects.hash(this.requestId);
    }

    @Override
    public void update(ControlRequestUpdateInfo controlRequestUpdateInfo) {
        this.setControlRequestStatus(controlRequestUpdateInfo.getControlRequestStatus());
        if (!controlRequestUpdateInfo.amtChanged) {
            return;
        }
        this.controlRequestDetailUpdateInfoMap.clear();
        this.controlRequestDetailUpdateInfoMap.putAll(controlRequestUpdateInfo.controlRequestDetailUpdateInfoMap);
    }

    public static class ControlRequestDetailUpdateInfo {
        private Long reportDataId;
        private Long reportId;
        private BigDecimal lockExecuteAmt;
        private BigDecimal factExecuteAmt;

        public ControlRequestDetailUpdateInfo(Long reportDataId, Long reportId) {
            this.reportDataId = reportDataId;
            this.reportId = reportId;
            this.lockExecuteAmt = BigDecimal.ZERO;
            this.factExecuteAmt = BigDecimal.ZERO;
        }

        public Long getReportDataId() {
            return this.reportDataId;
        }

        public void setReportDataId(Long reportDataId) {
            this.reportDataId = reportDataId;
        }

        public BigDecimal getLockExecuteAmt() {
            return this.lockExecuteAmt;
        }

        public void addLockExecuteAmt(BigDecimal lockExecuteAmt) {
            this.lockExecuteAmt = this.lockExecuteAmt.add(CommonUtils.getValueIfNull(lockExecuteAmt));
        }

        public BigDecimal getFactExecuteAmt() {
            return this.factExecuteAmt;
        }

        public void addFactExecuteAmt(BigDecimal factExecuteAmt) {
            this.factExecuteAmt = this.factExecuteAmt.add(CommonUtils.getValueIfNull(factExecuteAmt));
        }

        public void setLockExecuteAmt(BigDecimal lockExecuteAmt) {
            this.lockExecuteAmt = lockExecuteAmt;
        }

        public void setFactExecuteAmt(BigDecimal factExecuteAmt) {
            this.factExecuteAmt = factExecuteAmt;
        }

        public Long getReportId() {
            return this.reportId;
        }

        public void setReportId(Long reportId) {
            this.reportId = reportId;
        }

        public String toString() {
            return "ControlRequestDetailUpdateInfo{reportDataId=" + this.reportDataId + ", lockExecuteAmt=" + this.lockExecuteAmt.toPlainString() + ", factExecuteAmt=" + this.factExecuteAmt.toPlainString() + '}';
        }
    }
}

