/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.model.control;

import java.util.Set;
import kd.tmc.fpm.business.domain.model.control.ControlStrategy;
import kd.tmc.fpm.business.domain.model.index.BitMap;

public class DetailControlInfo {
    private ControlStrategy controlStrategy;
    private BitMap<Long, Long> detailDimSubjectBitMap;
    private BitMap<Long, Long> optionDimSubjectBitMap;

    public DetailControlInfo(ControlStrategy controlStrategy) {
        this.controlStrategy = controlStrategy;
        this.detailDimSubjectBitMap = new BitMap(16);
        this.optionDimSubjectBitMap = new BitMap(16);
    }

    public void addDetailDims(Set<Long> detailDims, Long subjectId) {
        this.detailDimSubjectBitMap.addValue(detailDims, subjectId);
    }

    public void addOptionalDims(Set<Long> optionalDims, Long subjectId) {
        this.optionDimSubjectBitMap.addValue(optionalDims, subjectId);
    }

    public Set<Long> getDetailDimIds(Long subjectId) {
        return this.detailDimSubjectBitMap.getKeys(subjectId);
    }

    public Set<Long> getOptionalDimIds(Long subjectId) {
        return this.optionDimSubjectBitMap.getKeys(subjectId);
    }

    public ControlStrategy getControlStrategy() {
        return this.controlStrategy;
    }

    public boolean isEmpty() {
        return this.detailDimSubjectBitMap.isEmpty() && this.optionDimSubjectBitMap.isEmpty();
    }
}

