/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.model.control;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import org.apache.commons.collections4.MapUtils;

public class DimValueListInfo {
    private Map<Long, Dimension> dimensionMap = new HashMap<Long, Dimension>(8);
    private Map<Long, Set<Object>> dimensionValueMap = new HashMap<Long, Set<Object>>(8);

    public void addDimensionValue(Dimension dimension) {
        List<Object> memberIds = dimension.getAllDimMemberList().stream().map(DimMember::getId).distinct().collect(Collectors.toList());
        this.addDimensionListValue(dimension, memberIds);
    }

    public void addDimensionValue(Dimension dimension, Object value) {
        this.addDimensionListValue(dimension, Collections.singletonList(value));
    }

    public void addDimensionListValue(Dimension dimension, List<Object> value) {
        this.dimensionMap.putIfAbsent(dimension.getId(), dimension);
        Set values = this.dimensionValueMap.computeIfAbsent(dimension.getId(), k -> new HashSet(8));
        values.addAll(value);
    }

    public List<Dimension> getDimensionList() {
        return new ArrayList<Dimension>(this.dimensionMap.values());
    }

    public List<List<Object>> getDimValueList() {
        ArrayList<List<Object>> list = new ArrayList<List<Object>>(8);
        List<Dimension> dimensionList = this.getDimensionList();
        for (int i = 0; i < dimensionList.size(); ++i) {
            list.add(new ArrayList(this.dimensionValueMap.get(dimensionList.get(i).getId())));
        }
        return list;
    }

    public boolean isEmpty() {
        return MapUtils.isEmpty(this.dimensionValueMap);
    }

    public boolean contains(Long dimensionId, Object value) {
        return this.dimensionValueMap.getOrDefault(dimensionId, Collections.emptySet()).contains(value);
    }
}

