/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.model.control;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.model.control.PlanExecuteRecord;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.mvc.service.dto.MatchDataResultDTO;

public class DimensionCombination {
    private static Log logger = LogFactory.getLog(DimensionCombination.class);
    private static Set<DimensionType> SYSTEM_DIMENSION_TYPE;
    private Map<Long, Object> dimensionValueMap = new HashMap<Long, Object>(16);
    private Map<Long, Object> detailFieldValueMap = new HashMap<Long, Object>(16);
    private Long reportOrgId;
    private Long reportOrgDimensionId;

    public DimensionCombination(PlanExecuteRecord planExecuteRecord) {
        ReportData reportData = planExecuteRecord.getReportData();
        List<TemplateDim> dimList = reportData.getDimList();
        List<Long> detailMatchedDimIdS = planExecuteRecord.getDetailMatchedDimIdS();
        List<Long> floatMatchedDimIdS = planExecuteRecord.getFloatMatchedDimIdS();
        detailMatchedDimIdS = Objects.isNull(detailMatchedDimIdS) ? Collections.emptyList() : detailMatchedDimIdS;
        floatMatchedDimIdS = Objects.isNull(floatMatchedDimIdS) ? Collections.emptyList() : floatMatchedDimIdS;
        for (TemplateDim templateDim : dimList) {
            Long dimensionId = templateDim.getDimensionId();
            DimensionType dimType = templateDim.getDimType();
            Object dimVal = reportData.getDimValByDimensionId(dimensionId);
            if (SYSTEM_DIMENSION_TYPE.contains((Object)dimType)) {
                if (dimType == DimensionType.ORG) {
                    this.reportOrgId = (Long)dimVal;
                    this.reportOrgDimensionId = dimensionId;
                }
                this.dimensionValueMap.put(dimensionId, dimVal);
                continue;
            }
            if (dimType == DimensionType.DETAILDIM) {
                if (!detailMatchedDimIdS.contains(dimensionId)) continue;
                this.detailFieldValueMap.put(dimensionId, dimVal);
                continue;
            }
            if (!floatMatchedDimIdS.contains(dimensionId)) continue;
            this.detailFieldValueMap.put(dimensionId, dimVal);
        }
    }

    public DimensionCombination(MatchDataResultDTO dataResultDTO) {
        ReportData reportData = dataResultDTO.getReportData();
        List<TemplateDim> dimList = reportData.getDimList();
        Map<TemplateDim, Object> detailMatchInfo = dataResultDTO.getDetailMatchInfo();
        Map<String, Object> objectMap = detailMatchInfo.entrySet().stream().collect(Collectors.toMap(entry -> ((TemplateDim)entry.getKey()).getDimType().getNumber().concat(((TemplateDim)entry.getKey()).getDimensionId().toString()), Map.Entry::getValue));
        for (TemplateDim templateDim : dimList) {
            DimensionType dimType = templateDim.getDimType();
            Long dimensionId = templateDim.getDimensionId();
            Object dimVal = reportData.getDimValByDimType(dimType, templateDim.getDetailDimType());
            if (SYSTEM_DIMENSION_TYPE.contains((Object)dimType)) {
                if (dimType == DimensionType.ORG) {
                    this.reportOrgId = (Long)dimVal;
                    this.reportOrgDimensionId = dimensionId;
                }
                this.dimensionValueMap.put(dimensionId, dimVal);
                continue;
            }
            String key = templateDim.getDimType().getNumber().concat(templateDim.getDimensionId().toString());
            if (!objectMap.containsKey(key)) continue;
            if (dimType == DimensionType.DETAILDIM) {
                this.detailFieldValueMap.put(dimensionId, objectMap.get(key));
                continue;
            }
            this.dimensionValueMap.put(dimensionId, objectMap.get(key));
        }
    }

    public boolean isMatch(DimensionCombination dimensionCombination) {
        logger.info("\u7ef4\u5ea6\u5339\u914d\uff0c\u5f53\u524d\u7ef4\u5ea6\u4fe1\u606f\uff1a{}\uff0c\u5f85\u5339\u914d\u7ef4\u5ea6\u4fe1\u606f\uff1a{}", (Object)this, (Object)dimensionCombination);
        if (!Objects.equals(dimensionCombination.getReportOrgId(), this.reportOrgId)) {
            logger.info("\u7f16\u62a5\u4e3b\u4f53\u4e0d\u4e00\u81f4\uff0c\u5f53\u524d\u7f16\u62a5\u4e3b\u4f53:{},\u5f85\u5339\u914d\u7f16\u62a5\u4e3b\u4f53{}", (Object)this.reportOrgId, (Object)dimensionCombination.getReportOrgId());
            return false;
        }
        Map<Long, Object> dimensionValueMap = dimensionCombination.getDimensionValueMap();
        for (Map.Entry<Long, Object> entry : dimensionValueMap.entrySet()) {
            Long dimensionId = entry.getKey();
            Object value = entry.getValue();
            Object currentVal = this.dimensionValueMap.get(dimensionId);
            if (Objects.equals(currentVal, value)) continue;
            logger.info("\u5339\u914d\u5931\u8d25,\u7ef4\u5ea6\uff1a{}\uff0c\u5bf9\u5e94\u7684\u7ef4\u5ea6\u6210\u5458\u4e0d\u4e00\u81f4,\u5f53\u524d\u7ef4\u5ea6\u6210\u5458{}\uff0c\u5f85\u5339\u914d\u7ef4\u5ea6\u6210\u5458:{}", new Object[]{dimensionId, currentVal, value});
            return false;
        }
        Map<Long, Object> detailFieldValueMap = dimensionCombination.getDetailFieldValueMap();
        for (Map.Entry<Long, Object> entry : detailFieldValueMap.entrySet()) {
            Long dimensionId = entry.getKey();
            Object value = entry.getValue();
            Object currentVal = this.detailFieldValueMap.get(dimensionId);
            if (Objects.equals(currentVal, value)) continue;
            logger.info("\u5339\u914d\u5931\u8d25,\u660e\u7ec6\u5b57\u6bb5\uff1a{}\uff0c\u5bf9\u5e94\u7684\u660e\u7ec6\u5b57\u6bb5\u53d6\u503c,\u5f53\u524d\u53d6\u503c{}\uff0c\u5f85\u5339\u914d\u53d6\u503c:{}", new Object[]{dimensionId, currentVal, value});
            return false;
        }
        return true;
    }

    public Map<Long, Object> getDimensionValueMap() {
        return this.dimensionValueMap;
    }

    public Map<Long, Object> getDetailFieldValueMap() {
        return this.detailFieldValueMap;
    }

    public Long getReportOrgId() {
        return this.reportOrgId;
    }

    public Long getReportOrgDimensionId() {
        return this.reportOrgDimensionId;
    }

    public String toString() {
        return "DimensionCombination{dimensionValueMap=" + this.dimensionValueMap + ", detailFieldValueMap=" + this.detailFieldValueMap + ", reportOrgId=" + this.reportOrgId + ", reportOrgDimensionId=" + this.reportOrgDimensionId + '}';
    }

    static {
        HashSet<DimensionType> dimensionTypeSet = new HashSet<DimensionType>(8);
        dimensionTypeSet.add(DimensionType.ORG);
        dimensionTypeSet.add(DimensionType.SUBJECTS);
        dimensionTypeSet.add(DimensionType.PERIOD);
        dimensionTypeSet.add(DimensionType.CURRENCY);
        SYSTEM_DIMENSION_TYPE = Collections.unmodifiableSet(dimensionTypeSet);
    }
}

