/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.model.control;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.AmountUnit;
import kd.tmc.fpm.business.domain.enums.PlanExecuteOpType;
import kd.tmc.fpm.business.domain.enums.PlanExecuteStatus;
import kd.tmc.fpm.business.domain.model.control.BillBizInfo;
import kd.tmc.fpm.business.domain.model.control.RecordWithoutHoldingInfo;
import kd.tmc.fpm.business.domain.model.control.WaitConsumeInfo;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.utils.CommonUtils;
import kd.tmc.fpm.business.utils.DbRouteUtil;
import kd.tmc.fpm.common.enums.AmountUnitEnum;
import kd.tmc.fpm.common.utils.AmountUtil;
import kd.tmc.fpm.common.utils.NumberUtils;

public class PlanExecuteRecord
implements Serializable,
Cloneable {
    private static final Log logger = LogFactory.getLog(PlanExecuteRecord.class);
    private Long id;
    private Long relateRecordId = 0L;
    private Long originalRecordId = 0L;
    private boolean accurateMatch;
    private String recordNumber;
    private String version;
    private PlanExecuteOpType executeOpType;
    private BillBizInfo billBizInfo;
    private Long matchRuleId;
    private BigDecimal actAmount;
    private BigDecimal bizBillAmount;
    private Boolean deleteStatus;
    private PlanExecuteStatus executeStatus;
    private Long systemId;
    private Long reportOrgId;
    private Date executeDate;
    private String errReason;
    private ReportData reportData;
    private BigDecimal rate;
    private Date rateDate;
    private String bizOrg;
    private String bizCurrency;
    private String bizOpName;
    private Map<TemplateDim, Object> detailMatchInfo;
    private List<ReportData> matchedReportDataList;
    private List<Long> detailMatchedDimIdS;
    private List<Long> floatMatchedDimIdS;
    private BigDecimal unReleaseAmt = BigDecimal.ZERO;
    private BigDecimal beforeReleaseAmt = BigDecimal.ZERO;
    private Long reportTypeId;
    private boolean commited;
    private boolean update;
    private Long controlTraceId;
    private String dbRouteKey;
    private transient List<RecordWithoutHoldingInfo> recordWithoutHoldingInfoList;
    private transient List<WaitConsumeInfo> waitConsumeInfoList;
    private boolean tempConsume;
    private Long requestId;
    private PlanExecuteStatus originalExecuteStatus;
    private Boolean originalDeleteStatus;
    private BigDecimal releasedAmt;
    private Long subjectId;
    private Long bizCurrencyId;
    private BigDecimal aclRemainAmt = BigDecimal.ZERO;
    private Date createTime;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public BillBizInfo getBillBizInfo() {
        return this.billBizInfo;
    }

    public void setBillBizInfo(BillBizInfo billBizInfo) {
        this.billBizInfo = billBizInfo;
    }

    public Long getMatchRuleId() {
        return this.matchRuleId;
    }

    public void setMatchRuleId(Long matchRuleId) {
        this.matchRuleId = matchRuleId;
    }

    public BigDecimal getActAmount() {
        return this.actAmount;
    }

    public void setActAmount(BigDecimal actAmount) {
        this.actAmount = actAmount;
    }

    public Boolean getDeleteStatus() {
        return this.deleteStatus;
    }

    public void setDeleteStatus(Boolean deleteStatus) {
        this.deleteStatus = deleteStatus;
    }

    public PlanExecuteStatus getExecuteStatus() {
        return this.executeStatus;
    }

    public void setExecuteStatus(PlanExecuteStatus executeStatus) {
        this.executeStatus = executeStatus;
    }

    public Long getSystemId() {
        return this.systemId;
    }

    public void setSystemId(Long systemId) {
        this.systemId = systemId;
    }

    public Long getReportOrgId() {
        return this.reportOrgId;
    }

    public void setReportOrgId(Long reportOrgId) {
        this.reportOrgId = reportOrgId;
    }

    public Date getExecuteDate() {
        return this.executeDate;
    }

    public void setExecuteDate(Date executeDate) {
        this.executeDate = executeDate;
    }

    public String getErrReason() {
        return this.errReason;
    }

    public void setErrReason(String errReason) {
        this.errReason = errReason;
    }

    public ReportData getReportData() {
        return this.reportData;
    }

    public void setReportData(ReportData reportData) {
        this.reportData = reportData;
    }

    public BigDecimal getRate() {
        return this.rate;
    }

    public void setRate(BigDecimal rate) {
        this.rate = rate;
    }

    public Date getRateDate() {
        return this.rateDate;
    }

    public void setRateDate(Date rateDate) {
        this.rateDate = rateDate;
    }

    public PlanExecuteOpType getExecuteOpType() {
        return this.executeOpType;
    }

    public void setExecuteOpType(PlanExecuteOpType executeOpType) {
        this.executeOpType = executeOpType;
    }

    public String getBizOrg() {
        return this.bizOrg;
    }

    public void setBizOrg(String bizOrg) {
        this.bizOrg = bizOrg;
    }

    public String getBizCurrency() {
        return this.bizCurrency;
    }

    public void setBizCurrency(String bizCurrency) {
        this.bizCurrency = bizCurrency;
    }

    public String getBizOpName() {
        return this.bizOpName;
    }

    public void setBizOpName(String bizOpName) {
        this.bizOpName = bizOpName;
    }

    public Map<TemplateDim, Object> getDetailMatchInfo() {
        return this.detailMatchInfo;
    }

    public void setDetailMatchInfo(Map<TemplateDim, Object> detailMatchInfo) {
        this.detailMatchInfo = detailMatchInfo;
    }

    public List<ReportData> getMatchedReportDataList() {
        return this.matchedReportDataList;
    }

    public void setMatchedReportDataList(List<ReportData> matchedReportDataList) {
        this.matchedReportDataList = matchedReportDataList;
    }

    public Long getRelateRecordId() {
        return this.relateRecordId;
    }

    public void setRelateRecordId(Long relateRecordId) {
        this.relateRecordId = relateRecordId;
    }

    public Long getOriginalRecordId() {
        return this.originalRecordId;
    }

    public void setOriginalRecordId(Long originalRecordId) {
        this.originalRecordId = originalRecordId;
    }

    public BigDecimal getBizBillAmount() {
        return this.bizBillAmount;
    }

    public void setBizBillAmount(BigDecimal bizBillAmount) {
        this.bizBillAmount = bizBillAmount;
    }

    public String getRecordNumber() {
        return this.recordNumber;
    }

    public void setRecordNumber(String recordNumber) {
        this.recordNumber = recordNumber;
    }

    public boolean getAccurateMatch() {
        return this.accurateMatch;
    }

    public void setAccurateMatch(boolean accurateMatch) {
        this.accurateMatch = accurateMatch;
    }

    public boolean isUpdate() {
        return this.update;
    }

    public void markUpdate() {
        this.update = true;
    }

    public Long getBizCurrencyId() {
        return this.bizCurrencyId;
    }

    public void setBizCurrencyId(Long bizCurrencyId) {
        this.bizCurrencyId = bizCurrencyId;
    }

    public BigDecimal getAclRemainAmt() {
        return this.aclRemainAmt;
    }

    public void setAclRemainAmt(BigDecimal aclRemainAmt) {
        this.aclRemainAmt = aclRemainAmt;
    }

    public void updateAclRemainAmt(BigDecimal diffAmt) {
        this.aclRemainAmt = this.aclRemainAmt.add(CommonUtils.getValueIfNull(diffAmt));
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public PlanExecuteRecord copy(Consumer<PlanExecuteRecord> consumer) {
        PlanExecuteRecord clone = this.clone();
        clone.setRelateRecordId(0L);
        clone.setDeleteStatus(Boolean.FALSE);
        clone.setBizOpName("");
        clone.setExecuteStatus(PlanExecuteStatus.WITHHOLDING);
        clone.setOriginalRecordId(0L);
        clone.setRecordWithoutHoldingInfoList(new ArrayList<RecordWithoutHoldingInfo>(1));
        clone.setActAmount(BigDecimal.ZERO);
        clone.setUnReleaseAmt(BigDecimal.ZERO);
        clone.setReleasedAmt(BigDecimal.ZERO);
        clone.setAclRemainAmt(BigDecimal.ZERO);
        clone.setRequestId(0L);
        clone.setOriginalExecuteStatus(clone.getExecuteStatus());
        clone.setOriginalDeleteStatus(clone.getDeleteStatus());
        if (EmptyUtil.isEmpty((String)clone.getDbRouteKey())) {
            clone.setDbRouteKey(DbRouteUtil.getDbRouteKey(clone.getBillBizInfo().getEntityType()));
        }
        if (Objects.isNull(consumer)) {
            return clone;
        }
        consumer.accept(clone);
        return clone;
    }

    public PlanExecuteRecord clone() {
        try {
            PlanExecuteRecord record = (PlanExecuteRecord)super.clone();
            record.setId(DB.genLongId((String)EntityMetadataCache.getDataEntityType((String)"fpm_executeplan").getAlias()));
            record.setExecuteDate(new Date());
            return record;
        }
        catch (CloneNotSupportedException e) {
            logger.error((Throwable)e);
            return new PlanExecuteRecord();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlanExecuteRecord that = (PlanExecuteRecord)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return "PlanExecuteRecord{id=" + this.id + ",recordNumber=" + this.recordNumber + ",executeOpType=" + this.executeOpType + ",executeStatus=" + (Object)((Object)this.executeStatus) + ", actAmount=" + this.actAmount + ", accurateMatch=" + this.accurateMatch + ", originalRecordId=" + this.originalRecordId + ", relateRecordId=" + this.relateRecordId + ", deleteStatus=" + this.deleteStatus + ", actAmount=" + this.actAmount + '}';
    }

    public BigDecimal getReportActAmount() {
        return this.getReportActAmount(this.actAmount);
    }

    public BigDecimal getReportActAmount(BigDecimal actAmt) {
        if (this.reportData == null) {
            return actAmt;
        }
        AmountUnit amountUnit = this.reportData.getAmountUnit();
        BigDecimal realAmount = AmountUtil.convert((AmountUnitEnum)AmountUnitEnum.ONE, (AmountUnitEnum)((AmountUnitEnum)AmountUnitEnum.valueOf(AmountUnitEnum.class, (String)amountUnit.name())), (BigDecimal)actAmt);
        return realAmount;
    }

    public boolean isAccurateMatch() {
        return this.accurateMatch;
    }

    public List<Long> getDetailMatchedDimIdS() {
        if (Objects.isNull(this.detailMatchedDimIdS)) {
            this.detailMatchedDimIdS = new ArrayList<Long>(1);
        }
        return this.detailMatchedDimIdS;
    }

    public void setDetailMatchedDimIdS(List<Long> detailMatchedDimIdS) {
        this.detailMatchedDimIdS = detailMatchedDimIdS;
    }

    public List<Long> getFloatMatchedDimIdS() {
        if (Objects.isNull(this.floatMatchedDimIdS)) {
            this.floatMatchedDimIdS = new ArrayList<Long>(1);
        }
        return this.floatMatchedDimIdS;
    }

    public void setFloatMatchedDimIdS(List<Long> floatMatchedDimIdS) {
        this.floatMatchedDimIdS = floatMatchedDimIdS;
    }

    public BigDecimal getUnReleaseAmt() {
        return this.unReleaseAmt;
    }

    public void setUnReleaseAmt(BigDecimal unReleaseAmt) {
        this.unReleaseAmt = unReleaseAmt;
        this.releasedAmt = this.actAmount.subtract(this.unReleaseAmt);
    }

    public Long getReportTypeId() {
        return this.reportTypeId;
    }

    public void setReportTypeId(Long reportTypeId) {
        this.reportTypeId = reportTypeId;
    }

    public Long getControlTraceId() {
        return this.controlTraceId;
    }

    public void setControlTraceId(Long controlTraceId) {
        this.controlTraceId = controlTraceId;
    }

    public List<RecordWithoutHoldingInfo> getRecordWithoutHoldingInfoList() {
        return this.recordWithoutHoldingInfoList;
    }

    public void setRecordWithoutHoldingInfoList(List<RecordWithoutHoldingInfo> recordWithoutHoldingInfoList) {
        this.recordWithoutHoldingInfoList = recordWithoutHoldingInfoList;
    }

    public void clearMark() {
        this.update = false;
    }

    public List<WaitConsumeInfo> getWaitConsumeInfoList() {
        return this.waitConsumeInfoList;
    }

    public void setWaitConsumeInfoList(List<WaitConsumeInfo> waitConsumeInfoList) {
        this.waitConsumeInfoList = waitConsumeInfoList;
    }

    public String getDbRouteKey() {
        return this.dbRouteKey;
    }

    public void setDbRouteKey(String dbRouteKey) {
        this.dbRouteKey = dbRouteKey;
    }

    public boolean isTempConsume() {
        return this.tempConsume;
    }

    public boolean isNotTempConsume() {
        return !this.tempConsume;
    }

    public void markTempConsume() {
        this.tempConsume = true;
    }

    public Long getRequestId() {
        return this.requestId;
    }

    public void setRequestId(Long requestId) {
        this.requestId = requestId;
    }

    public BigDecimal getBeforeReleaseAmt() {
        return this.beforeReleaseAmt;
    }

    public void setBeforeReleaseAmt(BigDecimal beforeReleaseAmt) {
        this.beforeReleaseAmt = beforeReleaseAmt;
    }

    public void updateUnReleaseAmt(BigDecimal releaseAmt) {
        if (this.unReleaseAmt.compareTo(releaseAmt = releaseAmt.abs()) >= 0) {
            this.unReleaseAmt = this.unReleaseAmt.subtract(releaseAmt);
            this.releasedAmt = this.releasedAmt.add(releaseAmt);
            return;
        }
        this.unReleaseAmt = BigDecimal.ZERO;
        this.releasedAmt = this.actAmount;
    }

    public Map<Long, ReportData> getMatchedReportDataMap() {
        if (EmptyUtil.isEmpty(this.matchedReportDataList)) {
            return Collections.emptyMap();
        }
        return this.matchedReportDataList.stream().collect(Collectors.toMap(ReportData::getId, Function.identity(), (a, b) -> a));
    }

    public PlanExecuteStatus getOriginalExecuteStatus() {
        return this.originalExecuteStatus;
    }

    public void setOriginalExecuteStatus(PlanExecuteStatus originalExecuteStatus) {
        this.originalExecuteStatus = originalExecuteStatus;
    }

    public Boolean getOriginalDeleteStatus() {
        return this.originalDeleteStatus;
    }

    public void setOriginalDeleteStatus(Boolean originalDeleteStatus) {
        this.originalDeleteStatus = originalDeleteStatus;
    }

    public BigDecimal getReleasedAmt() {
        return this.releasedAmt;
    }

    public void setReleasedAmt(BigDecimal releasedAmt) {
        this.releasedAmt = releasedAmt;
    }

    public Long getSubjectId() {
        return this.subjectId;
    }

    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }

    public boolean isAllRelease() {
        BigDecimal currentActAmt = CommonUtils.getValueIfNull(this.actAmount);
        BigDecimal currentReleaseAmt = CommonUtils.getValueIfNull(this.releasedAmt);
        BigDecimal currentRemainAmt = currentActAmt.subtract(currentReleaseAmt);
        return currentActAmt.compareTo(BigDecimal.ZERO) >= 0 ? currentRemainAmt.compareTo(BigDecimal.ZERO) <= 0 : currentRemainAmt.compareTo(BigDecimal.ZERO) >= 0;
    }

    public boolean isNotAllRelease() {
        return !this.isAllRelease();
    }

    public boolean isNotAllReleaseForActual() {
        return NumberUtils.notEquals((BigDecimal)BigDecimal.ZERO, (BigDecimal)CommonUtils.getValueIfNull(this.aclRemainAmt));
    }
}

