/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.model.control;

import java.math.BigDecimal;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fpm.business.domain.enums.PlanExecuteOpType;
import kd.tmc.fpm.business.domain.model.control.DimensionCombination;
import kd.tmc.fpm.business.domain.model.control.PlanExecuteRecord;

public class PlanRecordInfo {
    private Long billId;
    private String entityName;
    private Long reportOrgId;
    private Long reportTypeId;
    private BigDecimal actAmt;
    private DimensionCombination dimensionCombination;
    private PlanExecuteRecord planExecuteRecord;
    private PlanExecuteOpType planExecuteOpType;
    private static Log logger = LogFactory.getLog(PlanRecordInfo.class);

    public PlanRecordInfo(PlanExecuteRecord planExecuteRecord) {
        this.planExecuteRecord = planExecuteRecord;
        this.billId = planExecuteRecord.getBillBizInfo().getBillId();
        this.dimensionCombination = new DimensionCombination(planExecuteRecord);
        this.reportOrgId = this.dimensionCombination.getReportOrgId();
        this.reportTypeId = planExecuteRecord.getReportTypeId();
        this.planExecuteOpType = planExecuteRecord.getExecuteOpType();
        this.entityName = planExecuteRecord.getBillBizInfo().getEntityType();
        this.actAmt = planExecuteRecord.getActAmount();
    }

    public Long getBillId() {
        return this.billId;
    }

    public Long getReportOrgId() {
        return this.reportOrgId;
    }

    public DimensionCombination getDimensionCombination() {
        return this.dimensionCombination;
    }

    public PlanExecuteRecord getPlanExecuteRecord() {
        return this.planExecuteRecord;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public PlanExecuteOpType getPlanExecuteOpType() {
        return this.planExecuteOpType;
    }

    public BigDecimal getActAmt() {
        return this.actAmt;
    }

    public Long getReportTypeId() {
        return this.reportTypeId;
    }

    public boolean isMatch(PlanRecordInfo planRecordInfo) {
        return this.dimensionCombination.isMatch(planRecordInfo.getDimensionCombination());
    }
}

