/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.model.dimension;

import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.tmc.fpm.business.domain.enums.DetailDimType;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.ReportPeriodType;
import kd.tmc.fpm.business.domain.model.template.AuxiliaryField;
import kd.tmc.fpm.common.enums.DimensionRelEnum;
import kd.tmc.fpm.common.utils.FpmSerializeUtil;

public class FundPlanSystem
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long id;
    private String name;
    private String number;
    private Long orgId;
    private Long currencyId;
    private String currencyName;
    private Long exchangeRateId;
    private boolean enable;
    private List<ReportPeriodType> reportTypeList;
    private List<Long> adminIdList;
    private List<Dimension> dimList;
    private List<AuxiliaryField> auxiliaryFieldList;
    private String shrekKey;

    public List<Dimension> getMainDimList() {
        return this.dimList.stream().filter(Objects::nonNull).filter(e -> DimensionType.DETAILDIM != e.getDimType()).collect(Collectors.toList());
    }

    public List<Dimension> getDetailDimList() {
        return this.dimList.stream().filter(Objects::nonNull).filter(o -> DimensionType.DETAILDIM == o.getDimType()).collect(Collectors.toList());
    }

    public Dimension getMainDimensionByDimType(DimensionType dimType) {
        return this.dimList.stream().filter(Objects::nonNull).filter(o -> dimType == o.getDimType()).findAny().orElse(null);
    }

    public List<Dimension> getCustomDimensionByDimType() {
        return this.dimList.stream().filter(Objects::nonNull).filter(o -> DimensionType.CUSTOM == o.getDimType()).sorted(Comparator.comparing(o -> DimensionRelEnum.valueOf((String)o.getDimensionRel()).getOrder(), Comparator.reverseOrder())).collect(Collectors.toList());
    }

    public Dimension getMainDimensionByDimensionId(Long dimensionId) {
        return this.dimList.stream().filter(Objects::nonNull).filter(o -> Objects.equals(dimensionId, o.getId())).findAny().orElse(null);
    }

    public Dimension getDetailDimensionByDetailType(DetailDimType detailDimType) {
        return this.dimList.stream().filter(o -> detailDimType == o.getDetailDimType()).findAny().orElse(null);
    }

    public ReportPeriodType getPeriodTypeByPeriodTypeId(Long periodTypeId) {
        return this.reportTypeList.stream().filter(o -> periodTypeId.equals(o.getReportPeriodId())).findAny().orElse(null);
    }

    public FundPlanSystem clone() {
        return (FundPlanSystem)FpmSerializeUtil.deserialize((String)FpmSerializeUtil.serialize((Object)this), FundPlanSystem.class);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public Long getOrgId() {
        return this.orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public Long getCurrencyId() {
        return this.currencyId;
    }

    public void setCurrencyId(Long currencyId) {
        this.currencyId = currencyId;
    }

    public String getCurrencyName() {
        return this.currencyName;
    }

    public void setCurrencyName(String currencyName) {
        this.currencyName = currencyName;
    }

    public Long getExchangeRateId() {
        return this.exchangeRateId;
    }

    public void setExchangeRateId(Long exchangeRateId) {
        this.exchangeRateId = exchangeRateId;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public List<ReportPeriodType> getReportTypeList() {
        return this.reportTypeList;
    }

    public void setReportTypeList(List<ReportPeriodType> reportTypeList) {
        this.reportTypeList = reportTypeList;
    }

    public List<Long> getAdminIdList() {
        return this.adminIdList;
    }

    public void setAdminIdList(List<Long> adminIdList) {
        this.adminIdList = adminIdList;
    }

    public List<Dimension> getDimList() {
        return this.dimList;
    }

    public void setDimList(List<Dimension> dimList) {
        this.dimList = dimList;
    }

    public List<AuxiliaryField> getAuxiliaryFieldList() {
        return this.auxiliaryFieldList;
    }

    public void setAuxiliaryFieldList(List<AuxiliaryField> auxiliaryFieldList) {
        this.auxiliaryFieldList = auxiliaryFieldList;
    }

    public String getShrekKey() {
        return this.shrekKey;
    }

    public void setShrekKey(String shrekKey) {
        this.shrekKey = shrekKey;
    }
}

