/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.model.dimension.member;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import kd.tmc.fpm.business.domain.enums.MemberType;

public class DimMember
implements Serializable {
    private Long id;
    private String name;
    private String number;
    private String longNumber;
    private MemberType memberType;
    private List<DimMember> children = new ArrayList<DimMember>();
    private DimMember parent;
    private Long parentId;
    private int level;
    private boolean isLeaf;
    private boolean enable;
    private Long sourceId;
    private Long dimensionId;
    private String sortCode;
    private String shrekKey;
    private String sumType;

    public List<DimMember> getAllChildMember() {
        ArrayList<DimMember> allMemberList = new ArrayList<DimMember>();
        this.getChildMember(this, allMemberList);
        return allMemberList;
    }

    private void getChildMember(DimMember member, List<DimMember> outMemberList) {
        if (member != this) {
            outMemberList.add(member);
        }
        if (member.isLeaf || member.getChildren() == null) {
            return;
        }
        for (DimMember child : member.getChildren()) {
            this.getChildMember(child, outMemberList);
        }
    }

    public List<DimMember> getAllParentMember() {
        ArrayList<DimMember> result = new ArrayList<DimMember>(16);
        this.getParentMember(this, result);
        return result;
    }

    private void getParentMember(DimMember member, List<DimMember> outMemberList) {
        DimMember parent = member.getParent();
        if (parent == null) {
            return;
        }
        outMemberList.add(parent);
        this.getParentMember(parent, outMemberList);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getLongNumber() {
        return this.longNumber;
    }

    public void setLongNumber(String longNumber) {
        this.longNumber = longNumber;
    }

    public MemberType getMemberType() {
        return this.memberType;
    }

    public void setMemberType(MemberType memberType) {
        this.memberType = memberType;
    }

    public List<DimMember> getChildren() {
        return this.children;
    }

    public void setChildren(List<DimMember> children) {
        this.children = children;
    }

    public DimMember getParent() {
        return this.parent;
    }

    public void setParent(DimMember parent) {
        this.parent = parent;
    }

    public Long getParentId() {
        return this.parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }

    public void setLeaf(boolean leaf) {
        this.isLeaf = leaf;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public Long getSourceId() {
        return this.sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public Long getDimensionId() {
        return this.dimensionId;
    }

    public void setDimensionId(Long dimensionId) {
        this.dimensionId = dimensionId;
    }

    public String getShrekKey() {
        return this.shrekKey;
    }

    public void setShrekKey(String shrekKey) {
        this.shrekKey = shrekKey;
    }

    public String getSumType() {
        return this.sumType;
    }

    public void setSumType(String sumType) {
        this.sumType = sumType;
    }

    public String getSortCode() {
        return this.sortCode;
    }

    public void setSortCode(String sortCode) {
        this.sortCode = sortCode;
    }

    public String toString() {
        return "DimMember{id=" + this.id + ", name='" + this.name + '\'' + ", number='" + this.number + '\'' + ", longNumber='" + this.longNumber + '\'' + ", memberType=" + (Object)((Object)this.memberType) + ", parentId=" + this.parentId + ", level=" + this.level + ", isLeaf=" + this.isLeaf + ", enable=" + this.enable + ", sourceId=" + this.sourceId + '}';
    }

    public DimMember copy() {
        DimMember dimMember = this.create();
        dimMember.setEnable(this.enable);
        dimMember.setId(this.id);
        dimMember.setNumber(this.number);
        dimMember.setName(this.name);
        dimMember.setLongNumber(this.longNumber);
        dimMember.setSourceId(this.sourceId);
        dimMember.setDimensionId(this.dimensionId);
        dimMember.setChildren(new ArrayList<DimMember>(1));
        dimMember.setShrekKey(this.shrekKey);
        dimMember.setSumType(this.sumType);
        dimMember.setMemberType(this.memberType);
        dimMember.setParentId(this.parentId);
        dimMember.setParent(this.parent);
        dimMember.setLevel(this.level);
        dimMember.setLeaf(this.isLeaf);
        dimMember.setLeaf(this.isLeaf);
        dimMember.setSortCode(this.sortCode);
        return dimMember;
    }

    protected DimMember create() {
        return new DimMember();
    }
}

