/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.model.dimension.member;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.tmc.fpm.business.domain.enums.PeriodType;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;

public class PeriodMember
extends DimMember {
    private Long periodTypeId;
    private Date startDate;
    private Date endDate;
    private PeriodType periodType;

    @Override
    public PeriodMember copy() {
        PeriodMember newMember = (PeriodMember)super.copy();
        newMember.setPeriodType(this.getPeriodType());
        newMember.setStartDate(this.getStartDate());
        newMember.setEndDate(this.getEndDate());
        newMember.setPeriodTypeId(this.getPeriodTypeId());
        newMember.setChildren(new ArrayList<DimMember>(this.getChildren()));
        return newMember;
    }

    public List<PeriodMember> getChildMemberByPeriodTypeAndPeriodId(PeriodType periodType, Long periodTypeId) {
        List<DimMember> children;
        ArrayList<PeriodMember> targetList = new ArrayList<PeriodMember>(10);
        if (periodType == PeriodType.YEAR) {
            children = new ArrayList<DimMember>(1);
            children.add(this);
        } else {
            children = this.getChildren();
        }
        this.getChildMember(targetList, children, periodType, periodTypeId);
        return targetList;
    }

    public List<PeriodMember> getAllMemberByPeriodTypeAndPeriodId(PeriodType periodType, Long periodTypeId) {
        List<DimMember> children;
        ArrayList<PeriodMember> targetList = new ArrayList<PeriodMember>(10);
        if (this.getPeriodType() == periodType && this.getPeriodTypeId().equals(periodTypeId)) {
            children = new ArrayList<DimMember>(1);
            children.add(this);
        } else {
            children = this.getChildren();
        }
        this.getChildMember(targetList, children, periodType, periodTypeId);
        return targetList;
    }

    private void getChildMember(List<PeriodMember> targetList, List<DimMember> memberList, PeriodType periodType, Long periodTypeId) {
        if (memberList == null || memberList.size() == 0) {
            return;
        }
        for (DimMember member : memberList) {
            PeriodMember periodMember = (PeriodMember)member;
            if (periodMember.getPeriodType() != periodType) {
                this.getChildMember(targetList, member.getChildren(), periodType, periodTypeId);
                continue;
            }
            if (!periodMember.getPeriodTypeId().equals(periodTypeId)) continue;
            targetList.add(periodMember);
        }
    }

    public Long getPeriodTypeId() {
        return this.periodTypeId;
    }

    public void setPeriodTypeId(Long periodTypeId) {
        this.periodTypeId = periodTypeId;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public PeriodType getPeriodType() {
        return this.periodType;
    }

    public void setPeriodType(PeriodType periodType) {
        this.periodType = periodType;
    }

    @Override
    protected DimMember create() {
        return new PeriodMember();
    }
}

